<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Fixed Charge'); ?></th>
                                    <th><?php echo app('translator')->get('Percent Charge'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $country->countryDeliveryMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countryDeliveryMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $deliveryMethod = $countryDeliveryMethod->deliveryMethod;
                                        $deliveryCharge = $countryDeliveryMethod->charge;
                                    ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(__($deliveryMethod->name)); ?></td>
                                        <td>
                                            <?php echo e(showAmount(@$deliveryCharge->fixed_charge, currencyFormat: false)); ?>

                                            <?php echo e(__($country->currency)); ?>

                                        </td>
                                        <td><?php echo e(showAmount(@$deliveryCharge->percent_charge, currencyFormat: false)); ?>%</td>
                                        <td>
                                            <button class="btn btn-sm btn-outline--primary btnSetCharge"
                                                data-method_name="<?php echo e(__(@$deliveryMethod->name)); ?>"
                                                data-id="<?php echo e(@$deliveryMethod->id); ?>"
                                                data-fixed_charge="<?php echo e(@$deliveryCharge->fixed_charge); ?>"
                                                data-percent_charge="<?php echo e(@$deliveryCharge->percent_charge); ?>"><i
                                                    class="las la-coins"></i><?php echo app('translator')->get('Set Charge'); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%">
                                            <?php echo app('translator')->get('No service added for this country yet. You need to add services'); ?> <a
                                                href="<?php echo e(route('admin.service.index', $country->id)); ?>"><?php echo app('translator')->get('From Here'); ?></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="chargeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Set Charge for'); ?> <span class="methodName fw-bold"></span></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.country.charges.save', $country->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="delivery_method_id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Fixed Charge'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" min="0" class="form-control" name="fixed_charge"
                                    required>
                                <span class="input-group-text"><?php echo e(__($country->currency)); ?></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Percent Charge'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" min="0" class="form-control"
                                    name="percent_charge" required>
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.btnSetCharge').on('click', function() {
                let modal = $('#chargeModal');
                let methodName = $(this).data('method_name');
                let fixedCharge = $(this).data('fixed_charge');
                let percentCharge = $(this).data('percent_charge');
                let deliveryMethodId = $(this).data('id');

                modal.find('.methodName').text(methodName);
                modal.find('[name=delivery_method_id]').val(deliveryMethodId);
                modal.find('[name=fixed_charge]').val(fixedCharge);
                modal.find('[name=percent_charge]').val(percentCharge);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/admin/country/set_charges.blade.php ENDPATH**/ ?>