<div class="<?php echo e($class); ?>">
    <label class="text--accent sm-text d-block fw-md mb-2" for="from"><?php echo app('translator')->get('You Send'); ?></label>
    <div class="input-group">
        <input class="form-control form--control text--right sending-amount" min="0" id="from"
            name="sending_amount" placeholder="0.00" required step="any" type="number" value="<?php echo e(@$sendingAmount); ?>">
        <span class="sending-parent">
            <select autocomplete="off" class="sending-countries country-picker select2" name="sending_country" id="sending-country" required>
                <?php $__currentLoopData = $sendingCountries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sendingCountry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($sendingCountry->id); ?>"
                        data-conversion_rates="<?php echo e($sendingCountry->conversionRates); ?>"
                        data-currency="<?php echo e($sendingCountry->currency); ?>"
                        data-dial_code="<?php echo e($sendingCountry->dial_code); ?>" data-id="<?php echo e($sendingCountry->id); ?>"
                        data-image="<?php echo e(getImage(getFilePath('country') . '/' . $sendingCountry->image, getFileSize('country'))); ?>"
                        data-name="<?php echo e($sendingCountry->name); ?>" data-rate="<?php echo e($sendingCountry->rate); ?>">
                        <?php echo e($sendingCountry->currency); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </span>
    </div>
    <?php if($showLimit): ?>
        <a href="javascript:void(0)" class="showLimit xsm-text text-muted  text-decoration-underline">
            <i class="la la-info-circle"></i> <?php echo app('translator')->get('Limit'); ?>
        </a>
        <small class="mb-3 limitMessage d-none text--danger">
            <?php echo app('translator')->get('The amount exceeds the limit'); ?>
        </small>
    <?php endif; ?>
</div>
<div class="<?php echo e($class); ?>">
    <div class="d-flex justify-content-between align-items-center">
        <label class="text--accent sm-text d-block fw-md mb-2" for="you-send"><?php echo app('translator')->get('Recipient Gets'); ?></label>
        <button class="btn p-0 mb-2 reverseCountryBtn" type="button"><i class="la la-exchange-alt"></i></button>
    </div>
    <div class="input-group">
        <input class="form-control form--control text--right recipient-amount" min="0" id="to"
            name="recipient_amount" placeholder="0.00" required step="any" type="number"
            value="<?php echo e(@$recipientAmount); ?>">
        <span class="recipient-parent">
            <select class="form-control form--control country-picker recipient-countries select2" id="recipient-country"
                name="recipient_country">
                <?php $__currentLoopData = $receivingCountries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receivingCountry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($receivingCountry->id); ?>" data-currency="<?php echo e($receivingCountry->currency); ?>"
                        data-delivery_methods="<?php echo e($receivingCountry->countryDeliveryMethods); ?>"
                        data-dial_code="<?php echo e($receivingCountry->dial_code); ?>"
                        data-fixed_charge="<?php echo e($receivingCountry->fixed_charge); ?>"
                        data-id="<?php echo e($receivingCountry->id); ?>"
                        data-image="<?php echo e(getImage(getFilePath('country') . '/' . $receivingCountry->image, getFileSize('country'))); ?>"
                        data-name="<?php echo e($receivingCountry->name); ?>"
                        data-percent_charge="<?php echo e($receivingCountry->percent_charge); ?>"
                        data-has_agent="<?php echo e($receivingCountry->has_agent); ?>" data-rate="<?php echo e($receivingCountry->rate); ?>">
                        <?php echo e($receivingCountry->currency); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </span>
    </div>
</div>
<?php /**PATH /home/kikieccj/alrealremit.flecible.com/core/resources/views/templates/basic/partials/country_fields.blade.php ENDPATH**/ ?>