<?php
    $kycInstruction = getContent('kyc_instruction_user.content', true);
?>
<?php $__env->startSection('content'); ?>
<section class="dashboard-section body-collapse">
    <div class="overlay pt-120">
        <div class="container-fruid">
            <div class="row">
                <div class="col-xl-8 col-lg-7">
                    <div class="section-content">
                        <div class="acc-details">
                            <div class="top-area">
                                <div class="left-side">
                                    <h5>Hi, <?php echo e(auth()->user()->firstname); ?></h5>
                                    <h2><?php echo e(showAmount(auth()->user()->balance)); ?></h2>
                                    <h5 class="receive">Pending payment <span><?php echo e(showAmount($widget['payment_pending'])); ?></span></h5>
                                </div>
                                <div class="right-side">
                                    <div class="right-top">
                                        <select>
                                            <option value="1">US Dollar</option>
                                            <option value="2">US Dollar</option>
                                            <option value="3">US Dollar</option>
                                        </select>
                                        <div class="dropdown-area">
                                            <button type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                <img src="../assets/images/option.png" alt="icon">
                                            </button>
                                            
                                        </div>
                                    </div>
                                    <div class="right-bottom">
                                        <h4><?php echo e(showAmount($widget['send_money_amount'])); ?></h4>
                                        <h5>Completed Payments</h5></h5>
                                    </div>
                                </div>
                            </div>
                            <div class="bottom-area">
                                <div class="left-side">
                                    <a href="<?php echo e(route('user.send.money.now')); ?>" class="cmn-btn">Send Money</a>
                                </div>
                                <div class="right-side">
                                    <div class="dropdown-area">
                                        <button type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            <img src="../assets/images/option.png" alt="icon">
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li><a class="dropdown-item" href="<?php echo e(route('user.send.money.now')); ?>">Send Money</a></li>
                                            <li><a class="dropdown-item" href="<?php echo e(route('user.transactions')); ?>">Bill Pay</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="transactions-area mt-40">
                            <div class="section-text">
                                <div>
                                    <h5>Transactions</h5>
                                    <p>Updated every several minutes</p>
                                </div>
                            <div class="top-area d-flex align-items-center justify-content-between">
                                <div class="view-all d-flex align-items-center">
                                    <a href="<?php echo e(route('user.send.money.history')); ?>">View All</a>
                                    <img src="../assets/images/right-arrow.png" alt="icon">
                                </div>
                            </div>
                            </div>
                            <div class="tab-content mt-40">
                                <div class="tab-pane fade show active" id="latest" role="tabpanel"
                                    aria-labelledby="latest-tab">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('MTCN'); ?></th>
                                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                                    <th><?php echo app('translator')->get('Recipient'); ?></th>
                                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td> #<span class="fw-bold"><?php echo e($transfer->mtcn_number); ?></span></td>
                                                    <td>
                                                        <div>
                                                            <span class="fw-md">
                                                                <?php echo e(showAmount($transfer->sending_amount, currencyFormat: false)); ?>

                                                                <?php echo e(__($transfer->sending_currency)); ?>

                                                            </span>
                                                            <i class="la la-arrow-right"></i>
                                                            <span class="fw-md">
                                                                <?php echo e(showAmount($transfer->recipient_amount, currencyFormat: false)); ?>

                                                                <?php echo e(__($transfer->recipient_currency)); ?>

                                                            </span>
                                                        </div>
                                                        <span class="text--danger">
                                                            <?php echo app('translator')->get('Charge'); ?>: <?php echo e(showAmount($transfer->sending_charge, currencyFormat: false)); ?>

                                                            <?php echo e(__($transfer->sending_currency)); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-bold text--primary"><?php echo e($transfer->recipient->name); ?></span>
                                                        <br>
                                                        <span class="text-muted">
                                                            <i class="la la-globe"></i>
                                                            <?php echo e(__(@$transfer->recipientCountry->name)); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <?php if($transfer->status == Status::SEND_MONEY_REFUNDED && $transfer->admin_feedback != null): ?>
                                                            <button class="btn-info rounded badge feedbackBtn"
                                                                data-admin_feedback="<?php echo e($transfer->admin_feedback); ?>">
                                                                <i class="fa fa-info"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                        <?php echo $transfer->statusBadge;?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="100%" class="text-muted text-center"><?php echo e(__($emptyMessage)); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="side-items">
                        
                        <div class="single-item">
                            <div class="section-text d-flex align-items-center justify-content-between">
                                <h6>Recipients</h6>
                            </div>
                            <ul class="recipients-item">
                                <?php $__empty_1 = true; $__currentLoopData = $rep; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li>
                                    <p class="left d-flex align-items-center">
                                        <span class="info">
                                            <span><?php echo e($r->name); ?></span>
                                            <span><?php echo e($r->created_at); ?></span>
                                        </span>
                                    </p>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <li>
                                                    No Recipients
                                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="card-popup">
    <div class="container-fruid">
        <div class="row">
            <div class="col-lg-6">
                <div class="modal fade" id="cardMod" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header justify-content-center">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                            </div>
                            <div class="main-content">
                                <div class="top-area mb-40 mt-40 text-center">
                                    <div class="card-area mb-30">
                                        <img src="../assets/images/visa-card-2.png" alt="image">
                                    </div>
                                    <div class="text-area">
                                        <h5>Paylio payment Card </h5>
                                        <p>Linked: 01 Jun 2021</p>
                                    </div>
                                </div>
                                <div class="tab-area d-flex align-items-center justify-content-between">
                                    <ul class="nav nav-tabs mb-30" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="btn-link" id="cancel-tab" data-bs-toggle="tab"
                                                data-bs-target="#cancel" type="button" role="tab"
                                                aria-controls="cancel" aria-selected="false">
                                                <img src="../assets/images/limit.png" alt="icon">
                                                Set transfer limit
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="d-none" id="limit-tab" data-bs-toggle="tab"
                                                data-bs-target="#limit" type="button" role="tab"
                                                aria-controls="limit" aria-selected="true"></button>
                                        </li>
                                        <li>
                                            <button>
                                                <img src="../assets/images/remove.png" alt="icon">
                                                Remove from Linked
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="tab-content mt-30">
                                    <div class="tab-pane fade show active" id="limit" role="tabpanel"
                                        aria-labelledby="limit-tab">
                                        <div class="bottom-area">
                                            <p class="history">Transaction History : <span>20</span></p>
                                            <ul>
                                                <li>
                                                    <p class="left">
                                                        <span>03:00 PM</span>
                                                        <span>17 Oct, 2020</span>
                                                    </p>
                                                    <p class="right">
                                                        <span>$160.48</span>
                                                        <span>Withdraw</span>
                                                    </p>
                                                </li>
                                                <li>
                                                    <p class="left">
                                                        <span>01:09 PM</span>
                                                        <span>15 Oct, 2021</span>
                                                    </p>
                                                    <p class="right">
                                                        <span>$106.58</span>
                                                        <span>Withdraw</span>
                                                    </p>
                                                </li>
                                                <li>
                                                    <p class="left">
                                                        <span>04:00 PM</span>
                                                        <span>12 Oct, 2020</span>
                                                    </p>
                                                    <p class="right">
                                                        <span>$176.58</span>
                                                        <span>Withdraw</span>
                                                    </p>
                                                </li>
                                                <li>
                                                    <p class="left">
                                                        <span>06:00 PM</span>
                                                        <span>25 Oct, 2020</span>
                                                    </p>
                                                    <p class="right">
                                                        <span>$167.85</span>
                                                        <span>Withdraw</span>
                                                    </p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="cancel" role="tabpanel"
                                        aria-labelledby="cancel-tab">
                                        <div class="main-area">
                                            <div class="transfer-area">
                                                <p>Set a transfer limit for paylio payment Card</p>
                                                <p class="mdr">Transfer Limit</p>
                                            </div>
                                            <form action="#">
                                                <div class="input-area">
                                                    <input class="xxlr" placeholder="400.00" type="number">
                                                    <select>
                                                        <option value="1">USD</option>
                                                        <option value="2">USD</option>
                                                        <option value="3">USD</option>
                                                    </select>
                                                </div>
                                                <div
                                                    class="bottom-area d-flex align-items-center justify-content-between">
                                                    <a href="javascript:void(0)" class="cmn-btn cancel">Cancel and
                                                        Back</a>
                                                    <a href="javascript:void(0)" class="cmn-btn">Confirm Transfer
                                                        Limit</a>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="add-card">
    <div class="container-fruid">
        <div class="row">
            <div class="col-lg-6">
                <div class="modal fade" id="addcardMod" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header justify-content-between">
                                <h6>Add Card</h6>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                            </div>
                            <form action="#">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">
                                        <div class="single-input">
                                            <label for="cardNumber">Card Number</label>
                                            <input type="text" id="cardNumber"
                                                placeholder="5890 - 6858 - 6332 - 9843">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="single-input">
                                            <label for="cardHolder">Card Holder</label>
                                            <input type="text" id="cardHolder" placeholder="Alfred Davis">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="single-input">
                                            <label for="month">Month</label>
                                            <input type="text" id="month" placeholder="12">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="single-input">
                                            <label for="year">Year</label>
                                            <input type="text" id="year" placeholder="2025">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="btn-border w-100">
                                            <button class="cmn-btn w-100">Add Card</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="transactions-popup">
    <div class="container-fruid">
        <div class="row">
            <div class="col-lg-6">
                <div class="modal fade" id="transactionsMod" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header justify-content-between">
                                <h5>Transaction Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                            </div>
                            <div class="main-content">
                                <div class="row">
                                    <div class="col-sm-5 text-center">
                                        <div class="icon-area">
                                            <img src="../assets/images/transaction-details-icon.png" alt="icon">
                                        </div>
                                        <div class="text-area">
                                            <h6>Envato Pty Ltd</h6>
                                            <p>16 Jan 2022</p>
                                            <h3>717.14 USD</h3>
                                            <p class="com">Completed</p>
                                        </div>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="right-area">
                                            <h6>Transaction Details</h6>
                                            <ul class="payment-details">
                                                <li>
                                                    <span>Payment Amount</span>
                                                    <span>718.64 USD</span>
                                                </li>
                                                <li>
                                                    <span>Fee</span>
                                                    <span>1.50 USD</span>
                                                </li>
                                                <li>
                                                    <span>Total Amount</span>
                                                    <span>717.14 USD</span>
                                                </li>
                                            </ul>
                                            <ul class="payment-info">
                                                <li>
                                                    <p>Payment From</p>
                                                    <span class="mdr">Envato Pty Ltd</span>
                                                </li>
                                                <li>
                                                    <p>Payment Description</p>
                                                    <span class="mdr">Envato Feb 2022 Member Payment</span>
                                                </li>
                                                <li>
                                                    <p>Transaction  ID:</p>
                                                    <span class="mdr">6559595979565959895559595</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!--<div class="section section--xl">-->
    <!--    <div class="section__head p-2">-->
    <!--        <div class="container">-->
    <!--            <div class="notice"></div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--    <?php if(auth()->user()->kv != 1): ?>-->
    <!--        <div class="section__head p-2">-->
    <!--            <div class="container">-->
    <!--                <div class="row">-->
    <!--                    <div class="col-12">-->
    <!--                        <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>-->
    <!--                            <div class="alert alert--danger" role="alert">-->
    <!--                                <div class="alert__icon"><i class="fas fa-file-signature"></i></div>-->
    <!--                                <p class="alert__message m-0">-->
    <!--                                    <span class="fw-bold"><?php echo app('translator')->get('KYC Documents Rejected'); ?></span><br>-->
    <!--                                    <small>-->
    <!--                                        <i>-->
    <!--                                            <?php echo e(__(@$kycInstruction->data_values->reject_instruction)); ?>-->
    <!--                                            <a class="link-color" data-bs-toggle="modal"-->
    <!--                                                data-bs-target="#kycRejectionReason" href="javascript::void(0)">-->
    <!--                                                <?php echo app('translator')->get('Click here'); ?>-->
    <!--                                            </a>-->
    <!--                                            <?php echo app('translator')->get('to show the reason'); ?>.-->
    <!--                                            <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>">-->
    <!--                                                <?php echo app('translator')->get('Click Here'); ?>-->
    <!--                                            </a>-->
    <!--                                            <?php echo app('translator')->get('to Re-submit Documents'); ?>.-->
    <!--                                            <a class="link-color" href="<?php echo e(route('user.kyc.data')); ?>">-->
    <!--                                                <?php echo app('translator')->get('See KYC Data'); ?>-->
    <!--                                            </a>-->
    <!--                                        </i>-->
    <!--                                    </small>-->
    <!--                                </p>-->
    <!--                            </div>-->
    <!--                        <?php elseif(auth()->user()->kv == Status::KYC_UNVERIFIED): ?>-->
    <!--                            <div class="alert alert--info" role="alert">-->
    <!--                                <div class="alert__icon"><i class="fas fa-file-signature"></i></div>-->
    <!--                                <p class="alert__message m-0">-->
    <!--                                    <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>-->
    <!--                                    <small>-->
    <!--                                        <i>-->
    <!--                                            <?php echo e(__(@$kycInstruction->data_values->verification_instruction)); ?>-->
    <!--                                            <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>">-->
    <!--                                                <?php echo app('translator')->get('Click here'); ?>-->
    <!--                                            </a>-->
    <!--                                        </i>-->
    <!--                                    </small>-->
    <!--                                </p>-->
    <!--                            </div>-->
    <!--                        <?php elseif(auth()->user()->kv == Status::KYC_PENDING): ?>-->
    <!--                            <div class="alert alert--warning" role="alert">-->
    <!--                                <div class="alert__icon"><i class="fas fa-user-check"></i></div>-->
    <!--                                <p class="alert__message m-0">-->
    <!--                                    <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>-->
    <!--                                    <small>-->
    <!--                                        <i>-->
    <!--                                            <?php echo e(__(@$kycInstruction->data_values->pending_instruction)); ?>-->
    <!--                                            <a class="link-color" href="<?php echo e(route('user.kyc.data')); ?>">-->
    <!--                                                <?php echo app('translator')->get('Click here'); ?>-->
    <!--                                            </a>-->
    <!--                                            <?php echo app('translator')->get('to see your submitted information'); ?>-->
    <!--                                        </i>-->
    <!--                                    </small>-->
    <!--                                </p>-->
    <!--                            </div>-->
    <!--                        <?php endif; ?>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    <?php endif; ?>-->
    <!--    <div class="section__head">-->
    <!--        <div class="container">-->
    <!--            <div class="d-flex flex-wrap gap-3 justify-content-center">-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-wallet"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Refunded Wallet Balance'); ?></p>-->
    <!--                            <div class="text mt-2 mb-0">-->
    <!--                                <?php echo e(showAmount($widget['balance'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-credit-card"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Send Money Completed'); ?></p>-->
    <!--                            <div class="text  mt-2 mb-0">-->
    <!--                                <?php echo e(showAmount($widget['send_money_amount'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-spinner"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Send Money Pending'); ?></p>-->
    <!--                            <div class="text  mt-2 mb-0">-->
    <!--                                <?php echo e(showAmount($widget['send_money_pending'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-coins"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Send Money Initiated'); ?></p>-->
    <!--                            <div class="text">-->
    <!--                                <?php echo e(showAmount($widget['send_money_initiated'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-spinner"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Pending Payment'); ?></p>-->
    <!--                            <div class="text">-->
    <!--                                <?php echo e(showAmount($widget['payment_pending'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="dashboard-card flex-grow-1">-->
    <!--                    <div class="user align-items-center justify-content-center">-->
    <!--                        <div class="icon icon--lg icon--circle">-->
    <!--                            <i class="fas fa-times"></i>-->
    <!--                        </div>-->
    <!--                        <div class="user__content">-->
    <!--                            <p class="xl-text mb-0"><?php echo app('translator')->get('Rejected Payment'); ?></p>-->
    <!--                            <div class="text">-->
    <!--                                <?php echo e(showAmount($widget['payment_rejected'])); ?>-->
    <!--                            </div>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--    <div class="container">-->
    <!--        <div class="row g-lg-3">-->
    <!--            <div class="col-12">-->
    <!--                <div class="custom--table__header">-->
    <!--                    <h5 class="text-lg-start m-0 text-center"><?php echo app('translator')->get('Recent Send Money Log'); ?></h5>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="col-12">-->
    <!--                <div class="table-responsive--md">-->
    <!--                    <?php echo $__env->make($activeTemplate . 'partials.send_money_table', [
                          'transfers' => $transfers,
                           'hasBtn' => false,
                      ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->

    <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title m-0"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(auth()->user()->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    
    <div class="modal custom--modal fade" id="feedbackModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Feedback'); ?></h5>
                    <button aria-label="Close" class="close btn btn--danger btn-sm close-button" data-bs-dismiss="modal"
                        type="button">
                        <i aria-hidden="true" class="la la-times"></i>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <span class="admin_feedback"></span>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.feedbackBtn').on('click', function() {
                var modal = $('#feedbackModal');
                modal.find('.admin_feedback').text($(this).data('admin_feedback'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="https://fonts.googleapis.com/css2?family=Rajdhani:wght@400;500;600&display=swap" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .dashboard-card .user__content h4 {
            font-family: "rajdhani", sans-serif;
            font-weight: 500;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>