<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('MTCN'); ?></th>
                                    <th><?php echo app('translator')->get('Created By'); ?></th>
                                    <th><?php echo app('translator')->get('Sender'); ?></th>
                                    <th><?php echo app('translator')->get('Recipient'); ?></th>
                                    <th><?php echo app('translator')->get('Delivery Method'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $sendMoneys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sendMoney): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span class="text--muted fw-bold">#<?php echo e(@$sendMoney->mtcn_number); ?></span>
                                            <br>
                                            <em
                                                class="text--muted text--small"><?php echo e(showDateTime(@$sendMoney->created_at)); ?></em>
                                        </td>
                                        <td>
                                            <?php if($sendMoney->user_id): ?>
                                                <span class="fw-bold"><?php echo e(@$sendMoney->user->fullname); ?></span>
                                                <br>
                                                <span class="small">
                                                    <a
                                                        href="<?php echo e(route('admin.users.detail', $sendMoney->user_id)); ?>"><span>@</span><?php echo e(@$sendMoney->user->username); ?></a>
                                                </span>
                                            <?php else: ?>
                                                <span class="fw-bold"><?php echo e(@$sendMoney->agent->fullname); ?></span>
                                                <br>
                                                <span class="small">
                                                    <a href="<?php echo e(route('admin.agents.detail', $sendMoney->agent_id)); ?>">
                                                        <span>@</span><?php echo e(@$sendMoney->agent->username); ?>

                                                    </a>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e(@$sendMoney->senderInfo->name); ?>

                                            <br>
                                            <a href="<?php echo e(route('admin.country.index')); ?>?search=<?php echo e(@$sendMoney->sendingCountry->name); ?>"
                                                class="fw-bold">
                                                <?php echo e(__(@$sendMoney->sendingCountry->name)); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <?php echo e($sendMoney->recipient->name); ?><br>
                                            <a href="<?php echo e(route('admin.country.index')); ?>?search=<?php echo e(@$sendMoney->recipientCountry->name); ?>"
                                                class="fw-bold">
                                                <?php echo e(__($sendMoney->recipientCountry->name)); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <?php if($sendMoney->country_delivery_method_id): ?>
                                                <span
                                                    class="fw-bold text--danger"><?php echo e(__(@$sendMoney->countryDeliveryMethod->deliveryMethod->name)); ?></span>
                                            <?php else: ?>
                                                <span class="text--info fw-bold"><?php echo app('translator')->get('Agent'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span><?php echo e(showAmount($sendMoney->sending_amount, currencyFormat: false)); ?>

                                                <?php echo e(@$sendMoney->sending_currency); ?></span>
                                            <i class="la la-arrow-right"></i>
                                            <span><?php echo e(showAmount($sendMoney->recipient_amount, currencyFormat: false)); ?>

                                                <?php echo e(__($sendMoney->recipient_currency)); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                echo $sendMoney->statusBadge;
                                            ?>
                                            <br>
                                            <?php echo e(diffForHumans($sendMoney->updated_at)); ?>

                                        </td>
                                        <td>
                                            <a class="btn btn-sm btn-outline--primary"
                                                href="<?php echo e(route('admin.send.money.details', $sendMoney->id)); ?>">
                                                <i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($sendMoneys->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($sendMoneys)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="offcanvas offcanvas-end" tabindex="-1" id="filter" aria-labelledby="filterLabel">
        <div class="offcanvas-header">
            <h5 class="ms-3"><?php echo app('translator')->get('Filter'); ?></h5>
            <button type="button" class="btn-close text-reset me-2 " data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <form>
                <div class="modal-body">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('User Username'); ?> </label>
                        <input class="form-control" name="user" type="text" value="<?php echo e(request()->user ?? ''); ?>" />
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Agent Username'); ?> </label>
                        <input class="form-control" name="agent" type="text" value="<?php echo e(request()->agent ?? ''); ?>" />
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Recipient Name'); ?> </label>
                        <input class="form-control" name="recipient" type="text"
                            value="<?php echo e(request()->recipient ?? ''); ?>" />
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('MTCN Number'); ?> </label>
                        <input class="form-control" name="mtcn_number" type="text"
                            value="<?php echo e(request()->mtcn_number ?? ''); ?>" />
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Amount'); ?> </label>
                        <input class="form-control" name="sending_amount" type="text"
                            value="<?php echo e(request()->sending_amount ?? ''); ?>" />
                    </div>
                    <div class="flex-grow-1">
                        <label><?php echo app('translator')->get('Date'); ?></label>
                        <input name="date" type="search" class="datepicker-here form-control bg--white pe-2 date-range"
                            placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->date); ?>">
                    </div>
                </div>
                <div class="modal-footer mt-4">
                    <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .datepickers-container {
            z-index: 9999;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'MTCN/Sender/Recipient']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'MTCN/Sender/Recipient']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>

    <button class="btn btn--primary h-45" data-bs-toggle="offcanvas" href="#filter" role="button" aria-controls="filter">
        <i class="fas fa-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            const datePicker = $('.date-range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                showDropdowns: true,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                        .endOf('month')
                    ],
                    'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                },
                maxDate: moment()
            });
            const changeDatePickerText = (event, startDate, endDate) => {
                $(event.target).val(startDate.format('MMMM DD, YYYY') + ' - ' + endDate.format('MMMM DD, YYYY'));
            }


            $('.date-range').on('apply.daterangepicker', (event, picker) => changeDatePickerText(event, picker
                .startDate, picker.endDate));


            if ($('.date-range').val()) {
                let dateRange = $('.date-range').val().split(' - ');
                $('.date-range').data('daterangepicker').setStartDate(new Date(dateRange[0]));
                $('.date-range').data('daterangepicker').setEndDate(new Date(dateRange[1]));
            }

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/admin/send_money/list.blade.php ENDPATH**/ ?>