@php
$user = auth()->user();
@endphp

<header class="header-section body-collapse">
    <div class="overlay">
        <div class="container-fruid">
            <div class="row d-flex header-area">
                <div class="navbar-area d-flex align-items-center justify-content-between">
                    <div class="sidebar-icon">
                        <img src="/assets/images/menu.png" alt="icon">
                    </div>
                    <form action="#" class="flex-fill">
                        <div class="form-group d-flex align-items-center">
                            <img src="/assets/images/search.png" alt="icon">
                            <input type="text" placeholder="Type to search...">
                        </div>
                    </form>
                    <div class="dashboard-nav">
                        <div class="single-item user-area">
                            <div class="profile-area d-flex align-items-center">
                                <span class="user-profile">
                                    <img src="{{ asset($user->image 
                                        ? 'assets/images/user/profile/'.$user->image 
                                        : 'assets/images/avatar.png') }}"
                                        alt="User"
                                        class="rounded-circle"
                                        style="width: 60px; height: 60px; object-fit: cover;">
                                </span>
                                <i class="fa-solid fa-sort-down"></i>
                            </div>
                            <div class="main-area user-content">
                                <div class="head-area d-flex align-items-center">
                                    <div class="profile-head">
                                        <a href="{{ route('user.profile.setting') }}">
                                            <h5>{{auth()->user()->firstname}} {{auth()->user()->lastname}}</h5>
                                        </a>
                                        
                                    </div>
                                </div>
                                <ul>
                                    <li class="border-area">
                                        <a href="{{ route('user.profile.setting') }}"><i class="fas fa-cog"></i><span style="padding-left: 5px;">Settings</span></a>
                                    </li>
                                    <li>
                                        <a href="{{ route('user.twofactor') }}"><i class="fa-solid fa-shield-halved"></i><span style="padding-left: 5px;">2FA Security</span></a>
                                    </li>
                                    <li>
                                        <a href="{{ route('user.change.password') }}"><i class="fas fa-key"></i><span style="padding-left: 5px;">Change Password</span></a>
                                    </li>
                                    <li>
                                        <a href="{{ route('user.logout') }}"><i class="fas fa-sign-out"></i><span style="padding-left: 5px;">Logout</span></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="sidebar-wrapper">
                    <div class="close-btn">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                    <div class="sidebar-logo">
                        <a class="logo logo-light" href="{{ route('home') }}">
                           <img alt="{{ gs('site_name') }}" class="img-fluid logo__is" src="{{ siteLogo() }}" />
                        </a>
                    </div>
                    <ul>
                        <li class="{{ request()->routeIs('user.home') ? 'active' : ''}}">
                            <a href="{{ route('user.home') }}">
                                <i class="fa-solid fa-chart-line"></i> <span style="padding-left: 5px;">Dashboard</span>
                            </a>
                        </li>
                        <li class="{{ request()->routeIs('user.send.money.history') ? 'active' : ''}}">
                            <a href="{{ route('user.send.money.history') }}">
                                <i class="fa-solid fa-money-bill-transfer"></i> <span style="padding-left: 5px;">Transactions</span>
                            </a>
                        </li>
                        <li class="{{ request()->routeIs('user.send.money.now') ? 'active' : ''}}">
                            <a href="{{ route('user.send.money.now') }}">
                                <i class="fa-solid fa-money-bill-trend-up"></i> <span style="padding-left: 5px;">Send Money</span>
                            </a>
                        </li>
                        <!--<li>-->
                        <!--    <a href="recipients.html">-->
                        <!--        <img src="/assets/images/recipients.png" alt="Recipients"> <span>Recipients</span>-->
                        <!--    </a>-->
                        <!--</li>-->
                    </ul>
                    <ul class="bottom-item">
                        <li class="{{ request()->routeIs('user.profile.setting') ? 'active' : ''}}">
                            <a href="{{ route('user.profile.setting') }}">
                                <i class="fa-regular fa-circle-user"></i> <span style="padding-left: 5px;">Account</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('user.twofactor') }}">
                                <i class="fa-solid fa-shield-halved"></i><span style="padding-left: 5px;">2FA Security</span>
                                </a>
                        </li>
                        <li>
                            <a href="{{ route('user.change.password') }}"><i class="fas fa-key"></i><span style="padding-left: 5px;">Change Password</span></a>
                        </li>
                        <li class="{{ request()->routeIs('ticket.index') ? 'active' : ''}}">
                            <a href="{{ route('ticket.index') }}">
                                <i class="fa-solid fa-headset"></i> <span style="padding-left: 5px;">Support</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('user.logout') }}">
                                <i class="fas fa-sign-out"></i> <span style="padding-left: 5px;">Quit</span>
                            </a>
                        </li>
                    </ul>
                    <div class="" style="padding-top: 15px">
                        <div class="invite-now">
                            <div class="img-area">
                                <img src="/assets/images/invite-now-illus.png" alt="Image">
                            </div>
                            <p>Invite your friend and get $25</p>
                            <input type="text" name="key"
                                value="{{ route('home') }}?reference={{ $user->username }}"
                                class="form-control form--control referralURL" style="position:absolute; left:-9999px;" readonly>
                            <button type="button" class="input-group-text copytext cmn-btn" id="copyBoard">
                               Invite Now</button>
                            <!--<a href="javascript:void(0)" class="cmn-btn">Invite Now</a>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

@push('script')
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
@endpush

<!--<header class="header-fixed header--secondary">-->
<!--    <nav class="navbar navbar-expand-lg navbar-light">-->
<!--        <div class="container">-->
<!--            <a class="logo logo-light" href="{{ route('home') }}">-->
<!--                <img alt="{{ gs('site_name') }}" class="img-fluid logo__is" src="{{ siteLogo() }}" />-->
<!--            </a>-->
<!--            <button aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"-->
<!--                class="navbar-toggler" data-bs-target="#navbarSupportedContent" data-bs-toggle="collapse"-->
<!--                type="button">-->
<!--                <span class="menu-toggle"></span>-->
<!--            </button>-->
<!--            <div class="collapse navbar-collapse" id="navbarSupportedContent">-->
<!--                <ul class="navbar-nav ms-auto mb-lg-0 align-items-lg-center mb-2">-->
<!--                    <li class="nav-item">-->
<!--                        <a class="primary-menu__link" href="{{ route('user.home') }}">@lang('Dashboard')</a>-->
<!--                    </li>-->
<!--                    <li class="nav-item primary-menu__list has-sub">-->
<!--                        <a class="primary-menu__link" href="javascript:void(0)">@lang('Send Money')</a>-->
<!--                        <ul class="primary-menu__sub">-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.send.money.now') }}">-->
<!--                                    @lang('Send Now')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.send.money.history') }}">-->
<!--                                    @lang('View History')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                        </ul>-->
<!--                    </li>-->
<!--                    <li class="nav-item primary-menu__list has-sub">-->
<!--                        <a class="primary-menu__link" href="javascript:void(0)">@lang('Support Ticket')</a>-->
<!--                        <ul class="primary-menu__sub">-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('ticket.open') }}">-->
<!--                                    @lang('Open Now')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('ticket.index') }}">-->
<!--                                    @lang('All Tickets')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                        </ul>-->
<!--                    </li>-->
<!--                    <li class="nav-item primary-menu__list has-sub">-->
<!--                        <a class="primary-menu__link" href="javascript:void(0)">{{ auth()->user()->username }}</a>-->
<!--                        <ul class="primary-menu__sub">-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.transactions') }}">-->
<!--                                    @lang('Transactions')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.change.password') }}">-->
<!--                                    @lang('Change Password')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.profile.setting') }}">-->
<!--                                    @lang('Profile Setting')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                            <li class="primary-menu__sub-list">-->
<!--                                <a class="t-link primary-menu__sub-link" href="{{ route('user.twofactor') }}">-->
<!--                                    @lang('2FA Security')-->
<!--                                </a>-->
<!--                            </li>-->
<!--                        </ul>-->
<!--                    </li>-->
<!--                    @include($activeTemplate . 'partials.language')-->
<!--                    <li class="nav-item pt-lg-0 pb-lg-0 pt-10 pb-10">-->
<!--                        <a class="btn btn--md btn--base fixed-width" href="{{ route('user.logout') }}">-->
<!--                            @lang('Logout')-->
<!--                        </a>-->
<!--                    </li>-->
<!--                </ul>-->
<!--            </div>-->
<!--        </div>-->
<!--    </nav>-->
<!--</header>-->
