<?php
    $faqContent = getContent('faq.content', true);
    $faqElements = getContent('faq.element', false, null, true);
    $chunks = collect($faqElements)->chunk(ceil(count($faqElements) / 2));
?>
<!-- FAQ Section  -->

<section class="faqs-section help-center">
    <div class="overlay pt-120 pb-120">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-7">
                    <div class="section-header text-center">
                        <h5 class="sub-title">Frequently Asked Questions</h5>
                        <h2 class="title"> <?php echo e(__(@$faqContent->data_values->heading)); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row cus-mar">
                <div class="col-lg-6">
                    <div class="accordion" id="accordionLeft">
                        <?php $__currentLoopData = $chunks[0] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faqElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $heading = 'headingLeft_' . $index;
                            $collapse = 'collapseLeft_' . $index;
                        ?>
                        <div class="accordion-item">
                            <h6 class="accordion-header" id="<?php echo e($heading); ?>">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#<?php echo e($collapse); ?>"
                                    aria-expanded="false"
                                    aria-controls="<?php echo e($collapse); ?>">
                                    <?php echo e(__($faqElement->data_values->question)); ?>

                                </button>
                            </h6>
                            <div id="<?php echo e($collapse); ?>" class="accordion-collapse collapse"
                                aria-labelledby="<?php echo e($heading); ?>"
                                data-bs-parent="#accordionLeft">
                                <div class="accordion-body">
                                    <?php echo $faqElement->data_values->answer; ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            
                <div class="col-lg-6">
                    <div class="accordion" id="accordionRight">
                        <?php $__currentLoopData = $chunks[1] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faqElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $heading = 'headingRight_' . $index;
                            $collapse = 'collapseRight_' . $index;
                        ?>
                        <div class="accordion-item">
                            <h6 class="accordion-header" id="<?php echo e($heading); ?>">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#<?php echo e($collapse); ?>"
                                    aria-expanded="false"
                                    aria-controls="<?php echo e($collapse); ?>">
                                    <?php echo e(__($faqElement->data_values->question)); ?>

                                </button>
                            </h6>
                            <div id="<?php echo e($collapse); ?>" class="accordion-collapse collapse"
                                aria-labelledby="<?php echo e($heading); ?>"
                                data-bs-parent="#accordionRight">
                                <div class="accordion-body">
                                    <?php echo $faqElement->data_values->answer; ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
document.querySelectorAll('.accordion').forEach(accordion => {
    accordion.addEventListener('click', e => {
        if (e.target.classList.contains('accordion-button')) {
            const currentlyOpen = accordion.querySelector('.accordion-button:not(.collapsed)');
            if (currentlyOpen && currentlyOpen === e.target) {
                currentlyOpen.click(); // forces close
            }
        }
    });
});
</script><?php /**PATH /home/kikieccj/alrealremit.flecible.com/core/resources/views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>