<?php $__env->startSection('content'); ?>
<section class="dashboard-section body-collapse">
    <div class="overlay pt-120">
        <div class="container-fruid">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="card-title">
                        <?php echo e(__($pageTitle)); ?>

                    </h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('ticket.store')); ?>" class="disableSubmission" method="post"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="name" value="<?php echo e(@$user->firstname . ' ' . @$user->lastname); ?>">
                        <input type="hidden" name="email" value="<?php echo e(@$user->email); ?>">
                        <div class="row g-3">
                            <div class="col-md-8">
                                <label class="text--accent sm-text d-block mb-2 fw-md"
                                    for="website"><?php echo app('translator')->get('Subject'); ?></label>
                                <input type="text" name="subject" value="<?php echo e(old('subject')); ?>"
                                    class="form-control form--control ">
                            </div>
                            <div class="col-md-4">
                                <label class="text--accent sm-text d-block mb-2 fw-md" for="priority">
                                    <?php echo app('translator')->get('Priority'); ?>
                                </label>
                                <select name="priority" class="form-select form--select select2-basic"
                                    data-minimum-results-for-search="-1">
                                    <option value="3"><?php echo app('translator')->get('High'); ?></option>
                                    <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                                    <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                                </select>
                            </div>
                            <div class="col-12">
                                <label class="text--accent sm-text d-block mb-2 fw-md"
                                    for="inputMessage"><?php echo app('translator')->get('Message'); ?></label>
                                <textarea name="message" id="inputMessage" rows="6" class="form-control form--control-textarea " required><?php echo e(old('message')); ?></textarea>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-md-9">
                                <button type="button" class="btn btn-dark btn-sm addAttachment my-2"> <i
                                        class="las la-plus"></i> <?php echo app('translator')->get('Add Attachment'); ?> </button>
                                <p class="mb-2"><span class="text--info"><?php echo app('translator')->get('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx'); ?></span></p>
                                <div class="row fileUploadsContainer">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn--base w-100 my-2" type="submit">
                                    <i class="las la-paper-plane"></i>
                                    <?php echo app('translator')->get('Submit'); ?>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .input-group-text {
            color: #ffffff;
            border: unset;
        }

        .form-control:focus {
            box-shadow: unset;
            border: 1px solid rgba(224, 224, 224, 0.5)
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="file" name="attachments[]" class="form-control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="las la-times"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/support/create.blade.php ENDPATH**/ ?>