<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--lg table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th class="text-start"><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Currency'); ?></th>
                                    <th><?php echo app('translator')->get('Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Has Agent'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="text-start">
                                            <span class="user">
                                                <span class="thumb me-2">
                                                    <img alt="image"
                                                        src="<?php echo e(getImage(getFilePath('country') . '/' . $country->image, getFileSize('country'))); ?>">
                                                </span>
                                                <?php echo e($country->name); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($country->currency); ?></td>
                                        <td>
                                            <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($country->rate, currencyFormat: false)); ?>

                                            <?php echo e($country->currency); ?>

                                        </td>
                                        <td><?php echo $country->agentStatus;?></td>
                                        <td><?php echo $country->statusBadge;?></td>
                                        <?php
                                            $country->image_with_path = getImage(
                                                getFilePath('country') . '/' . $country->image,
                                                getFileSize('country'),
                                            );
                                        ?>
                                        <td>
                                            <button aria-expanded="false" class="btn btn-outline--info btn--sm"
                                                data-bs-toggle="dropdown" type="button">
                                                <i class="las la-ellipsis-v"></i><?php echo app('translator')->get('More'); ?>
                                            </button>
                                            <div class="dropdown-menu">
                                                <button class="dropdown-item cuModalBtn editBtn" data-has_status="true"
                                                    data-modal_title="<?php echo app('translator')->get('Update Country'); ?>" data-resource="<?php echo e($country); ?>"
                                                    data-image="<?php echo e(getImage(getFilePath('country') . '/' . $country->image, getFileSize('country'))); ?>">
                                                    <i class="la la-pencil-alt"></i> <?php echo app('translator')->get('Edit'); ?>
                                                </button>
                                                <?php if($country->status): ?>
                                                    <button class="dropdown-item confirmationBtn"
                                                        data-action="<?php echo e(route('admin.country.update.status', $country->id)); ?>"
                                                        data-question="<?php echo app('translator')->get('Are you sure that you want to disable this country?'); ?>">
                                                        <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Disable'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="dropdown-item confirmationBtn"
                                                        data-action="<?php echo e(route('admin.country.update.status', $country->id)); ?>"
                                                        data-question="<?php echo app('translator')->get('Are you sure that you want to enable this country?'); ?>">
                                                        <i class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?>
                                                    </button>
                                                <?php endif; ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.country.currency.conversion.rate', $country->id)); ?>">
                                                    <i class="la la-coins"></i> <?php echo app('translator')->get('Conversion Rates'); ?>
                                                </a>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.service.index', $country->id)); ?>">
                                                    <i class="las la-list"></i> <?php echo app('translator')->get('Services'); ?>
                                                </a>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.country.charges.set', $country->id)); ?>">
                                                    <i class="las la-comment-dollar"></i> <?php echo app('translator')->get('Set Charges'); ?>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($countries->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($countries)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="cuModal">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button aria-label="Close" class="close" data-bs-dismiss="modal" type="button">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.country.store')); ?>" enctype="multipart/form-data" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Image'); ?></label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['imagePath' => getImage(null, getFileSize('country')),'size' => getFileSize('country'),'class' => 'w-100','id' => 'imageCreate','required' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['imagePath' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(getImage(null, getFileSize('country'))),'size' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(getFileSize('country')),'class' => 'w-100','id' => 'imageCreate','required' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Country'); ?> </label>
                                    <select class="form-control select2" name="country_code" required>
                                        <option disabled selected value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $countryList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shortCode => $countryData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-currency="<?php echo e(@$countryData->currency->code); ?>"
                                                value="<?php echo e($shortCode); ?>">
                                                <?php echo e($countryData->country); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Currency'); ?> </label>
                                    <input class="form-control bg--white" name="currency" readonly type="text"
                                        value="<?php echo e(old('currency')); ?>" />
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Rate'); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <?php echo e(showAmount(1)); ?> =
                                        </span>
                                        <input class="form-control" name="rate" required step="any" type="number"
                                            value="<?php echo e(old('rate')); ?>" />
                                        <span class="input-group-text currency"><?php echo e(old('currency')); ?></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Has Agent'); ?></label>
                                    <input data-height="45" data-off="<?php echo app('translator')->get('No'); ?>" data-offstyle="-danger"
                                        data-on="<?php echo app('translator')->get('Yes'); ?>" data-onstyle="-success" data-size="large"
                                        data-toggle="toggle" data-width="100%" name="has_agent" type="checkbox">
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Sending Country'); ?></label>
                                    <input data-height="45" data-off="<?php echo app('translator')->get('No'); ?>" data-offstyle="-danger"
                                        data-on="<?php echo app('translator')->get('Yes'); ?>" data-onstyle="-success" data-size="large"
                                        data-toggle="toggle" data-width="100%" name="is_sending" type="checkbox">
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Receiving Country'); ?></label>
                                    <input data-height="45" data-off="<?php echo app('translator')->get('No'); ?>" data-offstyle="-danger"
                                        data-on="<?php echo app('translator')->get('Yes'); ?>" data-onstyle="-success" data-size="large"
                                        data-toggle="toggle" data-width="100%" name="is_receiving" type="checkbox">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="helpModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitleId"><?php echo app('translator')->get('Information'); ?></h5>
                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush list-group-numbered">
                        <li class="list-group-item"><?php echo app('translator')->get("A country won't be displayed in the frontend if it is disabled."); ?></li>
                        <li class="list-group-item"><?php echo app('translator')->get("A country won't be displayed as receiving country in the frontend if it has no active service."); ?></li>
                        <li class="list-group-item"><?php echo app('translator')->get("If you don't set the conversion rate for a combination of sending and receiving countries, then the rate will be calculated by the rate in base currency."); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Name / Currency']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Name / Currency']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
    <button class="btn btn-outline--info" data-bs-target="#helpModal" data-bs-toggle="modal" type="button">
        <i class="la la-info-circle"></i> <?php echo app('translator')->get('Info'); ?>
    </button>
    <button class="btn btn-outline--primary cuModalBtn" data-modal_title="<?php echo app('translator')->get('Add New Country'); ?>" type="button">
        <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
    </button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .table-responsive {
            overflow-x: hidden !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
                "use strict";
                let cuModal = $('#cuModal');
                $('input[name=currency]').on('input', function() {
                    $('.currency').text($(this).val());
                });

                $('.cuModalBtn').on('click', function() {
                    let countryCode = `<?php echo e(old('country_code')); ?>`;
                    cuModal.find('[type=checkbox]').bootstrapToggle("off");
                    let resource = $(this).data('resource');

                    if (resource) {
                        toggleSwitch(resource.has_agent, 'has_agent')
                        toggleSwitch(resource.is_sending, 'is_sending')
                        toggleSwitch(resource.is_receiving, 'is_receiving')
                        $('.currency').text(resource.currency);

                        $("[name=country_code]").val(resource.country_code).change();
                        cuModal.find('.image-upload-preview').css('background-image',
                            `url(${$(this).data('image')})`);
                    } else {
                        $("[name=country_code]").val('').change();
                        cuModal.find(".image-upload-preview").css("background-image",
                            `url(<?php echo e(getImage(null, getFileSize('country'))); ?>`);
                    }
                });

                function toggleSwitch(data, fieldName) {
                    let element = cuModal.find(`[name=${fieldName}]`);
                        if (data) {
                            $(element).bootstrapToggle("on");
                        } else {
                            $(element).bootstrapToggle("off");
                        }
                    }

                    $('select[name=country_code]').on('change', function() {
                        $('[name=currency]').val($(this).find(':selected').data('currency'));
                        $('.currency').text($(this).find(':selected').data('currency'));
                    });

                    $('.editBtn').on('click', function() {
                        $('[type=file]').removeAttr('required');
                    });

                    cuModal.on('hidden.bs.modal', function() {
                        $('[type=file]').attr('required', true);
                    });
                })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/admin/country/index.blade.php ENDPATH**/ ?>