<?php $__env->startSection('panel'); ?>
    <form method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-12 col-md-12 mb-30">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label> <?php echo app('translator')->get('Site Title'); ?></label>
                                    <input class="form-control" type="text" name="site_name" required value="<?php echo e(gs('site_name')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Currency'); ?></label>
                                    <input class="form-control" type="text" name="cur_text" required value="<?php echo e(gs('cur_text')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Currency Symbol'); ?></label>
                                    <input class="form-control" type="text" name="cur_sym" required value="<?php echo e(gs('cur_sym')); ?>">
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label class="required"> <?php echo app('translator')->get('Timezone'); ?></label>
                                <select class="select2 form-control" name="timezone">
                                    <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(@$key); ?>" <?php if(@$key == $currentTimezone): echo 'selected'; endif; ?>><?php echo e(__($timezone)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label class="required"> <?php echo app('translator')->get('Site Base Color'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker" value="<?php echo e(gs('base_color')); ?>">
                                    </span>
                                    <input type="text" class="form-control colorCode" name="base_color" value="<?php echo e(gs('base_color')); ?>">
                                </div>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> <?php echo app('translator')->get('Record to Display Per page'); ?></label>
                                <select class="select2 form-control" name="paginate_number" data-minimum-results-for-search="-1">
                                    <option value="20" <?php if(gs('paginate_number') == 20): echo 'selected'; endif; ?>><?php echo app('translator')->get('20 items per page'); ?></option>
                                    <option value="50" <?php if(gs('paginate_number') == 50): echo 'selected'; endif; ?>><?php echo app('translator')->get('50 items per page'); ?></option>
                                    <option value="100" <?php if(gs('paginate_number') == 100): echo 'selected'; endif; ?>><?php echo app('translator')->get('100 items per page'); ?></option>
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6 ">
                                <label class="required"> <?php echo app('translator')->get('Currency Showing Format'); ?></label>
                                <select class="select2 form-control" name="currency_format" data-minimum-results-for-search="-1">
                                    <option value="1" <?php if(gs('currency_format') == Status::CUR_BOTH): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Text and Symbol Both'); ?></option>
                                    <option value="2" <?php if(gs('currency_format') == Status::CUR_TEXT): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Text Only'); ?></option>
                                    <option value="3" <?php if(gs('currency_format') == Status::CUR_SYM): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Symbol Only'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 mb-30">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title"><?php echo app('translator')->get('User Send Money Setting'); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Limit Per Send Money'); ?> <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount user can send in each send money transaction.'); ?>"></i></label>
                                    <div class="input-group">
                                        <input class="form-control" name="user_send_money_limit" type="number" value="<?php echo e(getAmount(gs('user_send_money_limit'))); ?>" min="0" step="any">
                                        <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Daily Send Money Limit'); ?> <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount user can send on a calender date.'); ?>"></i></label>
                                    <div class="input-group">
                                        <input class="form-control" name="user_daily_send_money_limit" type="number" value="<?php echo e(getAmount(gs('user_daily_send_money_limit'))); ?>" min="0" step="any">
                                        <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Monthly Send Money Limit'); ?> <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount user can send on a calender month.'); ?>"></i></label>
                                    <div class="input-group">
                                        <input class="form-control" name="user_monthly_send_money_limit" type="number" value="<?php echo e(getAmount(gs('user_monthly_send_money_limit'))); ?>" min="0" step="any">
                                        <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(gs('agent_module')): ?>
                <div class="col-12 mb-30">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title"><?php echo app('translator')->get('Agent Setting'); ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label>
                                            <?php echo app('translator')->get('Limit Per Send Money'); ?>
                                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount agent can send in each send money transaction.'); ?>"></i>
                                        </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_send_money_limit" type="number" value="<?php echo e(getAmount(gs('agent_send_money_limit'))); ?>" min="0" step="any">
                                            <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label>
                                            <?php echo app('translator')->get('Daily Send Money Limit'); ?>
                                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount agent can send on a calender date.'); ?>"></i>
                                        </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_daily_send_money_limit" type="number" value="<?php echo e(getAmount(gs('agent_daily_send_money_limit'))); ?>" min="0" step="any">
                                            <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label>
                                            <?php echo app('translator')->get('Monthly Send Money Limit'); ?>
                                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The amount agent can send on a calender month.'); ?>"></i>
                                        </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_monthly_send_money_limit" type="number" value="<?php echo e(getAmount(gs('agent_monthly_send_money_limit'))); ?>" min="0" step="any">
                                            <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label>
                                            <?php echo app('translator')->get('Fixed Charge'); ?>
                                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The charge will be applied when the user sends money via an agent.'); ?>"></i>
                                        </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_charges[fixed_charge]" type="number" value="<?php echo e(getAmount(gs('agent_charges')->fixed_charge)); ?>" min="0" step="any">
                                            <div class="input-group-text cur_text">
                                                <?php echo e(gs('cur_text')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label>
                                            <?php echo app('translator')->get('Percent Charge'); ?>
                                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The charge will be applied when the user sends money via an agent.'); ?>"></i>
                                        </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_charges[percent_charge]" type="number" value="<?php echo e(getAmount(gs('agent_charges')->percent_charge)); ?>" min="0" step="any">
                                            <div class="input-group-text cur_text">%</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label><?php echo app('translator')->get('OTP Validity'); ?> </label>
                                        <div class="input-group">
                                            <input class="form-control" name="resent_code_duration" type="text" value="<?php echo e(gs('resent_code_duration')); ?>">
                                            <span class="input-group-text">
                                                <?php echo app('translator')->get('Seconds'); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label> <?php echo app('translator')->get('Fixed Commission'); ?></label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_fixed_commission" type="number" value="<?php echo e(getAmount(gs('agent_fixed_commission'))); ?>" min="0" step="any">
                                            <div class="input-group-text cur_text">
                                                <?php echo e(gs('cur_text')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-lg-6 col-sm-6">
                                    <div class="form-group">
                                        <label><?php echo app('translator')->get('Percent Commission'); ?> </label>
                                        <div class="input-group">
                                            <input class="form-control" name="agent_percent_commission" type="number" value="<?php echo e(getAmount(gs('agent_percent_commission'))); ?>" min="0" step="any">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-12 mb-30">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title"><?php echo app('translator')->get('Referral Setting'); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Referral Commission'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="referral_commission" type="number" value="<?php echo e(getAmount(gs('referral_commission'))); ?>" min="0" step="any">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>
                                        <?php echo app('translator')->get('How Many Times'); ?>
                                        <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The number of times a referrer get commission from a single referee.'); ?>"></i>
                                    </label>
                                    <input class="form-control" name="commission_count" type="number" value="<?php echo e(gs('commission_count')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/spectrum.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/spectrum.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/admin/setting/general.blade.php ENDPATH**/ ?>