@php
    $contactContent = getContent('contact.content', true);
    $appContent = getContent('app.content', true);
    $policyPages = getContent('policy_pages.element', false, null, true);
    //dd($policyPages);
@endphp

 <footer class="footer-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="newsletter">
                    <div class="section-area mb-30 dark-sec text-center">
                        <h3 class="title">Subscribe to Our Newsletter</h3>
                    </div>
                    <form action="#">
                        <div class="form-group d-flex flex-wrap align-items-center">
                            <input type="email" class="form-control flex-grow-1 me-2" placeholder="Your Email Address">
                            <button type="submit" class="btn btn-primary d-flex align-items-center">
                                <i class="la la-long-arrow-right"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="footer-area">
            <div class="row g-4 gy-sm-5 justify-content-xl-between" style="border-bottom: 1px solid #e5e7eb;padding-bottom: 30px; padding-top: 60px">
                <div class="pt-100 col-sm-6 col-lg-4 col-xxl-3">
                <h5 class="text--white widget__title mt-0">@lang('About Company')</h5>
                <p class="text--white t-short-para mb-0">
                    {{ __(@$appContent->data_values->short_description) }}
                </p>
    
            </div>
                <div class="pt-100 col-sm-6 col-lg-2 col-xl-2">
                    <h5 class="text--white widget__title mt-0">@lang('Accounts')</h5>
                    <ul class="list list--column list--base">
                        <li class="list--column__item">
                            <a href="{{ route('user.login') }}" class="t-link t-link--base text--white d-inline-block">
                                @lang('Login')
                            </a>
                        </li>
                        <li class="list--column__item">
                            <a href="{{ route('user.register') }}"
                                class="t-link t-link--base text--white d-inline-block">
                                @lang('Register')
                            </a>
                        </li>
                        <li class="list--column__item">
                            <a href="{{ route('agent.login') }}" class="t-link t-link--base text--white d-inline-block">
                                @lang('Agent Login')
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="pt-100 col-sm-6 col-lg-3 col-xl-2">
                    <h5 class="text--white widget__title mt-0">@lang('Policy Pages')</h5>
                    <ul class="list list--column list--base">
                        @foreach (@$policyPages ?? [] as $page)
                            <li class="list--column__item">
                                <a href="{{ route('policy.pages', $page->slug) }}"
                                    class="t-link t-link--base text--white d-inline-block">
                                     {{ __($page->data_values->title) }}
                                    
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="pt-100 col-sm-6 col-lg-3 col-xl-4 col-xxl-3">
                        <h5 class="text--white widget__title mt-0">
                            @lang('Contact Us')
                        </h5>
                        <ul class="list list--column">
                            <li class="list--column__item">
                                <div class="contact-card">
                                    <div class="contact-card__icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="contact-card__content">
                                        <p class="text--white mb-0">
                                            {{ __(@$contactContent->data_values->address) }}
                                        </p>
                                    </div>
                                </div>
                            </li>
                            <li class="list--column__item">
                                <div class="contact-card">
                                    <div class="contact-card__icon">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div class="contact-card__content">
                                        <a href="Mailto:{{ @$contactContent->data_values->email }}" class="text-decoration-none">
                                            <p class="text--white mb-0">
                                                {{ __(@$contactContent->data_values->email) }}
                                            </p>
                                        </a>
                                    </div>
                                </div>
                            </li>
                            <li class="list--column__item">
                                <div class="contact-card">
                                    <div class="contact-card__icon">
                                        <i class="fas fa-phone-alt"></i>
                                    </div>
                                    <div class="contact-card__content">
                                        <a href="Tel:{{ @$contactContent->data_values->mobile }}" class="text-decoration-none">
                                            <p class="text--white mb-0">
                                                {{ __(@$contactContent->data_values->mobile) }}
                                            </p>
                                        </a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
            </div>
        </div>
        <div class="footer-bottom" style="padding-top: 30px; padding-bottom: 30px;">
            <div class="row justify-content-between align-items-center">
                <div class="col-md-6 col-sm-8 d-flex justify-content-center justify-content-sm-start order-sm-0 order-1">
                    <div class="copyright text-center text-sm-start">
                        <p style="color:white"> @lang('Copyright') &copy; <span class="currentYear" style="color:white">{{ __(date('Y')) }}</span> @lang('All Rights Reserved').</p>
                    </div>
                </div>
                <div class="col-md-6 col-sm-4">
                    <div class="social-link d-flex justify-content-sm-end justify-content-center align-items-center text-white">
                        <a href="#" class="me-3"><i class="lab la-facebook-f" style="color:white"></i></a>
                        <a href="#" class="me-3"><i class="lab la-linkedin-in" style="color:white"></i></a>
                        <a href="#" class="me-3"><i class="lab la-instagram" style="color:white"></i></a>
                        <a href="#"><i class="lab la-twitter" style="color:white"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<!--<footer class="footer bg--accent">-->
<!--    <div class="section">-->
<!--        <div class="container">-->
<!--            <div class="row g-4 gy-sm-5 justify-content-xl-between">-->
<!--                <div class="col-sm-6 col-lg-4 col-xxl-3">-->
<!--                    <h5 class="text--white widget__title mt-0">@lang('About Company')</h5>-->
<!--                    <p class="text--white t-short-para mb-0">-->
<!--                        {{ __(@$appContent->data_values->short_description) }}-->
<!--                    </p>-->

<!--                </div>-->
<!--                <div class="col-sm-6 col-lg-2 col-xl-2">-->
<!--                    <h5 class="text--white widget__title mt-0">@lang('Accounts')</h5>-->
<!--                    <ul class="list list--column list--base">-->
<!--                        <li class="list--column__item">-->
<!--                            <a href="{{ route('user.login') }}" class="t-link t-link--base text--white d-inline-block">-->
<!--                                @lang('Login')-->
<!--                            </a>-->
<!--                        </li>-->
<!--                        <li class="list--column__item">-->
<!--                            <a href="{{ route('user.register') }}"-->
<!--                                class="t-link t-link--base text--white d-inline-block">-->
<!--                                @lang('Register')-->
<!--                            </a>-->
<!--                        </li>-->
<!--                        <li class="list--column__item">-->
<!--                            <a href="{{ route('agent.login') }}" class="t-link t-link--base text--white d-inline-block">-->
<!--                                @lang('Agent Login')-->
<!--                            </a>-->
<!--                        </li>-->
<!--                    </ul>-->
<!--                </div>-->
<!--                <div class="col-sm-6 col-lg-3 col-xl-2">-->
<!--                    <h5 class="text--white widget__title mt-0">@lang('Policy Pages')</h5>-->
<!--                    <ul class="list list--column list--base">-->
<!--                        @foreach (@$policyPages ?? [] as $page)-->
<!--                            <li class="list--column__item">-->
<!--                                <a href="{{ route('policy.pages', $page->slug) }}"-->
<!--                                    class="t-link t-link--base text--white d-inline-block">-->
<!--                                   
<!--                                </a>-->
<!--                            </li>-->
<!--                        @endforeach-->
<!--                    </ul>-->
<!--                </div>-->
<!--                <div class="col-sm-6 col-lg-3 col-xl-4 col-xxl-3">-->
<!--                    <h5 class="text--white widget__title mt-0">-->
<!--                        @lang('Contact Us')-->
<!--                    </h5>-->
<!--                    <ul class="list list--column">-->
<!--                        <li class="list--column__item">-->
<!--                            <div class="contact-card">-->
<!--                                <div class="contact-card__icon">-->
<!--                                    <i class="fas fa-map-marker-alt"></i>-->
<!--                                </div>-->
<!--                                <div class="contact-card__content">-->
<!--                                    <p class="text--white mb-0">-->
<!--                                        {{ __(@$contactContent->data_values->address) }}-->
<!--                                    </p>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </li>-->
<!--                        <li class="list--column__item">-->
<!--                            <div class="contact-card">-->
<!--                                <div class="contact-card__icon">-->
<!--                                    <i class="fas fa-envelope"></i>-->
<!--                                </div>-->
<!--                                <div class="contact-card__content">-->
<!--                                    <a href="Mailto:{{ @$contactContent->data_values->email }}" class="text-decoration-none">-->
<!--                                        <p class="text--white mb-0">-->
<!--                                            {{ __(@$contactContent->data_values->email) }}-->
<!--                                        </p>-->
<!--                                    </a>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </li>-->
<!--                        <li class="list--column__item">-->
<!--                            <div class="contact-card">-->
<!--                                <div class="contact-card__icon">-->
<!--                                    <i class="fas fa-phone-alt"></i>-->
<!--                                </div>-->
<!--                                <div class="contact-card__content">-->
<!--                                    <a href="Tel:{{ @$contactContent->data_values->mobile }}" class="text-decoration-none">-->
<!--                                        <p class="text--white mb-0">-->
<!--                                            {{ __(@$contactContent->data_values->mobile) }}-->
<!--                                        </p>-->
<!--                                    </a>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </li>-->
<!--                    </ul>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->

<!--    <div class="footer-copyright bg--accent-dark py-3">-->
<!--        <p class="sm-text text--white mb-0 text-center">@lang('Copyright') &copy; {{ __(date('Y')) }}. @lang('All Rights Reserved')-->
<!--        </p>-->
<!--    </div>-->
<!--</footer>-->
