@extends($activeTemplate . 'layouts.app')
@section('panel')
    @include($activeTemplate . 'partials.user_header')

    @yield('content')

    @include($activeTemplate . 'partials.footer')
@endsection


@push('script')
<script>
    "use strict";
document.addEventListener("DOMContentLoaded", function () {

  $(function ($) {

    // preloader
    $("#preloader").delay(300).animate({
      "opacity": "0"
    }, 500, function () {
      $("#preloader").css("display", "none");
    });

    // Scroll Top
    var ScrollTop = $(".scrollToTop");
    $(window).on('scroll', function () {
      if ($(this).scrollTop() < 500) {
        ScrollTop.removeClass("active");
      } else {
        ScrollTop.addClass("active");
      }
    });
    $('.scrollToTop').on('click', function () {
      $('html, body').animate({
        scrollTop: 0
      }, 500);
      return false;
    });

    // Navbar Dropdown
    var dropdown_menu = $(".header-section .dropdown-menu");
    $(window).resize(function () {
      if ($(window).width() < 992) {
        dropdown_menu.removeClass('show');
      }
      else {
        dropdown_menu.addClass('show');
      }
    });
    if ($(window).width() < 992) {
      dropdown_menu.removeClass('show');
    }
    else {
      dropdown_menu.addClass('show');
    }

    // Sticky Header
    var fixed_top = $(".header-section");
    $(window).on("scroll", function () {
      if ($(window).scrollTop() > 50) {
        fixed_top.addClass("animated fadeInDown header-fixed");
      }
      else {
        fixed_top.removeClass("animated fadeInDown header-fixed");
      }
    });

    // language active
    var language = $(".language-content li");
    $(language).on('mouseover', function () {
      $(language).removeClass('active');
      $(this).addClass('active');
    });

    // checkbox active
    var checkbox = $(".checkbox-single");
    $(checkbox).on('mouseover', function () {
      $(checkbox).removeClass('active');
      $(this).addClass('active');
    });

    // Card Popup
    $('.card-popup .cancel').click(function(){
      $(".card-popup #limit-tab").click();
    });

    // Transactions Popup
    $('.transactions .cancel').click(function(){
      $(".card-popup #limit-tab").click();
    });

    // Confirm Popup
    $('.transfer-popup .confirm').click(function(){
      $(".transfer-popup #success-tab").click();
    });

    // transferMod Popup
    $('.transferMod').click(function(){
      if($("#success").hasClass( "active" )){
        $(".transfer-popup #transfer-tab").click();
      }
    });

    // User Active
    $('.header-section .sidebar-icon').on('click', function () {
      $('.sidebar-wrapper').toggleClass('active');
      $(".header-section").toggleClass("body-collapse");
      $(".dashboard-section").toggleClass("body-collapse");
    });

    // Sidebar Wrapper Close
    $(".sidebar-wrapper .close-btn").click(function () {
      $(".sidebar-wrapper").toggleClass("active");
      $(".header-section").toggleClass("body-collapse");
      $(".dashboard-section").toggleClass("body-collapse");
    });

    // sidebar body active
    var sidebar_wrapper = $(".sidebar-wrapper");
    var body_collapse = $(".header-section");
    $(window).resize(function () {
      if ($(window).width() > 1399) {
        sidebar_wrapper.removeClass('active');
        body_collapse.addClass('body-collapse');
      }
      else {
        sidebar_wrapper.addClass('active');
        body_collapse.removeClass('body-collapse');
      }
    });
    if ($(window).width() > 1399) {
      sidebar_wrapper.removeClass('active');
      body_collapse.addClass('body-collapse');
    }
    else {
      sidebar_wrapper.addClass('active');
      body_collapse.removeClass('body-collapse');
    }

    // Header Active
    $('.single-item .profile-area').on('click', function () {
      $('.user-content').toggleClass('active');
      $('.notifications-content').removeClass('active');
      $('.language-content').removeClass('active');
    });
    $('.single-item .notifications-btn').on('click', function () {
      $('.notifications-content').toggleClass('active');
      $('.user-content').removeClass('active');
      $('.language-content').removeClass('active');
    });
    $('.single-item .language-btn').on('click', function () {
      $('.language-content').toggleClass('active');
      $('.user-content').removeClass('active');
      $('.notifications-content').removeClass('active');
    });

    // Dropdown Active Remove
    $("section").click(function () {
      $('.user-content').removeClass('active');
      $('.notifications-content').removeClass('active');
      $('.language-content').removeClass('active');
    });

  });
});
</script>
<script>
    "use strict";
document.addEventListener("DOMContentLoaded", function () {

  $(function ($) {

    /* niceSelect */
    $("select").niceSelect();

    // Apexcharts
    if (document.querySelector('#chart') !== null) { 
    var options = {
      labels: ["Send", "Receive", "Payment", "Deposit", "Withdraw"],
      series: [44, 55, 13, 33, 22],
      chart: {
      width: 350,
      type: 'donut',
    },
    dataLabels: {
      enabled: false
    },
    responsive: [
      {
        breakpoint: 1449,
        options: {
          chart: {
            width: 300
          },
          legend: {
            show: true
          }
        }
      },
      {
        breakpoint: 1200,
        options: {
          chart: {
            width: 250
          },
          legend: {
            show: true
          }
        }
      },
      {
        breakpoint: 992,
        options: {
          chart: {
            width: 350
          },
          legend: {
            show: true
          }
        }
      },
      {
        breakpoint: 577,
        options: {
          chart: {
            width: 250
          },
          legend: {
            show: true
          }
        }
      },
    ],
      legend: {
        position: 'right',
        offsetY: 0,
        height: 230,
      }
    };
    var chart = new ApexCharts(document.querySelector("#chart"), options);
    chart.render();
    }

    /* Wow js */
    new WOW().init();

  });
});

</script>
@endpush

@push('style')
<style>
@import url("https://fonts.googleapis.com/css2?family=Jost:wght@200;300;400;500;600;700;800;900&display=swap");
:root {
  --body-font: "Jost", sans-serif;
  --body-color: #FFFFFF;
  /*--primary-color: rgb(43 107 127 / var(--tw-bg-opacity, 1));*/
  --primary-color: rgb(43 107 127 / var(--tw-bg-opacity, 1));
  --secondary-color: #0c266c;
  --head-color: #0c266c;
  --section-primary-color: #f2f3f9;
  --section-color: #f5f6fc;
  --para-color: #0c266c;
  --border-color: #868ea5;
  --hover-alt-color: #291b6b;
}

body.dark-mode {
    --para-color: rgb(156 163 175 / 1);     /* the color you want */
    --body-color: rgb(28 28 30 / 1);
    --heading-color: rgb(243 244 246 / 1);
    --section-color: rgb(43 107 127 / var(--tw-bg-opacity, 1));
}

.collapsing {
  transition: 0.3s;
}

html {
  scroll-behavior: smooth;
}

body {
  font-family: var(--body-font);
  --tw-bg-opacity: 1;
  background-color: rgb(248 249 250 / var(--tw-bg-opacity, 1));
  --tw-text-opacity: 1;
  color: rgb(17 24 39 / var(--tw-text-opacity, 1));
  /*background-color: var(--body-color);*/
  font-size: 18px;
  line-height: 30px;
  padding: 0;
  margin: 0;
  font-weight: 400;
  overflow-x: hidden;
  top: 0 !important;
}

body.dark-mode {
    --tw-bg-opacity: 1;
    background-color: rgb(28 28 30 / var(--tw-bg-opacity, 1));
    --tw-text-opacity: 1;
    color: rgb(243 244 246 / var(--tw-text-opacity, 1))
}


section,
footer {
  overflow-x: hidden;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  padding: 0;
  margin: 0;
}

h1,
h1 > a,
h2,
h2 > a,
h3,
h3 > a,
h4,
h4 > a,
h5,
h5 > a,
h6,
h6 > a {
  font-family: var(--body-font);
  color: var(--primary-color);
  font-weight: 600;
  text-transform: initial;
  transition: all 0.3s;
}

body.dark-mode h1,
body.dark-mode h1 > a,
body.dark-mode h2,
body.dark-mode h2 > a,
body.dark-mode h3,
body.dark-mode h3 > a,
body.dark-mode h4,
body.dark-mode h4 > a,
body.dark-mode h5,
body.dark-mode h5 > a,
body.dark-mode h6,
body.dark-mode h6 > a {
  color: var(--primary-color); /* or your dark-mode heading color */
}

h1 > a:hover,
h2 > a:hover,
h3 > a:hover,
h4 > a:hover,
h5 > a:hover,
h6 > a:hover {
  color: var(--para-color);
}

a,
a:focus,
a:hover {
  text-decoration: none;
  outline: none;
  color: var(--para-color);
}

img {
  max-width: 100%;
  height: auto;
}

.max-un {
  max-width: unset;
}

.d-rtl {
  direction: rtl;
}

ul,
ol {
  padding: 0;
  margin: 0;
  list-style: none;
}

input:focus,
textarea:focus {
  outline: none;
  box-shadow: none;
  border: 1px solid var(--border-color);
}

button {
  border: none;
  cursor: pointer;
}

input,
textarea {
  padding: 10px 20px;
  color: var(--para-color);
  width: 100%;
  font-family: var(--body-font);
  background: var(--bs-white);
  border: 1px solid #eeecf7;
  border-radius: 10px;
}

::-moz-placeholder {
  color: rgba(12, 38, 110, 0.502);
  opacity: 1;
}

::placeholder {
  color: rgba(12, 38, 110, 0.502);
  opacity: 1;
}

:-ms-input-placeholder {
  color: rgba(12, 38, 110, 0.502);
}

::-ms-input-placeholder {
  color: rgba(12, 38, 110, 0.502);
}

input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

input[type=number] {
  -moz-appearance: textfield;
}

input[type=password] {
  font-family: initial;
}

input[type=checkbox] {
  width: initial;
  height: initial;
}

select {
  padding: 10px 20px;
  border: none;
  cursor: pointer;
  outline: none;
}

textarea {
  min-height: 150px;
  resize: none;
}

span {
  display: inline-block;
}

/*.table thead th,*/
/*.table td,*/
/*.table th {*/
/*  border: none;*/
/*}*/

.d-grid {
  display: grid !important;
}

.b-none {
  border: none !important;
}

.ovf-unset {
  overflow-x: unset !important;
}

iframe {
  border: 0;
  width: 100%;
}

.shadow-none {
  box-shadow: none;
}

h1,
h1 > a {
  font-size: 76px;
  line-height: 98.8px;
  margin-top: -20px;
}

h2,
h2 > a {
  font-size: 57px;
  line-height: 74.1px;
  margin-top: -16px;
}

h3,
h3 > a {
  font-size: 43px;
  line-height: 55.9px;
  margin-top: -10px;
}

h4,
h4 > a {
  font-size: 32px;
  line-height: 41.6px;
  margin-top: -8px;
}

h5,
h5 > a {
  font-size: 24px;
  line-height: 31.2px;
  margin-top: -6px;
}

h6,
h6 > a {
  font-size: 18px;
  line-height: 23.4px;
  margin-top: -4px;
}

h1.m-none,
h2.m-none,
h3.m-none,
h4.m-none,
h5.m-none {
  margin: 0;
}

table thead tr th {
  font-size: 18px;
  line-height: 30px;
}

a {
  display: inline-block;
  color: var(--para-color);
  font-weight: 400;
  font-size: 18px;
  line-height: 30px;
}

p,
span,
li,
label {
  margin: 0;
  font-family: var(--body-font);
  font-size: 18px;
  font-weight: 400;
  color: var(--para-color);
  line-height: 30px;
}

.section-text {
  margin-bottom: 34px;
}

.section-header {
  margin-bottom: 53px;
}

.dark-sec .sub-title {
  color: var(--secondary-color);
}

body.dark-mode .title .sub-title {
  color: var(#0c266c);
}
.dark-sec .title, .dark-sec p {
  color: var(--bs-white);
}

.sub-title {
  color: var(--primary-color);
  margin-bottom: 30px;
}

.title {
  font-weight: 700;
  margin-bottom: 22px;
}

.xxlr {
  font-size: 26px;
  line-height: 36px;
  margin-top: -7px;
}

.xlr {
  font-size: 24px;
  line-height: 36px;
  margin-top: -7px;
}

.mdr {
  font-size: 16px;
  line-height: 22px;
}

.z-1 {
  z-index: 1;
}

.mb-30 {
  margin-bottom: 30px;
}

.mt-30 {
  margin-top: 30px;
}

.mb-40 {
  margin-bottom: 40px;
}

.mt-40 {
  margin-top: 40px;
}

.mb-60 {
  margin-bottom: 60px;
}

.mt-60 {
  margin-top: 60px;
}

.mb-80 {
  margin-bottom: 80px;
}

.mt-80 {
  margin-top: 80px;
}

.pt-120 {
  padding-top: 120px;
}

@media (max-width: 991px) {
  .pt-120 {
    padding-top: 60px;
  }
  .mb-60 {
    margin-bottom: 40px;
  }
  .mt-60 {
    margin-top: 40px;
  }
  .mb-80 {
    margin-bottom: 60px;
  }
  .mt-80 {
    margin-top: 60px;
  }
  .header-section {
    box-shadow: 0px 3px 10px 0px rgba(0, 0, 0, 0.3);
    background-color: var(--bs-white);
  }
  body.dark-mode .header-section {
    background-color: #111827f2;
  }
}
@media (max-width: 575px) {
  .pt-120 {
    padding-top: 50px;
  }
}
.pb-120 {
  padding-bottom: 120px;
}

@media (max-width: 991px) {
  .pb-120 {
    padding-bottom: 60px;
  }
}
@media (max-width: 575px) {
  .pb-120 {
    padding-bottom: 50px;
  }
}
*::-webkit-scrollbar-track {
  background: #00003e;
}

*::-webkit-scrollbar {
  width: 6px;
}

*::-webkit-scrollbar-button,
*::-webkit-scrollbar-thumb {
  background-color: #5732c6;
}

.scrollToTop {
  position: fixed;
  bottom: 0;
  right: 30px;
  width: 45px;
  height: 45px;
  background-color: var(--primary-color);
  border-radius: 5px;
  color: #fff;
  line-height: 45px;
  font-size: 20px;
  text-align: center;
  z-index: 9;
  cursor: pointer;
  transition: all 1s;
  transform: translateY(100%);
}
.scrollToTop i {
  color: var(--bs-white);
}
.scrollToTop.active {
  bottom: 30px;
  transform: translateY(0%);
}

.preloader {
  position: fixed;
  width: 100%;
  height: 100vh;
  z-index: 99999999;
  overflow: visible;
  background: url(/images/preloader.gif) no-repeat center center;
  background-size: 20%;
  background-color: #F8F8F7;
}

.icon-svg {
  position: relative;
}
.icon-svg img {
  opacity: 1;
  position: absolute;
}
.icon-svg svg {
  position: absolute;
  stroke-dashoffset: 1500;
  stroke-dasharray: 1500;
  transform: scale(1);
  transition: transform 0.3s, fill 0.5s;
  opacity: 0;
  visibility: hidden;
}
.icon-svg:hover svg {
  visibility: visible;
  opacity: 1;
  stroke-dashoffset: 0;
  fill: transparent;
  transition: transform 0.3s, fill 0.5s, stroke-dashoffset 6s;
}
.icon-svg:hover img {
  opacity: 0;
  visibility: hidden;
}

.accordion-button:focus {
  box-shadow: none;
}

.animated {
  animation-duration: 1s;
  animation-fill-mode: both;
}

@keyframes fadeInDown {
  from {
    opacity: 0;
    transform: translate3d(0, -100%, 0);
  }
  to {
    opacity: 1;
    transform: none;
  }
}
.fadeInDown {
  animation-name: fadeInDown;
}

.select2 .select2-selection {
  padding: 0;
  height: initial;
  border: none;
}
/*.select2 .select2-selection__rendered {*/
/*  line-height: 150% !important;*/
/*}*/
.select2 .select2-selection {
  display: flex;
  align-items: center;
}
.select2 .select2-selection__arrow {
  width: 0 !important;
  height: 0 !important;
  display: flex;
  align-items: center;
  justify-content: center;
  top: initial !important;
}
.select2 .select2-selection__arrow b {
  display: none;
}
.select2 .select2-selection__arrow:after {
  content: "\f078";
  font-family: "Font Awesome 5 Free";
  font-weight: 600;
  color: rgba(var(--p2), 1);
  position: absolute;
  border: none;
  right: 15px;
  transition: all 0.5s ease-in-out;
}
.select2.select2-container--open .select2-selection__arrow::after {
  transform: rotate(180deg);
}

.select2-results li:hover, .select2-results li.select2-results__option--highlighted, .select2-results li.select2-results__option--selected {
  background-color: var(--primary-color) !important;
  color: var(--bs-white) !important;
}

.select2-dropdown.select2-dropdown--below {
  width: 180px !important;
}

/*.select2-selection__rendered,*/
/*.select2-container--default {*/
/*  width: 55px !important;*/
/*  max-width: 55px !important;*/
/*  min-width: 55px !important;*/
/*}*/

/*.select2-selection__rendered {*/
/*  opacity: 0;*/
/*}*/

.skiptranslate {
  pointer-events: none;
  display: none !important;
}

/* cmn btn */
.cmn-btn {
  padding: 10px 30px;
  font-weight: 600;
  text-align: center;
  background: var(--primary-color);
  color: var(--bs-white);
  transition: 0.3s;
  border-radius: 10px;
  border: 1px solid transparent;
  display: inline-flex;
  justify-content: center;
  align-items: center;
}
.cmn-btn:hover {
  background: transparent;
  border: 1px solid var(--border-color);
  color: var(--para-color);
}
.cmn-btn img, .cmn-btn i {
  margin-left: 10px;
}
.cmn-btn.active {
  background-color: transparent;
  border: 1px solid var(--border-color);
  color: var(--para-color);
}
.cmn-btn.active:hover {
  background: var(--primary-color);
  color: var(--bs-white);
}

@keyframes spin {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}
@keyframes ripple2Ani {
  0% {
    transform: translate(0px, 0px);
  }
  33% {
    transform: translate(-5px, -5px);
  }
  66% {
    transform: translate(5px, 5px);
  }
  100% {
    transform: translate(0px, 0px);
  }
}
@keyframes stretch {
  0% {
    transform: scale(0.5);
  }
  50% {
    transform: scale(0.8);
  }
  100% {
    transform: scale(1);
  }
  0% {
    transform: scale(1);
  }
  50% {
    transform: scale(0.8);
  }
  100% {
    transform: scale(0.5);
  }
}
@keyframes rippleAni {
  0% {
    transform: translate(0px, 0px);
  }
  33% {
    transform: translate(5px, -5px);
  }
  66% {
    transform: translate(-5px, 5px);
  }
  100% {
    transform: translate(0px, 0px);
  }
}
.header-section {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  z-index: 999;
  background-color: var(--bs-white);
  border-bottom: 1px solid #6c6ea6;
}
body.dark-mode .header-section {
    background-color: #111827f2;
}
.header-section.header-fixed {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  z-index: 999;
  box-shadow: 0px 3px 10px 0px rgba(0, 0, 0, 0.3);
  background-color: var(--bs-white);
  border-color: transparent;
}
body.dark-mode .header-section.header-fixed {
    background-color: #111827f2;
}
.header-section .navbar-toggler {
  padding-right: 0;
  display: none;
  border: none;
}
.header-section .navbar-toggler:focus {
  box-shadow: none;
}
.header-section .navbar-toggler i {
  color: var(--head-alt-color);
}
.header-section .navbar {
  padding: 23px 15px;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link,
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-item {
  font-weight: 500;
  padding: 0 10px;
  text-transform: capitalize;
  font-weight: 600;
  background-color: transparent;
  color: var(--para-color);
  transition: 0.3s;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link:hover,
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-item:hover {
  color: var(--primary-color);
  transition: 0.3s;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link.active,
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-item.active {
  color: var(--primary-color);
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link.dropdown-toggle {
  margin-right: 15px;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link.dropdown-toggle::after {
  position: absolute;
  content: "C";
  border: none;
  font-family: "arafat font";
  font-weight: 400;
  font-size: 14px;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu {
  background-color: var(--body-color);
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu li a {
  display: block;
  padding: 5px 15px;
  transition: 0.3s;
}
.header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu .dropend .dropdown-menu {
  margin-left: 20%;
}
.header-section .navbar .navbar-collapse .right-area {
  margin-left: 48px;
}
.header-section .navbar .navbar-collapse .right-area .login {
  font-weight: 600;
}
.header-section .navbar .navbar-collapse .right-area .cmn-btn {
  margin-left: 15px;
}
.header-section .nav-item.main-navbar .main-menu {
  position: absolute;
  top: 110%;
  left: 50%;
  transform: translateX(-50%);
  min-width: 220px;
  box-shadow: 0px 12px 24px rgba(0, 0, 0, 0.25);
  opacity: 0;
  visibility: hidden;
  transition: 0.3s;
  z-index: 999;
}
.header-section .nav-item.main-navbar .main-menu .sub-navbar {
  position: relative;
}
.header-section .nav-item.main-navbar .main-menu .sub-navbar .sub-menu {
  visibility: hidden;
  position: absolute;
  opacity: 0;
  left: 165px;
  top: 0;
}
.header-section .nav-item.main-navbar .main-menu .sub-navbar:hover .sub-menu {
  opacity: 1;
  visibility: visible;
}
.header-section .nav-item.main-navbar:hover .main-menu {
  opacity: 1;
  visibility: visible;
  top: 30px;
}

.banner-section .overlay {
  background-color: #f2f3f9;
  background-image: url('/assets/images/frontend/banner/bannermap.png');
  background-repeat: no-repeat;
  background-position: top 100px right;
  position: relative;
  background-size: auto;
}
.banner-section .overlay .shape-area img {
  position: absolute;
}
.banner-section .overlay .shape-area .obj-1 {
  left: 0;
  bottom: 5%;
  animation: ripple2Ani 4s linear infinite;
}
.banner-section .overlay .shape-area .obj-2 {
  right: 0;
  bottom: 5%;
  animation: rippleAni 3s linear infinite;
}
.banner-section .overlay .shape-area .obj-3 {
  left: 48%;
  bottom: 12%;
  animation: ripple2Ani 5s linear infinite;
}
.banner-section .overlay .shape-area .obj-4 {
  left: 0;
  top: 0;
}
.banner-section .overlay .banner-content {
  padding: 170px 0 200px;
}
.banner-section .overlay .banner-content .container {
  position: relative;
}
.banner-section .overlay .banner-content .container .content-shape img {
  position: absolute;
}
.banner-section .overlay .banner-content .container .content-shape .obj-1 {
  left: 55%;
  top: 0;
  animation: rippleAni 10s linear infinite;
}
.banner-section .overlay .banner-content .main-content .bottom-area .cmn-btn {
  margin-right: 20px;
}
.banner-section .overlay .banner-content .send-money {
  border-radius: 10px;
  padding: 20px;
  background-color: rgb(255, 255, 255);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
}
.banner-section .overlay .banner-content .send-money .currency-area {
  background-color: #edefff;
  border-radius: 5px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 20px 30px;
}
.banner-section .overlay .banner-content .send-money .currency-area .left-side input {
  padding: 0;
  background-color: transparent;
  font-weight: bold;
  padding-right: 20px;
}
.banner-section .overlay .banner-content .send-money .currency-area .left-side input:focus {
  border: none;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select {
  border-radius: 10px;
  border: none;
  background-color: var(--bs-white);
  padding: 30px 50px 30px 55px;
  display: flex;
  align-items: center;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select:after {
  border-bottom: 2px solid #0c266c;
  border-right: 2px solid #0c266c;
  height: 13px;
  right: 18px;
  top: initial;
  width: 13px;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  font-weight: 600;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select .list {
  width: 100%;
}
.banner-section .overlay .banner-content .send-money .currency-area .right-side.recipient .nice-select .current::before {
  background-image: url(/images/icon/flag-aus.png);
  background-repeat: no-repeat;
}
.banner-section .overlay .banner-content .send-money .calculation {
  padding: 30px 10px;
}
.banner-section .overlay .banner-content .send-money .calculation .highlight {
  color: var(--primary-color);
}
.banner-section .overlay .banner-content .send-money .calculation .head-area img {
  margin-right: 10px;
}
.banner-section .overlay .banner-content .send-money .calculation .single-area {
  margin-top: 17px;
}
.banner-section .overlay .banner-content .send-money .calculation .single-area .left-area {
  min-width: 50%;
  display: flex;
  align-items: center;
}
.banner-section .overlay .banner-content .send-money .calculation .single-area .left-area i {
  font-size: 12px;
  z-index: 1;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-right: 18px;
  position: relative;
}
.banner-section .overlay .banner-content .send-money .calculation .single-area .left-area i::after {
  position: absolute;
  content: "";
  width: 20px;
  height: 20px;
  border-radius: 50%;
  background-color: #edecfb;
  z-index: -1;
}
.banner-section.payment .overlay {
  background-image: url(/images/payment-banner-bg.png);
  background-repeat: no-repeat;
  background-position: top 130px right 50px;
  position: relative;
  background-size: auto;
}
.banner-section.payment .overlay .banner-content {
  padding: 325px 0 245px;
}
.banner-section.payment .overlay .shape-area .obj-1 {
  bottom: 1%;
}
.banner-section.payment .overlay .shape-area .obj-2 {
  bottom: 0;
  animation: none;
}
.banner-section.payment.two .overlay {
  background-image: url(/images/payment-banner-2-bg.png);
  background-position: center right 50px;
}
.banner-section.payment.two .overlay .banner-content {
  padding: 339px 0 260px;
}
.banner-section.business-account .overlay {
  background-image: url(/images/business-globe-1.png), url(/images/business-globe-2.png);
  background-repeat: no-repeat;
  background-position: left top 50px, right bottom;
}
.banner-section.business-account .overlay ul {
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 35px;
}
.banner-section.business-account .overlay ul li {
  margin: 0 15px;
}
.banner-section.business-account .overlay ul li img {
  margin-right: 10px;
}
.banner-section.business-account .overlay .bottom-area .cmn-btn {
  margin-right: 0 !important;
}
.banner-section.business-account .overlay .banner-content {
  padding: 242px 0 365px;
}
.banner-section.business-account .banner-img-bottom {
  margin-top: -280px;
}
.banner-section.business-account .banner-img-bottom .img-area {
  position: relative;
}
.banner-section.business-account .banner-img-bottom .img-area .right-img {
  right: 0;
  bottom: -25px;
  position: absolute;
}
.banner-section.business-account.integrations .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: right bottom;
}
.banner-section.business-account.integrations .overlay .banner-content {
  padding: 208px 0 365px;
}
.banner-section.business-account.integrations .overlay form {
  width: 55%;
  margin: auto;
}
.banner-section.business-account.integrations .overlay form .cmn-btn {
  width: 35%;
  margin-left: 20px;
}
.banner-section.business-account.integrations .overlay form .cmn-btn:hover {
  color: var(--bs-white);
}
.banner-section.business-account.integrations .banner-img-bottom {
  margin-top: -345px;
}
.banner-section.corporate-card .overlay {
  background-image: url(/images/corporate-card-globe.png), url(/images/corporate-banner-img.png);
  background-repeat: no-repeat;
  background-position: left bottom, right 120px bottom;
}
.banner-section.corporate-card .overlay .banner-content {
  padding: 348px 0 250px;
}
.banner-section.corporate-card.expense .overlay {
  background-image: url(/images/corporate-card-globe.png), url(/images/expense-illus.png);
  background-repeat: no-repeat;
  background-position: left bottom, right bottom 120px;
}
.banner-section.corporate-card.subscriptions .overlay {
  background-color: transparent;
  background-image: url(/images/corporate-card-globe.png), url(/images/subscriptions-illus.png);
  background-repeat: no-repeat;
  background-position: left bottom, right bottom 120px;
  border-bottom: 1px solid #a9a8bc;
}
.banner-section.corporate-card.subscriptions .overlay .banner-content {
  padding: 328px 0 220px;
}
.banner-section.corporate-card.budgeting-analytics .overlay {
  background-color: transparent;
  background-image: url(/images/budgeting-analytics-banner.png);
  background-repeat: no-repeat;
  background-position: right 40px bottom;
  border-bottom: 1px solid #a9a8bc;
}
.banner-section.corporate-card.budgeting-analytics .overlay .banner-content {
  padding: 320px 0 220px;
}
.banner-section.invoice-management .section-text p {
  width: 65%;
  margin: auto;
}
.banner-section.invoice-management .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: right bottom;
}
.banner-section.invoice-management .overlay .banner-content {
  padding: 395px 0 300px;
}
.banner-section.invoice-management .overlay .cmn-btn:hover {
  color: var(--bs-white);
}
.banner-section.invoice-management .overlay .shape-area .shape-1 {
  left: 0;
  top: 90px;
}
.banner-section.invoice-management .overlay .shape-area .shape-2 {
  left: 0;
  bottom: 0;
}
.banner-section.invoice-management .overlay .shape-area .shape-3 {
  right: 0;
  bottom: 130px;
}
.banner-section.invoice-management.security .overlay {
  background-size: cover;
  background-position: center;
}
.banner-section.invoice-management.security .overlay .shape-area .shape-1 {
  left: 0;
  top: 35%;
}
.banner-section.invoice-management.security .overlay .shape-area .shape-2 {
  left: initial;
  right: 0;
  top: 140px;
}
.banner-section.invoice-management.security .overlay .shape-area .shape-3 {
  right: 0;
  bottom: 30px;
}
.banner-section.invoice-management.rewards .overlay {
  background-position: center;
  background-size: cover;
}
.banner-section.invoice-management.rewards .overlay .shape-area .obj-1 {
  left: 0;
  bottom: 10px;
}
.banner-section.invoice-management.rewards .overlay .shape-area .obj-2 {
  right: 0;
  bottom: 15px;
}
.banner-section.invoice-management.rewards .overlay .banner-content {
  padding: 307px 0 210px;
}
.banner-section.inner-banner .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: center;
}
.banner-section.inner-banner .shape-area .shape-1 {
  right: 100px;
  bottom: 0;
}
.banner-section.inner-banner .banner-content {
  padding: 241px 0 123px;
}
.banner-section.inner-banner .banner-content .main-content h1 {
  color: var(--bs-white);
}
.banner-section.inner-banner .banner-content .main-content .breadcrumb-area {
  margin-top: 10px;
}
.banner-section.inner-banner .banner-content .main-content .breadcrumb-area .breadcrumb li {
  display: flex;
  align-items: center;
  color: var(--bs-white);
  /*margin-right: 20px;*/
}
.banner-section.inner-banner .banner-content .main-content .breadcrumb-area .breadcrumb li a {
  color: var(--bs-white);
}
/*.banner-section.inner-banner .banner-content .main-content .breadcrumb-area .breadcrumb .breadcrumb-item + .breadcrumb-item::before {*/
/*  background-image: url(/images/icon/arrow-right-3.png);*/
/*  background-repeat: no-repeat;*/
/*  width: 24px;*/
/*  height: 14px;*/
/*  padding: 0;*/
/*  content: "";*/
/*  position: absolute;*/
/*  left: -32px;*/
/*}*/

/*.banner-section.inner-banner .banner-content .main-content .breadcrumb-area .breadcrumb .breadcrumb-item + .breadcrumb-item::before {*/
  /*content: "\f30b";*/
/*  font-family: 'Line Awesome Brands';*/
  /*font-weight: 900; */
/*  font-size: 14px;*/

  /*position: absolute;*/
  /*left: -22px;*/

/*  background: none !important;*/
/*  width: auto;*/
/*  height: auto;*/
/*  padding: 0;*/
/*}*/
.banner-section.inner-banner.career-details .shape-area .shape-1 {
  bottom: initial;
  top: 150px;
}
.banner-section.inner-banner.career-details .banner-content {
  padding: 241px 0 178px;
}
.banner-section.inner-banner.career-details .banner-bottom {
  margin-top: -100px;
  transform: translateZ(5px);
}
.banner-section.inner-banner.career-details .banner-bottom .top-box {
  border-radius: 10px;
  background-color: var(--bs-white);
  padding: 60px 60px 54px;
  box-shadow: 4px 6.928px 24px 0px rgba(106, 105, 194, 0.25);
}
.banner-section.inner-banner.career-details .banner-bottom .top-box .left-box {
  margin-right: 20px;
}
.banner-section.inner-banner.career-details .section-text h5 {
  color: var(--para-color);
}
.banner-section.inner-banner.career-details ul {
  display: flex;
  align-items: center;
}
.banner-section.inner-banner.career-details ul li {
  list-style: disc;
  margin-left: 17px;
  list-style-position: inside;
}
.banner-section.inner-banner.career-details ul li:first-child {
  margin: 0;
  list-style: none;
}
.banner-section.about-us .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: right bottom;
}
.banner-section.about-us .overlay .banner-content {
  padding: 208px 0 365px;
}
.banner-section.about-us .banner-img-bottom {
  margin-top: -345px;
}
.banner-section.about-us .magnific-area {
  border-radius: 30px;
  position: relative;
  z-index: 1;
}
.banner-section.about-us .magnific-area .mfp-iframe {
  position: absolute;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  z-index: 5;
  width: 120px;
  height: 120px;
  background: var(--bs-white);
}
.banner-section.about-us .magnific-area .mfp-iframe::before {
  position: absolute;
  content: "";
  border-radius: 50%;
  z-index: -2;
  animation: stretch 5s linear infinite;
  border: 1px solid var(--bs-white);
  background-color: rgba(255, 255, 255, 0.102);
  width: 164px;
  height: 164px;
}
.banner-section.about-us .magnific-area .mfp-iframe .popupvideo {
  position: absolute;
}
.banner-section.about-us .stars-info .single-box {
  text-align: center;
}
.banner-section.about-us .stars-info .single-box .icon-box {
  border-radius: 50%;
  background-color: var(--primary-color);
  width: 120px;
  height: 120px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-bottom: 20px;
}
.banner-section.help-center .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: right bottom;
}
.banner-section.help-center .overlay .banner-content {
  padding: 169px 0 60px;
}
.banner-section.help-center .overlay form .form-group {
  border-radius: 10px;
  border: 1px solid #86aaee;
  background-color: #38578f;
  padding-left: 20px;
}
.banner-section.help-center .overlay form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 15px;
  color: var(--bs-white);
}
.banner-section.help-center .overlay form .form-group input::-moz-placeholder {
  color: rgba(255, 255, 255, 0.502);
  opacity: 1;
}
.banner-section.help-center .overlay form .form-group input::placeholder {
  color: rgba(255, 255, 255, 0.502);
  opacity: 1;
}
.banner-section.help-center .overlay form .form-group input:-ms-input-placeholder {
  color: rgba(255, 255, 255, 0.502);
}
.banner-section.help-center .overlay form .form-group input::-ms-input-placeholder {
  color: rgba(255, 255, 255, 0.502);
}
.banner-section.blog-details .overlay {
  /*background-image: url(/images/blog-banner.png);*/
  background-repeat: no-repeat;
  background-size: cover;
  background-position: top 1px center;
}
.banner-section.blog-details .overlay .banner-content {
  padding-top: 495px;
}
.banner-section.privacy-content .overlay {
  background-image: url(/assets/images/frontend/blog/bannerbg.png);
  background-repeat: no-repeat;
  background-position: right bottom;
}

.footer-section {
  position: relative;
  width: calc(100% - 280px);
  margin-left: 280px;
  z-index: 99;
}
.footer-section::before {
  content: "";
  position: absolute;
  /*background-color: #0a2843;*/
  background-color: #111827f2;
  width: 100%;
  height: 60%;
  z-index: -1;
  /*left: 0;*/
  bottom: 0;
}
.footer-section .newsletter {
    max-width: 100%;
  border-radius: 20px;
  padding: 80px 0;
  /*background-image: url(/assets/images/footer-bg-left.png), url(/assets/images/footer-bg-right.png);*/
  background-image: url(/assets/images/footer-bg-left.png);
  background-repeat: no-repeat;
  background-position: left 20px center, right bottom;
  background-color: var(--primary-color);
}
.footer-section .newsletter form {
  width: 60%;
  margin: 0 auto;
}
.footer-section .newsletter form .form-group {
  background-color: var(--bs-white);
  border: 1px solid #e2e2ea;
  border-radius: 35px;
  padding: 10px;
}
.footer-section .newsletter form .form-group input {
  border-radius: 35px;
  padding: 0 20px;
  border-color: transparent;
}
.footer-section .newsletter form .form-group button {
  min-width: 50px;
  min-height: 50px;
  border-radius: 50%;
  background-color: var(--primary-color);
}
.footer-section .footer-area .menu-item li {
  margin-right: 18px;
}
.footer-section .footer-area .menu-item li a {
  color: var(--bs-white);
  font-weight: 600;
}
.footer-section .footer-area .social-link a {
  margin-left: 15px;
}
.footer-section .footer-area .copyright span,
.footer-section .footer-area .copyright p,
.footer-section .footer-area .copyright a {
  color: var(--bs-white);
}
.footer-section .footer-area .footer-bottom {
  border-top: 1px solid var(--border-color);
}
.footer-section .footer-area .footer-bottom .menu-item li {
  margin-right: 0;
  margin-left: 18px;
}
.footer-section .footer-area .footer-bottom {
  padding: 30px 0;
  margin-top: 30px;
}

.counter-section {
  background: none;
  position: relative;
  padding: 70px 30px 65px;
  margin-top: -110px;
  transform: translateZ(10px);
  margin-bottom: 20px;
}
.counter-section::before {
  position: absolute;
  content: "";
  width: 70%;
  border-radius: 20px;
  background-color: rgb(255, 255, 255);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
  height: 100%;
  top: 0;
  left: 15%;
  z-index: -1;
}
.counter-section .single-area h2 {
  color: rgb(43 107 127 / var(--tw-bg-opacity, 1));
}
.counter-section .single-area h2 span {
  font-size: inherit;
  font-weight: inherit;
  color: inherit;
}

.global-payment {
  margin-top: -20px;
}
.global-payment .cus-mar {
  margin-bottom: -20px;
}
.global-payment .single-item {
  background-color: var(--bs-white);
  border: 1px solid #bec8e5;
  text-align: center;
  margin-bottom: 20px;
  border-radius: 20px;
  padding: 40px 20px 33px;
  transition: 0.3s;
}
.global-payment .single-item:hover {
  box-shadow: 0px 12px 24px rgba(106, 105, 194, 0.25);
  border-color: transparent;
}
.global-payment .single-item h5 {
  margin: 21px 0 24px;
}
.global-payment.features {
  margin-top: 0;
}

.our-solutions {
  background-image: url(/assets/images/our-solutions-bg.png);
  background-repeat: no-repeat;
  background-position: top;
  background-size: auto;
}
.our-solutions .cus-mar {
  margin-bottom: -20px;
}
.our-solutions .single-item {
  border-radius: 20px;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
  text-align: center;
  padding: 40px 15px 33px;
  margin-bottom: 20px;
}
.our-solutions .single-item h5 {
  margin: 21px 0 24px;
}
.our-solutions.business-model {
  background-image: url(/images/business-model-bg.png);
  background-repeat: no-repeat;
  background-position: top center;
}
.our-solutions.payment {
  background-image: url(/images/our-solutions-payment-bg.png);
}

.how-it-works .cus-mar {
  margin-bottom: -30px;
}
.how-it-works .single-item {
  position: relative;
  margin-bottom: 25px;
}
.how-it-works .single-item::after {
  content: "";
  position: absolute;
  background-repeat: no-repeat;
  width: 104px;
  height: 15px;
  right: calc(-17% - 10px);
  top: calc(35% - 20px);
}
.how-it-works .single-item.first::after {
  background-image: url(/assets/images/how-works-arrow-1.png);
}
.how-it-works .single-item.second::after {
  background-image: url(/assets/images/how-works-arrow-2.png);
  top: calc(30% - 20px);
}
.how-it-works .single-item h5 {
  margin: 21px 0 24px;
}
.how-it-works.second .single-item::after {
  width: 123px;
  height: 35px;
  right: calc(-12% - 10px);
  top: calc(30% - 20px);
}
.how-it-works.second .single-item.first::after {
  background-image: url(/images/icon/how-works-arrow-4.png);
}
.how-it-works.second .single-item.second::after {
  background-image: url(/images/icon/how-works-arrow-3.png);
}
.how-it-works.second .single-item h3 {
  background-color: var(--primary-color);
  border-radius: 5px;
  min-width: 90px;
  min-height: 90px;
  margin: auto;
  display: inline-grid;
  align-items: center;
  color: var(--bs-white);
}

.app-download .features li {
  display: flex;
  align-items: center;
  margin-top: 20px;
}
.app-download .features li img {
  margin-right: 10px;
}
.app-download .brand-area {
  display: flex;
  align-items: center;
}
.app-download .brand-area a {
  margin-right: 25px;
  transition: 0.3s;
}
.app-download .brand-area a:hover {
  box-shadow: 0px 12px 24px rgba(106, 105, 194, 0.25);
}

body.dark-mode .testimonials .title,
body.dark-mode .testimonials .sub-title,
body.dark-mode .faqs-section .title,
body.dark-mode .faqs-section .sub-title{
  color: white;
}

.testimonials {
  background-color: var(--section-color);
}
.testimonials .testimonials-carousel {
  padding-bottom: 70px;
}
.testimonials .testimonials-carousel .slick-arrow {
  position: absolute;
  outline: none;
  bottom: 0;
  width: 70px;
  height: 40px;
  background: var(--bs-white);
  border-radius: 10px;
  z-index: 1;
  display: flex;
  align-items: center;
  justify-content: center;
}
.testimonials .testimonials-carousel .slick-arrow:hover {
  box-shadow: 0px 12px 24px rgba(106, 105, 194, 0.25);
  transition: all 0.5s;
}
.testimonials .testimonials-carousel .slick-arrow.slick-prev {
  left: calc(50% - 85px);
  z-index: 2;
}
.testimonials .testimonials-carousel .slick-arrow.slick-prev::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 20px;
  background-image: url(/assets/images/left-arrow.png);
  background-repeat: no-repeat;
  z-index: -1;
}
.testimonials .testimonials-carousel .slick-arrow.slick-next {
  right: calc(50% - 85px);
  z-index: 2;
}
.testimonials .testimonials-carousel .slick-arrow.slick-next::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 20px;
  background-image: url(/assets/images/right-arrow.png);
  background-repeat: no-repeat;
  z-index: -1;
}
.testimonials .slick-initialized .slick-slide {
  opacity: 0.3;
  transition: 0.3s;
}
.testimonials .slick-initialized .slick-slide.slick-center {
  opacity: 1;
  transition: 0.3s;
}
.testimonials .single-slide .single-content {
  padding: 33px 40px 40px;
  margin: 0 15px 30px;
  border-radius: 20px;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
}
.testimonials .single-slide .single-content i {
  color: #e4ab19;
}
.testimonials .single-slide .single-content .title-area {
  padding: 23px 0 30px;
}
.testimonials .single-slide .single-content .profile-area {
  margin-top: 25px;
}
.testimonials .single-slide .single-content .profile-area img {
  margin-right: 25px;
}
.testimonials .single-slide .single-content .profile-area h5 {
  margin-top: 0;
  margin-bottom: 5px;
}
.testimonials .single-slide .single-content .profile-area p {
  color: var(--primary-color);
}

.faqs-section .cus-mar {
  margin-bottom: -20px;
}
.faqs-section .accordion .accordion-item {
  margin-bottom: 10px;
  background: var(--bs-white);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
  border-radius: 10px;
  border: none;
  margin-bottom: 20px;
}
.faqs-section .accordion .accordion-item .accordion-button {
  padding: 17px 30px;
  border-radius: 10px;
  background-color: transparent;
  font-size: inherit;
  font-weight: inherit;
  color: inherit;
  border: none;
}
.faqs-section .accordion .accordion-item .accordion-button::after {
  flex-shrink: 0;
  width: 20px;
  height: 5px;
  content: "";
  background-image: url(/assets/images/minus-icon.png);
  background-repeat: no-repeat;
  background-size: 20px;
  position: absolute;
  right: 30px;
  transition: all ease 0.3s;
}
.faqs-section .accordion .accordion-item .accordion-button::before {
  content: "";
  position: absolute;
  right: 25px;
  width: 30px;
  height: 30px;
  background: #f7f6ff;
  border-radius: 50%;
}
.faqs-section .accordion .accordion-item .accordion-button.collapsed::after {
  width: 20px;
  height: 20px;
  content: "";
  background-image: url(/assets/images/plus-icon.png);
  background-repeat: no-repeat;
  background-size: 20px;
  transform: rotate(-90deg);
  transition: all ease 0.3s;
}
.faqs-section .accordion .accordion-item .accordion-collapse {
  border-top: 1px solid #b0baf1;
}
.faqs-section .accordion .accordion-item .accordion-collapse .accordion-body {
  padding: 20px 30px;
}
.faqs-section.help-center {
  background-color: #f6f5ff;
}

body.dark-mode .faqs-section.help-center {
  background-color: rgb(43 107 127 / var(--tw-bg-opacity, 1));
}

body.dark-mode .faqs-section .accordion .accordion-item .accordion-button {
    color: rgba(0, 40, 78, 0.7);
}

.faqs-section.help-category {
  margin-bottom: 0;
}
.faqs-section.help-category .accordion {
  margin-bottom: -20px;
}
.faqs-section.help-category .accordion .accordion-item .accordion-header {
  position: relative;
  display: flex;
  align-items: center;
}
.faqs-section.help-category .accordion .accordion-item .accordion-header::after {
  position: absolute;
  left: 30px;
  z-index: 3;
  width: 30px;
  height: 30px;
  margin-left: auto;
  content: "";
  background-image: url(/images/icon/faq-icon.png);
  background-repeat: no-repeat;
}
.faqs-section.help-category .accordion .accordion-item .accordion-header .accordion-button {
  padding-left: 75px;
}
.faqs-section.help-category .accordion .accordion-item ul {
  margin-bottom: -10px;
}
.faqs-section.help-category .accordion .accordion-item ul li {
  list-style: decimal;
  list-style-position: inside;
  margin-bottom: 10px;
}

.more-features .overlay {
  background-color: #343098;
  background-image: url(/images/more-features-illu-1.png), url(/images/more-features-illu-2.png);
  background-repeat: no-repeat;
  background-position: left center, right bottom 50px;
}
.more-features .overlay .cus-mar {
  margin-bottom: -40px;
}
.more-features .overlay .single-item {
  text-align: center;
  margin-bottom: 40px;
}
.more-features .overlay .single-item h5 {
  margin: 21px 0 24px;
}
.more-features .overlay .single-item h5,
.more-features .overlay .single-item p {
  color: var(--bs-white);
}

.accept-payments .overlay {
  background-image: url(/images/accept-payments-bg.png);
  background-repeat: no-repeat;
  background-position: right center;
}
.accept-payments .main-content {
  margin-bottom: -30px;
}
.accept-payments .main-content .single-item {
  margin-bottom: 30px;
  padding: 30px;
  border-radius: 10px;
  border: 1px solid #e4eafa;
}
.accept-payments .main-content .single-item h5 {
  margin-bottom: 10px;
}

.earn-cashback .ex-mar {
  margin-bottom: -20px;
}
.earn-cashback .exb-mar {
  margin-bottom: -60px;
}

.features-built .cus-mar {
  margin-bottom: -40px;
}
.features-built .single-area {
  display: flex;
  margin-bottom: 40px;
}
.features-built .single-area .icon-area {
  margin-right: 20px;
}
.features-built .single-area h5 {
  margin-bottom: 15px;
}

.call-action .btn-area .cmn-btn {
  margin: 0 10px;
}
.call-action.earn-when-spend {
  margin-bottom: -30px;
  background-image: url(/images/earn-spend-1.png), url(/images/earn-spend-3.png);
  background-repeat: no-repeat;
  background-position: left top, right top;
}
.call-action.earn-when-spend ul {
  display: flex;
  align-items: center;
}
.call-action.earn-when-spend ul li {
  margin: 0 15px;
}
.call-action.earn-when-spend ul li img {
  box-shadow: 1.5px 2.598px 7px 0px rgba(138, 140, 205, 0.35);
  border-radius: 50%;
  margin-bottom: 30px;
}
.call-action.integration {
  background-color: var(--section-color);
}
.call-action.integration ul {
  display: flex;
  align-items: center;
}
.call-action.integration ul li {
  margin: 0 15px;
}
.call-action.integration ul li img {
  box-shadow: 1.5px 2.598px 7px 0px rgba(138, 140, 205, 0.35);
  border-radius: 50%;
  margin-bottom: 15px;
}
.call-action.integration .section-text p {
  width: 70%;
  margin: auto;
}
.call-action.security .main-content {
  background-color: var(--primary-color);
  border-radius: 10px;
  background-image: url(/images/security-call-action.png);
  background-repeat: no-repeat;
  background-position: right bottom;
  padding: 90px 45px;
}
.call-action.security .main-content .cmn-btn {
  background: var(--bs-white);
}
.call-action.security .main-content .cmn-btn:hover {
  color: inherit;
}

.business-account .sec-image {
  margin: -12px 0;
}

.stay-control ul {
  -moz-column-count: 2;
       column-count: 2;
}
.stay-control ul li {
  display: flex;
  align-items: center;
  margin-bottom: 30px;
}
.stay-control ul li p {
  font-weight: 600;
}
.stay-control ul li:last-child {
  margin-bottom: 0;
}
.stay-control ul li img {
  margin-right: 15px;
}

.secure-integrated ul li {
  display: flex;
  align-items: flex-start;
  margin-bottom: 15px;
  font-weight: 600;
}
.secure-integrated ul li:last-child {
  margin-bottom: 0;
}
.secure-integrated ul li img {
  margin-right: 10px;
  margin-top: 4px;
}

.partner-perks {
  background-color: rgb(245, 246, 252);
}
.partner-perks .cus-mar {
  margin-bottom: -20px;
}
.partner-perks .nav-tabs {
  border: none;
  margin-bottom: 10px;
}
.partner-perks .nav-tabs li {
  margin: 0 10px;
  margin-bottom: 10px;
}
.partner-perks .nav-tabs li .cmn-btn {
  border-radius: 5px;
  text-transform: capitalize;
}
.partner-perks .nav-tabs li .active {
  background-color: var(--bs-white);
}
.partner-perks .nav-tabs li .active:hover {
  color: var(--para-color);
}
.partner-perks .single-box {
  padding: 30px;
  border-radius: 20px;
  background-color: var(--bs-white);
  margin-bottom: 20px;
}
.partner-perks .single-box .head-area {
  margin-bottom: 31px;
}
.partner-perks .single-box .head-area .logo-area {
  border-radius: 5px;
  background-color: rgb(243, 242, 255);
  box-shadow: 2px 3.464px 24px 0px rgba(32, 59, 128, 0.25);
  display: flex;
  align-items: center;
  justify-content: center;
  min-width: 70px;
  min-height: 70px;
  margin-right: 30px;
}
.partner-perks .single-box .head-area h5 {
  margin-top: 0;
  font-weight: 700;
}
.partner-perks .single-box .head-area p {
  color: var(--primary-color);
  margin-top: 5px;
  font-weight: 600;
}
.partner-perks .single-box .btn-area {
  margin-top: 31px;
}
.partner-perks .single-box .btn-area .cmn-btn {
  width: 100%;
  border-radius: 30px;
}

.pricing-plan .cus-mar {
  margin-bottom: -20px;
}
.pricing-plan .section-header p {
  width: 70%;
  margin: auto;
}
.pricing-plan .nav-tabs-area {
  display: flex;
  justify-content: center;
}
.pricing-plan .nav-tabs-area .nav-tabs {
  justify-content: center;
  display: inline-flex;
  border: 1px solid #e7e7ff;
  border-radius: 30px;
  padding: 10px 5px;
}
.pricing-plan .nav-tabs-area .nav-tabs li {
  margin: 0 10px;
}
.pricing-plan .nav-tabs-area .nav-tabs li .cmn-btn {
  border-radius: 30px;
  text-transform: capitalize;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 20px 0px rgba(30, 48, 111, 0.1);
  color: var(--para-color);
}
.pricing-plan .nav-tabs-area .nav-tabs li .cmn-btn.active {
  background-color: var(--primary-color);
  color: var(--bs-white);
}
.pricing-plan .nav-tabs-area .nav-tabs li .cmn-btn:hover {
  border-color: transparent;
}
.pricing-plan .tab-content {
  margin-bottom: -30px;
}
.pricing-plan .pricing-single {
  background: var(--bs-white);
  box-shadow: 0px 12px 24px rgba(106, 105, 194, 0.25);
  border-radius: 20px;
  margin-bottom: 30px;
}
.pricing-plan .pricing-single .pricing-head {
  background-color: #3532ad;
  text-align: center;
  padding: 30px;
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}
.pricing-plan .pricing-single .pricing-head h5 {
  color: var(--secondary-color);
}
.pricing-plan .pricing-single .pricing-head h3 {
  color: var(--bs-white);
  margin: 11px 0 32px;
}
.pricing-plan .pricing-single .pricing-head .cmn-btn {
  background-color: var(--bs-white);
  color: var(--para-color);
  border-radius: 30px;
}
.pricing-plan .pricing-single .pricing-body ul {
  padding: 20px 30px;
}
.pricing-plan .pricing-single .pricing-body ul li {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 5px;
}
.pricing-plan .pricing-single .pricing-body ul li span {
  font-weight: 600;
}

.supported-country ul {
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  gap: 55px;
}
.supported-country ul li img {
  border-radius: 50%;
  background-color: rgb(120, 131, 187);
  box-shadow: 6px 10.392px 24px 0px rgba(106, 105, 194, 0.25);
}

.our-values {
  background-color: #f5f6fc;
}
.our-values .cus-mar {
  margin-bottom: -30px;
}
.our-values .single-box {
  border-radius: 10px;
  background-color: var(--bs-white);
  padding: 30px;
  margin-bottom: 30px;
}
.our-values .single-box img {
  max-width: initial;
}
.our-values .single-box .text-box {
  margin-left: 30px;
}
.our-values .single-box .text-box h4 {
  margin-bottom: 17px;
}
.our-values.perks .single-box {
  border-radius: 20px;
  box-shadow: 4px 6.928px 24px 0px rgba(106, 105, 194, 0.25);
}
.our-values.perks .text-box {
  margin-left: 0;
  margin-top: 30px;
}

.our-team .cus-mar {
  margin-bottom: -30px;
}
.our-team .single-box {
  text-align: center;
  border-radius: 20px;
  background-color: var(--bs-white);
  box-shadow: 4px 6.928px 17px 0px rgba(106, 105, 194, 0.25);
  padding: 30px;
  margin-bottom: 30px;
}
.our-team .single-box h5 {
  margin: 20px 0 16px;
}
.our-team .single-box .designation {
  color: var(--primary-color);
  font-weight: 600;
}
.our-team .single-box .social-link {
  margin-top: 17px;
}
.our-team .single-box .social-link a {
  margin: 0 5px;
}

.location {
  background-image: url(/images/location-bg.png);
  background-repeat: no-repeat;
  background-position: center;
}
.location .section-header p {
  width: 70%;
  margin: auto;
}
.location .cus-mar {
  margin-bottom: -30px;
}
.location .single-box {
  border-radius: 20px;
  background-color: var(--bs-white);
  box-shadow: 4px 6.928px 17px 0px rgba(106, 105, 194, 0.25);
  padding: 40px 30px 33px;
  margin-bottom: 30px;
}
.location .single-box .head-area {
  margin-bottom: 23px;
}
.location .single-box .head-area .img-box {
  margin-right: 30px;
}
.location .single-box .email-phone {
  display: flex;
  align-items: center;
  margin: 10px 0;
}
.location .single-box .email-phone .img-box {
  margin-right: 20px;
}
.location .single-box .email-phone p {
  font-weight: 600;
}
.location .single-box a {
  font-weight: 600;
  color: var(--primary-color);
  margin-top: 20px;
}
.location .single-box a img {
  transition: all 0.3s;
}
.location .single-box a:hover img {
  margin-left: 10px;
}

.current-openings {
  overflow-x: initial;
}
.current-openings .position-sticky {
  top: 120px;
}
.current-openings .section-header p a {
  color: var(--primary-color);
}
.current-openings .nav-tabs {
  border: none;
}
.current-openings .nav-tabs li {
  margin: 0 10px 15px;
}
.current-openings .nav-tabs li .cmn-btn {
  border-radius: 30px;
  text-transform: capitalize;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 20px 0px rgba(30, 48, 111, 0.1);
  color: var(--para-color);
}
.current-openings .nav-tabs li .cmn-btn.active {
  background-color: var(--primary-color);
  color: var(--bs-white);
}
.current-openings .nav-tabs li .cmn-btn:hover {
  border-color: transparent;
}
.current-openings .tab-pane {
  margin-bottom: -20px;
}
.current-openings .single-box {
  border-radius: 10px;
  background-color: var(--bs-white);
  box-shadow: 4px 6.928px 24px 0px rgba(106, 105, 194, 0.25);
  margin-bottom: 20px;
  padding: 30px 25px;
  transition: 0.3s;
}
.current-openings .single-box:hover {
  background-color: var(--primary-color);
}
.current-openings .single-box:hover li,
.current-openings .single-box:hover h5,
.current-openings .single-box:hover .salary-limit p {
  color: var(--bs-white);
}
.current-openings .single-box ul {
  margin: 18px 0 17px;
  display: flex;
  align-items: center;
}
.current-openings .single-box ul li {
  list-style: disc;
  margin-left: 17px;
  list-style-position: inside;
}
.current-openings .single-box ul li:first-child {
  margin: 0;
  list-style: none;
}
.current-openings .single-box .salary-limit p {
  font-weight: 600;
  color: var(--primary-color);
}
.current-openings .single-box .right-box a {
  border-radius: 50%;
  background-color: rgb(245, 246, 252);
  width: 70px;
  height: 70px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.job-details {
  overflow-x: initial;
}
.job-details .position-sticky {
  top: 120px;
}
.job-details .left-area {
  display: table-caption;
}
.job-details .left-area a {
  margin-bottom: 10px;
  font-weight: 600;
  display: inline-flex;
  align-items: center;
  position: relative;
}
.job-details .left-area a::after {
  position: absolute;
  content: "";
  background-image: url(/images/icon/arrow-right-6.png);
  background-repeat: no-repeat;
  width: 18px;
  height: 18px;
  right: 5%;
  opacity: 0;
  transition: 0.3s;
}
.job-details .left-area a:hover {
  color: var(--primary-color);
}
.job-details .left-area a:hover::after {
  right: -30px;
  opacity: 1;
}
.job-details .single-area ul li {
  list-style: disc;
  margin-left: 22px;
}

.help-center-section {
  margin-top: -40px;
  transform: translateZ(5px);
}
.help-center-section .tab-pane {
  margin-bottom: -30px;
}
.help-center-section .nav-tabs-area {
  display: flex;
  justify-content: center;
}
.help-center-section .nav-tabs-area .nav-tabs {
  justify-content: center;
  display: inline-flex;
  border: 1px solid #e7e7ff;
  background-color: var(--bs-white);
  border-radius: 30px;
  padding: 10px 5px;
}
.help-center-section .nav-tabs-area .nav-tabs li {
  margin: 0 10px;
}
.help-center-section .nav-tabs-area .nav-tabs li .cmn-btn {
  border-radius: 30px;
  text-transform: capitalize;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 20px 0px rgba(30, 48, 111, 0.1);
  color: var(--para-color);
}
.help-center-section .nav-tabs-area .nav-tabs li .cmn-btn.active {
  background-color: var(--primary-color);
  color: var(--bs-white);
}
.help-center-section .nav-tabs-area .nav-tabs li .cmn-btn:hover {
  border-color: transparent;
}
.help-center-section .tab-content .single-box {
  border: 1px solid #cadfff;
  border-radius: 30px;
  background-color: var(--bs-white);
  text-align: center;
  padding: 40px 10px 35px;
  margin-bottom: 30px;
  transition: 0.3s;
}
.help-center-section .tab-content .single-box h5 {
  margin-top: 25px;
}
.help-center-section .tab-content .single-box:hover {
  box-shadow: 2px 3.464px 24px 0px rgba(0, 0, 3, 0.3);
  border-color: transparent;
}

.help-category {
  overflow-x: initial;
  margin-top: 20px;
}
.help-category .position-sticky {
  top: 30px;
}
.help-category form .form-group {
  border: 1px solid #f2f1fc;
  border-radius: 10px;
  background-color: #f9fbff;
  margin-bottom: 30px;
  padding-left: 20px;
}
.help-category form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 15px;
}
.help-category .nav-tabs {
  display: block;
  border: none;
}
.help-category .nav-tabs button {
  margin-bottom: 10px;
  font-weight: 600;
  display: inline-flex;
  color: var(--para-color);
  align-items: center;
  padding: 0;
  border: none;
  position: relative;
}
.help-category .nav-tabs button::after {
  position: absolute;
  content: "";
  background-image: url(/images/icon/arrow-right-6.png);
  background-repeat: no-repeat;
  width: 18px;
  height: 18px;
  right: 5%;
  opacity: 0;
  transition: 0.3s;
}
.help-category .nav-tabs button:hover {
  color: var(--primary-color);
}
.help-category .nav-tabs button:hover::after {
  right: -30px;
  opacity: 1;
}
.help-category .nav-tabs button.active {
  color: var(--primary-color);
}
.help-category .nav-tabs button.active::after {
  right: -30px;
  opacity: 1;
}
.help-category .tab-content {
  border: 1px solid #e0defa;
  border-radius: 10px;
  padding: 40px;
  background-color: var(--bs-white);
  box-shadow: 6px 10.392px 24px 0px rgba(106, 105, 194, 0.25);
}

.blog-section .nav-tabs {
  border: none;
}
.blog-section .nav-tabs .nav-item {
  margin-right: 20px;
  margin-bottom: 20px;
}
.blog-section .nav-tabs .cmn-btn {
  border-radius: 10px;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 20px 0px rgba(30, 48, 111, 0.1);
  color: var(--para-color);
}
.blog-section .nav-tabs .cmn-btn.active {
  background-color: var(--primary-color);
  color: var(--bs-white);
}
.blog-section .nav-tabs .cmn-btn:hover {
  border-color: transparent;
}
.blog-section form .form-group {
  border: 1px solid #dfdefe;
  border-radius: 10px;
  background-color: #f5f6fc;
  padding-left: 20px;
}
.blog-section form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
}
.blog-section .tab-pane {
  margin-bottom: -30px;
}
.blog-section .single-post {
  border-radius: 20px;
  background-color: var(--bs-white);
  box-shadow: 2px 3.464px 24px 0px rgba(106, 105, 194, 0.25);
  margin-bottom: 30px;
}
.blog-section .single-post .thumbnail img {
  border-radius: inherit;
  max-width: unset;
}
.blog-section .single-post .blog-text {
  padding: 25px;
}
.blog-section .single-post .blog-text .date {
  margin-bottom: 20px;
}
.blog-section .single-post .blog-text .blog-content {
  margin-top: 25px;
}
.blog-section .single-post .blog-text .bottom-area {
  border-top: 1px solid #ddd;
  padding-top: 30px;
  margin-top: 30px;
}
.blog-section .single-post .blog-text .bottom-area a {
  font-weight: 600;
  color: var(--primary-color);
}
.blog-section .single-post .blog-text .bottom-area a img {
  margin-left: 10px;
}
.blog-section.details .blog-section-content {
  border-top: 1px solid #7883BB;
}
.blog-section.details .cus-mar {
  margin-bottom: -30px;
}

.blog-details-section {
  margin-top: -80px;
  transform: translateZ(5px);
}
.blog-details-section .main-content {
  background-color: var(--bs-white);
  border-radius: 10px;
  padding: 60px 50px 0;
}
.blog-details-section .main-content .single-content {
  margin-bottom: -30px;
  margin-top: 60px;
}
.blog-details-section .main-content .single-content p {
  margin-bottom: 25px;
}
.blog-details-section .main-content .head-area {
  display: flex;
  align-items: center;
  justify-content: space-between;
}
.blog-details-section .main-content .head-area .left-area p {
  margin-left: 20px;
}
.blog-details-section .main-content .social-link a {
  margin-left: 15px;
}
.blog-details-section .authors-area {
  border-radius: 10px;
  background-color: #ffeaea;
  padding: 60px;
}
.blog-details-section .authors-area .profile-img img {
  max-width: unset;
}
.blog-details-section .authors-area .right-item {
  margin-left: 30px;
}
.blog-details-section .authors-area .left-area h6 {
  color: var(--primary-color);
  margin-bottom: 30px;
}

.login-reg {
  margin-top: -60px;
}
.login-reg .single-input {
  margin-bottom: 30px;
}

body.dark-mode .login-reg .single-input input {
  background-color: var(--bs-white);
  padding: 0 20px;
  border-color: transparent;
}

.login-reg .single-input label {
  font-weight: 600;
}
.login-reg a, .login-reg p {
  font-weight: 600;
}
.login-reg .dont-acc a {
  color: var(--primary-color);
}
.login-reg .reg-google {
  margin-top: 30px;
}
.login-reg .reg-google a {
  border: 1px solid #EEECF7;
  border-radius: 10px;
  padding: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
}
.login-reg .reg-google a i {
  margin-right: 10px;
}
.login-reg .or {
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 30px;
}
.login-reg .or::after, .login-reg .or::before {
  position: absolute;
  content: "";
  background: #EEECF7;
  height: 1px;
  width: 38%;
}
.login-reg .or::after {
  left: 0;
}
.login-reg .or::before {
  right: 0;
}

.error {
  background-image: url(/assets/errors/images/error.png);
  background-repeat: no-repeat;
  background-position: center;
  padding: 400px 0 100px;
}

.privacy-content .top-wrapper {
  margin-top: -7px;
  margin-bottom: -7px;
}
.privacy-content .top-wrapper h4 {
  text-transform: uppercase;
  margin-bottom: 30px;
}
.privacy-content .top-wrapper p {
  margin-bottom: 30px;
}
.privacy-content .top-wrapper ul {
  margin-bottom: 20px;
}
.privacy-content .top-wrapper ul li {
  margin-bottom: 10px;
}
.privacy-content .safe-data {
  margin: 55px 0;
}
.privacy-content .safe-data ul {
  list-style-type: decimal;
  margin-left: 18px;
}
.privacy-content .safe-data ul li {
  padding-left: 15px;
}
.privacy-content .safe-data ul li::marker {
  font-weight: bold;
}
.privacy-content .cookies {
  margin-bottom: -36px;
}
.privacy-content.terms .safe-data {
  margin-bottom: -23px;
}

#draggableDiv {
  top: 50%;
  bottom: 0;
  z-index: 99999;
  cursor: move;
}
#draggableDiv .draggable {
  background-color: #5ac4ff;
}
#draggableDiv .draggable i {
  color: #F5FAFF;
}
#draggableDiv button:hover {
  background-color: #F5FAFF;
}

@media (max-width: 1799px) {
  .banner-section.index .overlay .shape-area img {
    width: 10%;
  }
  .counter-section::before {
    width: 94%;
    left: 3%;
  }
  .banner-section.corporate-card .overlay {
    background-size: 35%;
    background-position: left bottom, right 80px bottom;
  }
  .banner-section.corporate-card.budgeting-analytics .overlay {
    background-size: 45%;
  }
  .banner-section.corporate-card.subscriptions .overlay .banner-content,
  .banner-section.corporate-card .overlay .banner-content,
  .banner-section.payment.two .overlay .banner-content,
  .banner-section.payment .overlay .banner-content,
  .banner-section.corporate-card.budgeting-analytics .overlay .banner-content {
    padding: 200px 0 120px;
  }
  .banner-section.payment.two .overlay,
  .banner-section.payment .overlay {
    background-size: 45%;
  }
}
@media (max-width: 1499px) {
  .banner-section .overlay .shape-area .obj-1, .banner-section .overlay .shape-area .obj-2, .banner-section .overlay .shape-area .obj-4 {
    display: none;
  }
  .call-action.earn-when-spend {
    background-size: 20%;
  }
  .banner-section.payment.two .overlay,
  .banner-section.payment .overlay {
    background-size: 45%;
    background-position: right;
  }
  .banner-section.invoice-management .overlay .shape-area img {
    width: 20%;
  }
}
@media (max-width: 1399px) {
  .banner-section .overlay .banner-content .container .content-shape .obj-1 {
    left: 45%;
  }
  .blog-section .single-post .thumbnail img {
    max-width: 100%;
    height: 100%;
  }
  .blog-section .col-lg-12 .single-post .thumbnail,
  .blog-section .col-lg-12 .single-post .blog-text {
    width: 50%;
  }
  .banner-section.blog-details .overlay .banner-content {
    padding-top: 210px;
  }
  .banner-section.business-account.integrations .overlay form {
    width: 70%;
  }
  .banner-section.invoice-management.rewards .overlay .banner-content,
  .banner-section.invoice-management .overlay .banner-content {
    padding: 200px 0 120px;
  }
  .banner-section.invoice-management .overlay .shape-area img {
    width: 14%;
  }
  .more-features .overlay {
    background-image: none;
  }
}
@media (max-width: 1199px) {
  h1, h1 > a {
    font-size: 57px;
    line-height: 74.1px;
    margin-top: -16px;
  }
  h2, h2 > a {
    font-size: 43px;
    line-height: 55.9px;
    margin-top: -10px;
  }
  .preloader {
    background-size: 30%;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link,
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-item {
    font-size: 16px;
  }
  .banner-section .overlay .banner-content {
    padding: 220px 0 230px;
  }
  .banner-section.inner-banner .overlay .banner-content {
    padding: 215px 0 100px;
  }
  .how-it-works .single-item.second::after,
  .banner-section .overlay .banner-content .container .content-shape img {
    display: none;
  }
  .app-download .image-area,
  .global-payment .image-area {
    margin-top: 60px;
    text-align: center;
  }
  .app-download .image-area img,
  .global-payment .image-area img {
    width: 80%;
  }
  .how-it-works .single-item::after {
    right: calc(-10% - 10px);
    top: calc(60% - 20px);
  }
  .how-it-works .cus-mar {
    margin-bottom: -30px;
  }
  .how-it-works .single-item {
    margin-bottom: 30px;
  }
  .testimonials .slick-initialized .slick-slide {
    opacity: 1;
  }
  .footer-section .newsletter {
    background-image: none;
  }
  .banner-section.inner-banner .shape-area .shape-1 {
    width: 35%;
  }
  .blog-details-section .authors-area {
    display: grid !important;
    padding: 40px;
  }
  .blog-details-section .authors-area .right-item {
    margin: 0;
    margin-top: 30px;
  }
  .banner-section.business-account .banner-img-bottom {
    margin-top: -190px;
  }
  .banner-section.inner-banner.career-details .overlay .banner-content {
    padding: 215px 0 150px;
  }
  .error {
    background-size: contain;
  }
  .faqs-section .accordion .accordion-item .accordion-button {
    padding-right: 70px;
  }
  .banner-section.business-account.integrations .overlay form {
    width: 80%;
  }
  .login-reg .sec-img {
    width: 70%;
    margin: auto;
    margin-top: 30px;
  }
  .login-reg .sec-img img {
    max-width: 100%;
  }
  .features-built .image-area {
    width: 70%;
    margin: auto;
    margin-top: 30px;
  }
  .features-built .image-area img {
    max-width: 100%;
  }
  .login-reg {
    margin-top: 50px;
  }
  .call-action.security .main-content {
    background-size: 35%;
  }
}
@media (max-width: 991px) {
  h1, h1 > a {
    font-size: 57px;
    line-height: 68.4px;
    margin-top: -16px;
  }
  h2, h2 > a {
    font-size: 43px;
    line-height: 51.6px;
    margin-top: -10px;
  }
  h3, h3 > a {
    font-size: 32px;
    line-height: 38.4px;
    margin-top: -8px;
  }
  h4, h4 > a {
    font-size: 24px;
    line-height: 28px;
    margin-top: -6px;
  }
  h5, h5 > a {
    font-size: 18px;
    line-height: 22px;
    margin-top: -4px;
  }
  h6, h6 > a, table thead tr th, a, p, span, li {
    font-size: 16px;
    line-height: 22px;
  }
  .section-header {
    margin-bottom: 40px;
  }
  .title {
    margin-bottom: 20px;
  }
  .xxlr {
    font-size: 20px;
    line-height: 28px;
  }
  .xlr {
    font-size: 18px;
    line-height: 25.5px;
  }
  .header-section .navbar-toggler {
    display: inline-block;
  }
  .header-section .navbar .navbar-brand {
    margin-top: -5px;
    width: 35%;
  }
  .header-section .navbar .navbar-brand img {
    max-width: initial;
  }
  .header-section .navbar .navbar-collapse .navbar-nav {
    height: 200px;
    margin: 20px 0;
    overflow-y: auto;
    margin-bottom: 10px;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu .dropend .dropdown-menu {
    left: 60px;
  }
  .header-section .nav-item.main-navbar .main-menu .sub-navbar .sub-menu {
    right: 0;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu.show {
    display: inline-block;
    margin-left: 130px;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu {
    display: none;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item {
    padding: 8px 0;
  }
  .header-section .nav-item.dropdown .dropdown-menu {
    position: initial;
  }
  .header-section .navbar .navbar-collapse .right-area .lang {
    display: none !important;
  }
  .header-section .navbar .navbar-collapse .right-area {
    margin-left: 0;
  }
  .banner-section .overlay .banner-content .send-money .currency-area {
    padding: 15px 20px;
  }
  .banner-section .overlay .banner-content .send-money {
    padding: 15px;
  }
  .testimonials .testimonials-carousel {
    padding-bottom: 40px;
  }
  .how-it-works .single-item.first::after {
    display: none;
  }
  .banner-section.about-us .overlay {
    background-position: right top;
  }
  .preloader {
    background-size: 40%;
  }
  .banner-section.blog-details .overlay {
    background-position: top 60px center;
  }
  .call-action.earn-when-spend {
    background-size: 15%;
  }
  .banner-section.business-account .overlay .banner-content {
    padding: 200px 0 365px;
  }
  .banner-section.business-account .banner-img-bottom {
    margin-top: -140px;
  }
  .banner-section.inner-banner.career-details .overlay .banner-content {
    padding: 170px 0 140px;
  }
  .supported-country ul {
    justify-content: center;
    gap: 15px;
  }
  .supported-country ul img {
    max-width: 80%;
  }
  .help-category {
    margin-top: 70px;
  }
  .banner-section.business-account.integrations .overlay {
    background-position: right top;
  }
  .banner-section.business-account.integrations .overlay form {
    width: 100%;
  }
  .login-reg {
    margin-top: 80px;
  }
  .accept-payments .left-side {
    margin-top: 30px;
  }
}
@media (max-width: 767px) {
  .banner-section.about-us .overlay .banner-content,
  .banner-section .overlay .banner-content {
    padding: 200px 0 190px;
  }
  .banner-section.corporate-card .overlay .banner-content,
  .banner-section.payment.two .overlay .banner-content,
  .banner-section.corporate-card.subscriptions .overlay .banner-content,
  .banner-section.payment .overlay .banner-content,
  .banner-section.corporate-card.budgeting-analytics .overlay .banner-content {
    padding: 170px 0 70px;
  }
  .banner-section.corporate-card .overlay,
  .banner-section.corporate-card.subscriptions .overlay,
  .banner-section.corporate-card.expense .overlay,
  .banner-section.corporate-card.budgeting-analytics .overlay {
    background-image: unset;
  }
  .counter-section .single-area {
    margin-bottom: 30px;
  }
  .counter-section {
    padding: 50px 30px 10px;
  }
  .banner-section .overlay .banner-content .send-money {
    margin-top: 40px;
  }
  .banner-section.about-us .banner-img-bottom {
    margin-top: -180px;
  }
  .banner-section.about-us .magnific-area .mfp-iframe {
    width: 90px;
    height: 90px;
  }
  .banner-section.about-us .magnific-area .mfp-iframe::before {
    width: 124px;
    height: 124px;
  }
  .banner-section.about-us .stars-info .single-box .icon-box {
    width: 100px;
    height: 100px;
  }
  .blog-details-section .authors-area .left-area {
    text-align: center;
  }
  .our-values .single-box {
    padding: 30px;
    margin-bottom: 30px;
  }
  .blog-section .single-post {
    display: grid !important;
  }
  .blog-section .single-post .thumbnail img {
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
  }
  .blog-section .single-post .thumbnail img,
  .blog-section .col-lg-12 .single-post .thumbnail,
  .blog-section .col-lg-12 .single-post .blog-text {
    width: 100%;
  }
  .blog-section .top-area {
    display: grid !important;
  }
  .banner-section.inner-banner .shape-area img {
    display: none;
  }
  .partner-perks .nav-tabs li .cmn-btn,
  .help-center-section .nav-tabs-area .nav-tabs li .cmn-btn,
  .pricing-plan .nav-tabs-area .nav-tabs li .cmn-btn,
  .current-openings .nav-tabs li .cmn-btn,
  .blog-section .nav-tabs .cmn-btn {
    padding: 10px 15px;
  }
  .blog-details-section .authors-area .right-item .top-area {
    display: grid !important;
  }
  .blog-details-section .main-content .head-area {
    display: grid !important;
    margin-bottom: -35px;
  }
  .blog-details-section .main-content .head-area .right-area {
    margin-top: 20px;
  }
  .blog-details-section .main-content .head-area a {
    margin-left: 0;
    margin-right: 15px;
  }
  .blog-details-section .main-content .social-link {
    margin-bottom: 20px;
  }
  .blog-details-section .main-content .social-link a {
    margin-left: 0;
    margin-right: 15px;
  }
  .accept-payments .image-area,
  .earn-cashback.features .image-area,
  .features-built .image-area,
  .secure-integrated .sec-image,
  .stay-control .sec-image,
  .earn-cashback .sec-image,
  .multi-currency .sec-image,
  .business-account .sec-image,
  .global-payment.features .sec-image,
  .earn-cashback.features .sec-image {
    width: 70%;
    margin: auto;
    margin-top: 30px;
  }
  .accept-payments .image-area img,
  .earn-cashback.features .image-area img,
  .features-built .image-area img,
  .secure-integrated .sec-image img,
  .stay-control .sec-image img,
  .earn-cashback .sec-image img,
  .multi-currency .sec-image img,
  .business-account .sec-image img,
  .global-payment.features .sec-image img,
  .earn-cashback.features .sec-image img {
    max-width: 100%;
  }
  .partner-perks .cus-mar {
    justify-content: center;
  }
  .call-action.earn-when-spend {
    background-size: 10%;
  }
  .banner-section.business-account .banner-img-bottom {
    margin-top: -40px;
  }
  .banner-section.business-account .overlay .banner-content {
    padding: 170px 0 200px;
  }
  .banner-section.business-account .banner-img-bottom .img-area .right-img {
    width: 70%;
  }
  .banner-section.business-account .overlay {
    background-size: 55%;
  }
  .banner-section.inner-banner.career-details .banner-bottom .top-box {
    padding: 40px 30px 30px;
    display: grid !important;
  }
  .banner-section.inner-banner.career-details .banner-bottom .top-box .right-box {
    margin-top: 20px;
  }
  .error {
    padding: 290px 0 50px;
    background-size: cover;
  }
  .blog-details-section .authors-area {
    padding: 30px;
  }
  .features-built .single-area .icon-area img {
    max-width: unset;
  }
  .help-category .tab-content {
    padding: 30px;
    margin-top: 25px;
  }
  .blog-details-section .authors-area .profile-item {
    justify-content: center;
  }
  .blog-details-section .authors-area .right-item .top-area {
    justify-content: center !important;
  }
  .banner-section.business-account.integrations .overlay {
    background-size: cover;
  }
  .banner-section.business-account.integrations .banner-img-bottom {
    margin-top: -180px;
  }
  .banner-section.business-account.integrations .overlay form .cmn-btn {
    width: 50%;
  }
  .banner-section.business-account.integrations .overlay .banner-content {
    padding: 208px 0 200px;
  }
  .banner-section.invoice-management .overlay .shape-area img {
    display: none;
  }
  .banner-section.payment.two .overlay,
  .banner-section.payment .overlay {
    background-image: none;
  }
}
@media (max-width: 575px) {
  h1, h1 > a {
    font-size: 40px;
    line-height: 46px;
    margin-top: -9px;
  }
  h2, h2 > a {
    font-size: 30px;
    line-height: 36px;
    margin-top: -7px;
  }
  h3, h3 > a {
    font-size: 24px;
    line-height: 28px;
    margin-top: -6px;
  }
  h4, h4 > a {
    font-size: 18px;
    line-height: 22px;
    margin-top: -4px;
  }
  a, p, span, li, .cmn-btn, thead tr th, tbody tr th, tbody tr td, input, label, textarea, h6, h6 > a {
    font-size: 15px;
    line-height: 19px;
  }
  .section-header {
    margin-bottom: 35px;
  }
  .title {
    margin-bottom: 15px;
  }
  .xxlr {
    font-size: 18px;
    line-height: 25.5px;
  }
  .xlr {
    font-size: 16px;
    line-height: 22.4px;
  }
  .header-section .navbar {
    padding: 20px 15px;
  }
  .banner-section.about-us .overlay .banner-content,
  .banner-section .overlay .banner-content {
    padding: 170px 0 180px;
  }
  .banner-section.inner-banner .overlay .banner-content {
    padding: 170px 0 65px;
  }
  .banner-section.blog-details .overlay .banner-content {
    padding: 170px 0 60px;
    padding-top: 210px;
  }
  .footer-section .footer-area .menu-item {
    margin-bottom: 20px;
  }
  .footer-section .footer-area .menu-item li {
    margin: 0 10px !important;
  }
  .footer-section .newsletter {
    padding: 40px 30px;
  }
  .footer-section .newsletter form {
    width: 100%;
  }
  .counter-section {
    padding: 40px 30px 5px;
  }
  .how-it-works .col-6,
  .our-solutions .col-6,
  .global-payment .col-6 {
    width: 70% !important;
    margin: auto;
  }
  .banner-section.about-us .stars-info {
    margin-bottom: -30px;
  }
  .banner-section.about-us .stars-info .single-box {
    margin-bottom: 30px;
  }
  .our-team .cus-mar {
    text-align: center;
  }
  .our-team .single-box {
    display: inline-block;
  }
  .banner-section.blog-details .overlay {
    background-position: top 80px center;
    background-size: 100%;
  }
  .banner-section.business-account .overlay ul {
    display: grid;
    justify-content: center;
    margin-top: 10px;
    text-align: start;
  }
  .banner-section.business-account .overlay ul li {
    margin-top: 15px;
  }
  .job-details .left-area {
    margin-bottom: 30px;
  }
  .our-solutions .single-item img,
  .more-features .overlay .single-item img {
    width: 25%;
  }
  .banner-section.about-us .stars-info .single-box .icon-box {
    width: 80px;
    height: 80px;
  }
  .global-payment .single-item img {
    width: 20%;
  }
  .supported-country ul {
    gap: 10px;
  }
  .supported-country ul img {
    max-width: 60%;
  }
  .how-it-works.second .single-item h3 {
    min-width: 60px;
    min-height: 60px;
  }
  .faqs-section.help-category .accordion .accordion-item .accordion-header .accordion-button {
    padding-left: 30px;
  }
  .faqs-section.help-category .accordion .accordion-item .accordion-header:after {
    display: none;
  }
  .help-category .tab-content {
    padding: 20px;
  }
  .banner-section.business-account.integrations .overlay .banner-content {
    padding: 178px 0 200px;
  }
  .banner-section.invoice-management.rewards .overlay .banner-content,
  .banner-section.invoice-management .overlay .banner-content {
    padding: 170px 0 80px;
  }
  .accept-payments .overlay {
    background-image: none;
  }
  .how-it-works .single-item h5 {
    margin: 12px 0 16px;
  }
  .global-payment .single-item h5,
  .our-solutions .single-item h5,
  .global-payment .single-item h5,
  .more-features .overlay .single-item h5 {
    margin: 16px 0 18px;
  }
  .call-action.security .main-content {
    background-image: none;
    padding: 50px 30px;
  }
}
@media (max-width: 480px) {
  .footer-section .menu-item {
    display: grid;
    justify-content: center;
    text-align: center;
  }
  .faqs-section .accordion .accordion-item .accordion-button {
    padding: 15px 15px;
    padding-right: 70px;
  }
  .faqs-section .accordion .accordion-item .accordion-collapse .accordion-body {
    padding: 15px 15px;
  }
  .faqs-section .accordion .accordion-item .accordion-button::after {
    right: 20px;
  }
  .faqs-section .accordion .accordion-item .accordion-button::before {
    right: 15px;
  }
  .testimonials .single-slide .single-content {
    padding: 24px 15px 20px;
  }
  .call-action.earn-when-spend ul {
    -moz-column-count: 2;
         column-count: 2;
    display: block;
  }
  .call-action.earn-when-spend ul img {
    width: 50%;
  }
  .partner-perks .col-9,
  .our-solutions .col-6,
  .pricing-plan .col-9,
  .global-payment .col-6,
  .global-payment.features .col-6,
  .our-solutions.payment .col-6,
  .our-solutions.business-model .col-6,
  .our-values.perks .col-8 {
    width: 100% !important;
  }
  .banner-section.business-account.integrations .overlay form .cmn-btn {
    width: 60%;
    padding: 10px;
  }
  .blog-section .single-post .blog-text .bottom-area {
    padding-top: 20px;
    margin-top: 20px;
  }
  .preloader {
    background-size: 65%;
  }
  .blog-section.details .section-text {
    display: grid !important;
  }
  .blog-section.details .section-text a {
    margin-top: 20px;
  }
  .help-center-section .tab-content .col-9 {
    width: 100% !important;
    margin: auto;
  }
  .call-action.earn-when-spend .btn-area a {
    margin: 5px 0;
  }
  .call-action .btn-area .cmn-btn {
    margin: 5px;
  }
  .banner-section.inner-banner.career-details ul {
    display: grid;
  }
  .current-openings .single-box ul {
    margin: 18px 0 17px;
    display: grid;
  }
  .banner-section.inner-banner.career-details ul li,
  .banner-section.inner-banner.career-details ul li:first-child,
  .current-openings .single-box ul li,
  .current-openings .single-box ul li:first-child {
    list-style: disc;
    margin-left: 0;
    list-style-position: inside;
  }
  .current-openings .single-box .right-box a {
    width: 50px;
    height: 50px;
  }
  .faqs-section.help-category .accordion .accordion-item .accordion-header .accordion-button {
    padding-left: 15px;
  }
}
@media (max-width: 375px) {
  .about .col-6 {
    width: 100% !important;
  }
  .banner-section .overlay .banner-content .send-money .nice-select .current::before {
    background-image: unset !important;
  }
  .banner-section .overlay .banner-content .send-money .currency-area .right-side .nice-select {
    padding: 30px 50px 30px 15px;
  }
  .banner-section .overlay .banner-content .send-money .calculation .single-area .left-area {
    min-width: 60%;
  }
  .our-values .single-box {
    padding: 20px;
    margin-bottom: 20px;
  }
  .our-values.perks .single-box .text-box {
    margin-left: 0;
  }
  .our-values .single-box .text-box {
    margin-left: 20px;
  }
  .location .single-box {
    padding: 25px 20px 15px;
    margin-bottom: 20px;
  }
  .location .single-box .head-area .img-box {
    margin-right: 20px;
  }
  .blog-section .single-post .blog-text {
    padding: 20px;
  }
  .blog-details-section .main-content {
    padding: 35px 20px 0;
  }
  .blog-details-section .authors-area .profile-img {
    text-align: center;
  }
  .blog-details-section .authors-area .profile-img img {
    max-width: 60%;
  }
  .banner-section.business-account .banner-img-bottom .img-area .right-img {
    bottom: 30px;
  }
  .pricing-plan .pricing-single .pricing-body ul {
    padding: 20px 15px;
  }
  .banner-section.business-account.integrations .banner-img-bottom {
    margin-top: -135px;
  }
  .banner-section.business-account.integrations .overlay .banner-content {
    padding: 178px 0 150px;
  }
  
        /* language */
        .custom--dropdown {
            position: relative;
            display: inline-block;
        }

        .custom--dropdown>.custom--dropdown__selected {
            background-color: transparent;
            cursor: pointer;
            font-size: 14px;
            padding-right: 20px;
        }

        @media screen and (max-width: 1399px) {
            .custom--dropdown>.custom--dropdown__selected {
                padding-right: 15px;
            }
        }

        .custom--dropdown>.dropdown-list {
            position: absolute;
            width: 100%;
            border-radius: 3px;
            opacity: 0;
            overflow: hidden;
            transition: 0.25s ease-in-out;
            -webkit-transform-origin: top center;
            transform-origin: top center;
            top: 100%;
            margin-top: 5px;
            z-index: -1;
            visibility: hidden;
            max-height: 230px;
            overflow-y: auto !important;
            padding-left: 0 !important;
            flex-direction: column;
        }

        .custom--dropdown>.dropdown-list::-webkit-scrollbar {
            width: 4px;
            height: 4px;
        }

        .custom--dropdown.open>.dropdown-list {
            opacity: 1;
            visibility: visible;
            z-index: 999 !important;
            min-width: 120px;
            background-color: #fff;
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .dropdown-list>.dropdown-list__item {
            padding: 8px !important;
            cursor: pointer;
            -webkit-transition: 0.3s;
            transition: 0.3s;
            font-size: 14px;
            font-weight: 500 !important;
            border-radius: 5px;
            min-width: 120px;
        }

        .dropdown-list>.dropdown-list__item:hover {
            background-color: rgb(var(--r), var(--g), var(--b)) !important;
        }

        .dropdown-list>.dropdown-list__item:hover span {
            color: #fff !important;
        }

        .dropdown-list>.dropdown-list__item,
        .custom--dropdown>.custom--dropdown__selected {
            display: flex;
            align-items: center;
            gap: 10px
        }

        .dropdown-list>.dropdown-list__item .thumb img,
        .custom--dropdown>.custom--dropdown__selected .thumb img {
            width: 100%;
            height: 100%;
            object-fit: cover !important;
        }

        .dropdown-list>.dropdown-list__item .thumb,
        .custom--dropdown>.custom--dropdown__selected .thumb {
            width: 25px;
            height: 25px;
            border-radius: 50%;
            overflow: hidden;
        }

        .dropdown-list>.dropdown-list__item .text {
            width: 100%;
            color: #000 !important;
        }

        .custom--dropdown>.custom--dropdown__selected .text {
            width: 100%;
            color: #fff !important;
            font-weight: 500 !important;
        }

        .fixed-header .custom--dropdown>.custom--dropdown__selected .text {
            color: #000 !important;
        }

        .dropdown-list__item .icon {
            color: #fff;
        }
        .fixed-header .dropdown-list__item .icon {
            color: #000;
        }

        .custom--dropdown .dropdown-list {
            top: calc(100% + 5px);
        }

        .side-menu--open~.sidebar-submenu {
            display: block;
        }
        .header--secondary .custom--dropdown>.custom--dropdown__selected .text {
            color: #000 !important;
        }
        .header--secondary .dropdown-list__item .icon {
            color: #000 !important;
        }
        .custom--dropdown.open .dropdown-list__item .icon i {
            transform: rotate(180deg);
        }
        /* language */
</style>
<style>
    @charset "UTF-8";


/*!
Animate.css - http://daneden.me/animate
Licensed under the MIT license

Copyright (c) 2013 Daniel Eden

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

.animated {
  -webkit-animation-duration: 1s;
  animation-duration: 1s;
  -webkit-animation-fill-mode: both;
  animation-fill-mode: both;
}

.animated.hinge {
  -webkit-animation-duration: 2s;
  animation-duration: 2s;
}

@-webkit-keyframes bounce {
  0%, 20%, 50%, 80%, 100% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  40% {
    -webkit-transform: translateY(-30px);
    transform: translateY(-30px);
  }

  60% {
    -webkit-transform: translateY(-15px);
    transform: translateY(-15px);
  }
}

@keyframes bounce {
  0%, 20%, 50%, 80%, 100% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  40% {
    -webkit-transform: translateY(-30px);
    -ms-transform: translateY(-30px);
    transform: translateY(-30px);
  }

  60% {
    -webkit-transform: translateY(-15px);
    -ms-transform: translateY(-15px);
    transform: translateY(-15px);
  }
}

.bounce {
  -webkit-animation-name: bounce;
  animation-name: bounce;
}

@-webkit-keyframes flash {
  0%, 50%, 100% {
    opacity: 1;
  }

  25%, 75% {
    opacity: 0;
  }
}

@keyframes flash {
  0%, 50%, 100% {
    opacity: 1;
  }

  25%, 75% {
    opacity: 0;
  }
}

.flash {
  -webkit-animation-name: flash;
  animation-name: flash;
}

/* originally authored by Nick Pettit - https://github.com/nickpettit/glide */

@-webkit-keyframes pulse {
  0% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }

  50% {
    -webkit-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }
}

@keyframes pulse {
  0% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }

  50% {
    -webkit-transform: scale(1.1);
    -ms-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }
}

.pulse {
  -webkit-animation-name: pulse;
  animation-name: pulse;
}

@-webkit-keyframes shake {
  0%, 100% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  10%, 30%, 50%, 70%, 90% {
    -webkit-transform: translateX(-10px);
    transform: translateX(-10px);
  }

  20%, 40%, 60%, 80% {
    -webkit-transform: translateX(10px);
    transform: translateX(10px);
  }
}

@keyframes shake {
  0%, 100% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  10%, 30%, 50%, 70%, 90% {
    -webkit-transform: translateX(-10px);
    -ms-transform: translateX(-10px);
    transform: translateX(-10px);
  }

  20%, 40%, 60%, 80% {
    -webkit-transform: translateX(10px);
    -ms-transform: translateX(10px);
    transform: translateX(10px);
  }
}

.shake {
  -webkit-animation-name: shake;
  animation-name: shake;
}

@-webkit-keyframes swing {
  20% {
    -webkit-transform: rotate(15deg);
    transform: rotate(15deg);
  }

  40% {
    -webkit-transform: rotate(-10deg);
    transform: rotate(-10deg);
  }

  60% {
    -webkit-transform: rotate(5deg);
    transform: rotate(5deg);
  }

  80% {
    -webkit-transform: rotate(-5deg);
    transform: rotate(-5deg);
  }

  100% {
    -webkit-transform: rotate(0deg);
    transform: rotate(0deg);
  }
}

@keyframes swing {
  20% {
    -webkit-transform: rotate(15deg);
    -ms-transform: rotate(15deg);
    transform: rotate(15deg);
  }

  40% {
    -webkit-transform: rotate(-10deg);
    -ms-transform: rotate(-10deg);
    transform: rotate(-10deg);
  }

  60% {
    -webkit-transform: rotate(5deg);
    -ms-transform: rotate(5deg);
    transform: rotate(5deg);
  }

  80% {
    -webkit-transform: rotate(-5deg);
    -ms-transform: rotate(-5deg);
    transform: rotate(-5deg);
  }

  100% {
    -webkit-transform: rotate(0deg);
    -ms-transform: rotate(0deg);
    transform: rotate(0deg);
  }
}

.swing {
  -webkit-transform-origin: top center;
  -ms-transform-origin: top center;
  transform-origin: top center;
  -webkit-animation-name: swing;
  animation-name: swing;
}

@-webkit-keyframes tada {
  0% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }

  10%, 20% {
    -webkit-transform: scale(0.9) rotate(-3deg);
    transform: scale(0.9) rotate(-3deg);
  }

  30%, 50%, 70%, 90% {
    -webkit-transform: scale(1.1) rotate(3deg);
    transform: scale(1.1) rotate(3deg);
  }

  40%, 60%, 80% {
    -webkit-transform: scale(1.1) rotate(-3deg);
    transform: scale(1.1) rotate(-3deg);
  }

  100% {
    -webkit-transform: scale(1) rotate(0);
    transform: scale(1) rotate(0);
  }
}

@keyframes tada {
  0% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }

  10%, 20% {
    -webkit-transform: scale(0.9) rotate(-3deg);
    -ms-transform: scale(0.9) rotate(-3deg);
    transform: scale(0.9) rotate(-3deg);
  }

  30%, 50%, 70%, 90% {
    -webkit-transform: scale(1.1) rotate(3deg);
    -ms-transform: scale(1.1) rotate(3deg);
    transform: scale(1.1) rotate(3deg);
  }
  
  .footer-section {
  position: relative;
}
.footer-section::before {
  content: "";
  position: absolute;
  /*background-color: #0a2843;*/
  background-color: #111827f2;
  width: 100%;
  height: 60%;
  z-index: -1;
  left: 0;
  bottom: 0;
}
.footer-section .newsletter {
    max-width: 100%;
  border-radius: 20px;
  padding: 80px 0;
  /*background-image: url(/assets/images/footer-bg-left.png), url(/assets/images/footer-bg-right.png);*/
  background-image: url(/assets/images/footer-bg-left.png);
  background-repeat: no-repeat;
  background-position: left 20px center, right bottom;
  background-color: var(--primary-color);
}
.footer-section .newsletter form {
  width: 60%;
  margin: 0 auto;
}
.footer-section .newsletter form .form-group {
  background-color: var(--bs-white);
  border: 1px solid #e2e2ea;
  border-radius: 35px;
  padding: 10px;
}
.footer-section .newsletter form .form-group input {
  border-radius: 35px;
  padding: 0 20px;
  border-color: transparent;
}
.footer-section .newsletter form .form-group button {
  min-width: 50px;
  min-height: 50px;
  border-radius: 50%;
  background-color: var(--primary-color);
}
.footer-section .footer-area .menu-item li {
  margin-right: 18px;
}
.footer-section .footer-area .menu-item li a {
  color: var(--bs-white);
  font-weight: 600;
}
.footer-section .footer-area .social-link a {
  margin-left: 15px;
}
.footer-section .footer-area .copyright span,
.footer-section .footer-area .copyright p,
.footer-section .footer-area .copyright a {
  color: var(--bs-white);
}
.footer-section .footer-area .footer-bottom {
  border-top: 1px solid var(--border-color);
}
.footer-section .footer-area .footer-bottom .menu-item li {
  margin-right: 0;
  margin-left: 18px;
}
.footer-section .footer-area .footer-bottom {
  padding: 30px 0;
  margin-top: 30px;
}

  40%, 60%, 80% {
    -webkit-transform: scale(1.1) rotate(-3deg);
    -ms-transform: scale(1.1) rotate(-3deg);
    transform: scale(1.1) rotate(-3deg);
  }

  100% {
    -webkit-transform: scale(1) rotate(0);
    -ms-transform: scale(1) rotate(0);
    transform: scale(1) rotate(0);
  }
}

.tada {
  -webkit-animation-name: tada;
  animation-name: tada;
}

/* originally authored by Nick Pettit - https://github.com/nickpettit/glide */

@-webkit-keyframes wobble {
  0% {
    -webkit-transform: translateX(0%);
    transform: translateX(0%);
  }

  15% {
    -webkit-transform: translateX(-25%) rotate(-5deg);
    transform: translateX(-25%) rotate(-5deg);
  }

  30% {
    -webkit-transform: translateX(20%) rotate(3deg);
    transform: translateX(20%) rotate(3deg);
  }

  45% {
    -webkit-transform: translateX(-15%) rotate(-3deg);
    transform: translateX(-15%) rotate(-3deg);
  }

  60% {
    -webkit-transform: translateX(10%) rotate(2deg);
    transform: translateX(10%) rotate(2deg);
  }

  75% {
    -webkit-transform: translateX(-5%) rotate(-1deg);
    transform: translateX(-5%) rotate(-1deg);
  }

  100% {
    -webkit-transform: translateX(0%);
    transform: translateX(0%);
  }
}

@keyframes wobble {
  0% {
    -webkit-transform: translateX(0%);
    -ms-transform: translateX(0%);
    transform: translateX(0%);
  }

  15% {
    -webkit-transform: translateX(-25%) rotate(-5deg);
    -ms-transform: translateX(-25%) rotate(-5deg);
    transform: translateX(-25%) rotate(-5deg);
  }

  30% {
    -webkit-transform: translateX(20%) rotate(3deg);
    -ms-transform: translateX(20%) rotate(3deg);
    transform: translateX(20%) rotate(3deg);
  }

  45% {
    -webkit-transform: translateX(-15%) rotate(-3deg);
    -ms-transform: translateX(-15%) rotate(-3deg);
    transform: translateX(-15%) rotate(-3deg);
  }

  60% {
    -webkit-transform: translateX(10%) rotate(2deg);
    -ms-transform: translateX(10%) rotate(2deg);
    transform: translateX(10%) rotate(2deg);
  }

  75% {
    -webkit-transform: translateX(-5%) rotate(-1deg);
    -ms-transform: translateX(-5%) rotate(-1deg);
    transform: translateX(-5%) rotate(-1deg);
  }

  100% {
    -webkit-transform: translateX(0%);
    -ms-transform: translateX(0%);
    transform: translateX(0%);
  }
}

.wobble {
  -webkit-animation-name: wobble;
  animation-name: wobble;
}

@-webkit-keyframes bounceIn {
  0% {
    opacity: 0;
    -webkit-transform: scale(.3);
    transform: scale(.3);
  }

  50% {
    opacity: 1;
    -webkit-transform: scale(1.05);
    transform: scale(1.05);
  }

  70% {
    -webkit-transform: scale(.9);
    transform: scale(.9);
  }

  100% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }
}

@keyframes bounceIn {
  0% {
    opacity: 0;
    -webkit-transform: scale(.3);
    -ms-transform: scale(.3);
    transform: scale(.3);
  }

  50% {
    opacity: 1;
    -webkit-transform: scale(1.05);
    -ms-transform: scale(1.05);
    transform: scale(1.05);
  }

  70% {
    -webkit-transform: scale(.9);
    -ms-transform: scale(.9);
    transform: scale(.9);
  }

  100% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }
}

.bounceIn {
  -webkit-animation-name: bounceIn;
  animation-name: bounceIn;
}

@-webkit-keyframes bounceInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateY(30px);
    transform: translateY(30px);
  }

  80% {
    -webkit-transform: translateY(-10px);
    transform: translateY(-10px);
  }

  100% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes bounceInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateY(30px);
    -ms-transform: translateY(30px);
    transform: translateY(30px);
  }

  80% {
    -webkit-transform: translateY(-10px);
    -ms-transform: translateY(-10px);
    transform: translateY(-10px);
  }

  100% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.bounceInDown {
  -webkit-animation-name: bounceInDown;
  animation-name: bounceInDown;
}

@-webkit-keyframes bounceInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateX(30px);
    transform: translateX(30px);
  }

  80% {
    -webkit-transform: translateX(-10px);
    transform: translateX(-10px);
  }

  100% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes bounceInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateX(30px);
    -ms-transform: translateX(30px);
    transform: translateX(30px);
  }

  80% {
    -webkit-transform: translateX(-10px);
    -ms-transform: translateX(-10px);
    transform: translateX(-10px);
  }

  100% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.bounceInLeft {
  -webkit-animation-name: bounceInLeft;
  animation-name: bounceInLeft;
}

@-webkit-keyframes bounceInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateX(-30px);
    transform: translateX(-30px);
  }

  80% {
    -webkit-transform: translateX(10px);
    transform: translateX(10px);
  }

  100% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes bounceInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateX(-30px);
    -ms-transform: translateX(-30px);
    transform: translateX(-30px);
  }

  80% {
    -webkit-transform: translateX(10px);
    -ms-transform: translateX(10px);
    transform: translateX(10px);
  }

  100% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.bounceInRight {
  -webkit-animation-name: bounceInRight;
  animation-name: bounceInRight;
}

@-webkit-keyframes bounceInUp {
  0% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    transform: translateY(2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateY(-30px);
    transform: translateY(-30px);
  }

  80% {
    -webkit-transform: translateY(10px);
    transform: translateY(10px);
  }

  100% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes bounceInUp {
  0% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    -ms-transform: translateY(2000px);
    transform: translateY(2000px);
  }

  60% {
    opacity: 1;
    -webkit-transform: translateY(-30px);
    -ms-transform: translateY(-30px);
    transform: translateY(-30px);
  }

  80% {
    -webkit-transform: translateY(10px);
    -ms-transform: translateY(10px);
    transform: translateY(10px);
  }

  100% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.bounceInUp {
  -webkit-animation-name: bounceInUp;
  animation-name: bounceInUp;
}

@-webkit-keyframes bounceOut {
  0% {
    -webkit-transform: scale(1);
    transform: scale(1);
  }

  25% {
    -webkit-transform: scale(.95);
    transform: scale(.95);
  }

  50% {
    opacity: 1;
    -webkit-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    opacity: 0;
    -webkit-transform: scale(.3);
    transform: scale(.3);
  }
}

@keyframes bounceOut {
  0% {
    -webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
  }

  25% {
    -webkit-transform: scale(.95);
    -ms-transform: scale(.95);
    transform: scale(.95);
  }

  50% {
    opacity: 1;
    -webkit-transform: scale(1.1);
    -ms-transform: scale(1.1);
    transform: scale(1.1);
  }

  100% {
    opacity: 0;
    -webkit-transform: scale(.3);
    -ms-transform: scale(.3);
    transform: scale(.3);
  }
}

.bounceOut {
  -webkit-animation-name: bounceOut;
  animation-name: bounceOut;
}

@-webkit-keyframes bounceOutDown {
  0% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateY(-20px);
    transform: translateY(-20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    transform: translateY(2000px);
  }
}

@keyframes bounceOutDown {
  0% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateY(-20px);
    -ms-transform: translateY(-20px);
    transform: translateY(-20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    -ms-transform: translateY(2000px);
    transform: translateY(2000px);
  }
}

.bounceOutDown {
  -webkit-animation-name: bounceOutDown;
  animation-name: bounceOutDown;
}

@-webkit-keyframes bounceOutLeft {
  0% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateX(20px);
    transform: translateX(20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

@keyframes bounceOutLeft {
  0% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateX(20px);
    -ms-transform: translateX(20px);
    transform: translateX(20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

.bounceOutLeft {
  -webkit-animation-name: bounceOutLeft;
  animation-name: bounceOutLeft;
}

@-webkit-keyframes bounceOutRight {
  0% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateX(-20px);
    transform: translateX(-20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

@keyframes bounceOutRight {
  0% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateX(-20px);
    -ms-transform: translateX(-20px);
    transform: translateX(-20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

.bounceOutRight {
  -webkit-animation-name: bounceOutRight;
  animation-name: bounceOutRight;
}

@-webkit-keyframes bounceOutUp {
  0% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateY(20px);
    transform: translateY(20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

@keyframes bounceOutUp {
  0% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  20% {
    opacity: 1;
    -webkit-transform: translateY(20px);
    -ms-transform: translateY(20px);
    transform: translateY(20px);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

.bounceOutUp {
  -webkit-animation-name: bounceOutUp;
  animation-name: bounceOutUp;
}

@-webkit-keyframes fadeIn {
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
}

@keyframes fadeIn {
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
}

.fadeIn {
  -webkit-animation-name: fadeIn;
  animation-name: fadeIn;
}

@-webkit-keyframes fadeInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-20px);
    transform: translateY(-20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes fadeInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-20px);
    -ms-transform: translateY(-20px);
    transform: translateY(-20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.fadeInDown {
  -webkit-animation-name: fadeInDown;
  animation-name: fadeInDown;
}

@-webkit-keyframes fadeInDownBig {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes fadeInDownBig {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.fadeInDownBig {
  -webkit-animation-name: fadeInDownBig;
  animation-name: fadeInDownBig;
}

@-webkit-keyframes fadeInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-20px);
    transform: translateX(-20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes fadeInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-20px);
    -ms-transform: translateX(-20px);
    transform: translateX(-20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.fadeInLeft {
  -webkit-animation-name: fadeInLeft;
  animation-name: fadeInLeft;
}

@-webkit-keyframes fadeInLeftBig {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes fadeInLeftBig {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.fadeInLeftBig {
  -webkit-animation-name: fadeInLeftBig;
  animation-name: fadeInLeftBig;
}

@-webkit-keyframes fadeInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(20px);
    transform: translateX(20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes fadeInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(20px);
    -ms-transform: translateX(20px);
    transform: translateX(20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.fadeInRight {
  -webkit-animation-name: fadeInRight;
  animation-name: fadeInRight;
}

@-webkit-keyframes fadeInRightBig {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes fadeInRightBig {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.fadeInRightBig {
  -webkit-animation-name: fadeInRightBig;
  animation-name: fadeInRightBig;
}

@-webkit-keyframes fadeInUp {
  0% {
    opacity: 0;
    -webkit-transform: translateY(20px);
    transform: translateY(20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes fadeInUp {
  0% {
    opacity: 0;
    -webkit-transform: translateY(20px);
    -ms-transform: translateY(20px);
    transform: translateY(20px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.fadeInUp {
  -webkit-animation-name: fadeInUp;
  animation-name: fadeInUp;
}

@-webkit-keyframes fadeInUpBig {
  0% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    transform: translateY(2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes fadeInUpBig {
  0% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    -ms-transform: translateY(2000px);
    transform: translateY(2000px);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.fadeInUpBig {
  -webkit-animation-name: fadeInUpBig;
  animation-name: fadeInUpBig;
}

@-webkit-keyframes fadeOut {
  0% {
    opacity: 1;
  }

  100% {
    opacity: 0;
  }
}

@keyframes fadeOut {
  0% {
    opacity: 1;
  }

  100% {
    opacity: 0;
  }
}

.fadeOut {
  -webkit-animation-name: fadeOut;
  animation-name: fadeOut;
}

@-webkit-keyframes fadeOutDown {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(20px);
    transform: translateY(20px);
  }
}

@keyframes fadeOutDown {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(20px);
    -ms-transform: translateY(20px);
    transform: translateY(20px);
  }
}

.fadeOutDown {
  -webkit-animation-name: fadeOutDown;
  animation-name: fadeOutDown;
}

@-webkit-keyframes fadeOutDownBig {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    transform: translateY(2000px);
  }
}

@keyframes fadeOutDownBig {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(2000px);
    -ms-transform: translateY(2000px);
    transform: translateY(2000px);
  }
}

.fadeOutDownBig {
  -webkit-animation-name: fadeOutDownBig;
  animation-name: fadeOutDownBig;
}

@-webkit-keyframes fadeOutLeft {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-20px);
    transform: translateX(-20px);
  }
}

@keyframes fadeOutLeft {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-20px);
    -ms-transform: translateX(-20px);
    transform: translateX(-20px);
  }
}

.fadeOutLeft {
  -webkit-animation-name: fadeOutLeft;
  animation-name: fadeOutLeft;
}

@-webkit-keyframes fadeOutLeftBig {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

@keyframes fadeOutLeftBig {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

.fadeOutLeftBig {
  -webkit-animation-name: fadeOutLeftBig;
  animation-name: fadeOutLeftBig;
}

@-webkit-keyframes fadeOutRight {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(20px);
    transform: translateX(20px);
  }
}

@keyframes fadeOutRight {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(20px);
    -ms-transform: translateX(20px);
    transform: translateX(20px);
  }
}

.fadeOutRight {
  -webkit-animation-name: fadeOutRight;
  animation-name: fadeOutRight;
}

@-webkit-keyframes fadeOutRightBig {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

@keyframes fadeOutRightBig {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

.fadeOutRightBig {
  -webkit-animation-name: fadeOutRightBig;
  animation-name: fadeOutRightBig;
}

@-webkit-keyframes fadeOutUp {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-20px);
    transform: translateY(-20px);
  }
}

@keyframes fadeOutUp {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-20px);
    -ms-transform: translateY(-20px);
    transform: translateY(-20px);
  }
}

.fadeOutUp {
  -webkit-animation-name: fadeOutUp;
  animation-name: fadeOutUp;
}

@-webkit-keyframes fadeOutUpBig {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

@keyframes fadeOutUpBig {
  0% {
    opacity: 1;
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

.fadeOutUpBig {
  -webkit-animation-name: fadeOutUpBig;
  animation-name: fadeOutUpBig;
}

@-webkit-keyframes flip {
  0% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(0) scale(1);
    transform: perspective(400px) translateZ(0) rotateY(0) scale(1);
    -webkit-animation-timing-function: ease-out;
    animation-timing-function: ease-out;
  }

  40% {
    -webkit-transform: perspective(400px) translateZ(150px) rotateY(170deg) scale(1);
    transform: perspective(400px) translateZ(150px) rotateY(170deg) scale(1);
    -webkit-animation-timing-function: ease-out;
    animation-timing-function: ease-out;
  }

  50% {
    -webkit-transform: perspective(400px) translateZ(150px) rotateY(190deg) scale(1);
    transform: perspective(400px) translateZ(150px) rotateY(190deg) scale(1);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }

  80% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(.95);
    transform: perspective(400px) translateZ(0) rotateY(360deg) scale(.95);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }

  100% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(1);
    transform: perspective(400px) translateZ(0) rotateY(360deg) scale(1);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }
}

@keyframes flip {
  0% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(0) scale(1);
    -ms-transform: perspective(400px) translateZ(0) rotateY(0) scale(1);
    transform: perspective(400px) translateZ(0) rotateY(0) scale(1);
    -webkit-animation-timing-function: ease-out;
    animation-timing-function: ease-out;
  }

  40% {
    -webkit-transform: perspective(400px) translateZ(150px) rotateY(170deg) scale(1);
    -ms-transform: perspective(400px) translateZ(150px) rotateY(170deg) scale(1);
    transform: perspective(400px) translateZ(150px) rotateY(170deg) scale(1);
    -webkit-animation-timing-function: ease-out;
    animation-timing-function: ease-out;
  }

  50% {
    -webkit-transform: perspective(400px) translateZ(150px) rotateY(190deg) scale(1);
    -ms-transform: perspective(400px) translateZ(150px) rotateY(190deg) scale(1);
    transform: perspective(400px) translateZ(150px) rotateY(190deg) scale(1);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }

  80% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(.95);
    -ms-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(.95);
    transform: perspective(400px) translateZ(0) rotateY(360deg) scale(.95);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }

  100% {
    -webkit-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(1);
    -ms-transform: perspective(400px) translateZ(0) rotateY(360deg) scale(1);
    transform: perspective(400px) translateZ(0) rotateY(360deg) scale(1);
    -webkit-animation-timing-function: ease-in;
    animation-timing-function: ease-in;
  }
}

.animated.flip {
  -webkit-backface-visibility: visible;
  -ms-backface-visibility: visible;
  backface-visibility: visible;
  -webkit-animation-name: flip;
  animation-name: flip;
}

@-webkit-keyframes flipInX {
  0% {
    -webkit-transform: perspective(400px) rotateX(90deg);
    transform: perspective(400px) rotateX(90deg);
    opacity: 0;
  }

  40% {
    -webkit-transform: perspective(400px) rotateX(-10deg);
    transform: perspective(400px) rotateX(-10deg);
  }

  70% {
    -webkit-transform: perspective(400px) rotateX(10deg);
    transform: perspective(400px) rotateX(10deg);
  }

  100% {
    -webkit-transform: perspective(400px) rotateX(0deg);
    transform: perspective(400px) rotateX(0deg);
    opacity: 1;
  }
}

@keyframes flipInX {
  0% {
    -webkit-transform: perspective(400px) rotateX(90deg);
    -ms-transform: perspective(400px) rotateX(90deg);
    transform: perspective(400px) rotateX(90deg);
    opacity: 0;
  }

  40% {
    -webkit-transform: perspective(400px) rotateX(-10deg);
    -ms-transform: perspective(400px) rotateX(-10deg);
    transform: perspective(400px) rotateX(-10deg);
  }

  70% {
    -webkit-transform: perspective(400px) rotateX(10deg);
    -ms-transform: perspective(400px) rotateX(10deg);
    transform: perspective(400px) rotateX(10deg);
  }

  100% {
    -webkit-transform: perspective(400px) rotateX(0deg);
    -ms-transform: perspective(400px) rotateX(0deg);
    transform: perspective(400px) rotateX(0deg);
    opacity: 1;
  }
}

.flipInX {
  -webkit-backface-visibility: visible !important;
  -ms-backface-visibility: visible !important;
  backface-visibility: visible !important;
  -webkit-animation-name: flipInX;
  animation-name: flipInX;
}

@-webkit-keyframes flipInY {
  0% {
    -webkit-transform: perspective(400px) rotateY(90deg);
    transform: perspective(400px) rotateY(90deg);
    opacity: 0;
  }

  40% {
    -webkit-transform: perspective(400px) rotateY(-10deg);
    transform: perspective(400px) rotateY(-10deg);
  }

  70% {
    -webkit-transform: perspective(400px) rotateY(10deg);
    transform: perspective(400px) rotateY(10deg);
  }

  100% {
    -webkit-transform: perspective(400px) rotateY(0deg);
    transform: perspective(400px) rotateY(0deg);
    opacity: 1;
  }
}

@keyframes flipInY {
  0% {
    -webkit-transform: perspective(400px) rotateY(90deg);
    -ms-transform: perspective(400px) rotateY(90deg);
    transform: perspective(400px) rotateY(90deg);
    opacity: 0;
  }

  40% {
    -webkit-transform: perspective(400px) rotateY(-10deg);
    -ms-transform: perspective(400px) rotateY(-10deg);
    transform: perspective(400px) rotateY(-10deg);
  }

  70% {
    -webkit-transform: perspective(400px) rotateY(10deg);
    -ms-transform: perspective(400px) rotateY(10deg);
    transform: perspective(400px) rotateY(10deg);
  }

  100% {
    -webkit-transform: perspective(400px) rotateY(0deg);
    -ms-transform: perspective(400px) rotateY(0deg);
    transform: perspective(400px) rotateY(0deg);
    opacity: 1;
  }
}

.flipInY {
  -webkit-backface-visibility: visible !important;
  -ms-backface-visibility: visible !important;
  backface-visibility: visible !important;
  -webkit-animation-name: flipInY;
  animation-name: flipInY;
}

@-webkit-keyframes flipOutX {
  0% {
    -webkit-transform: perspective(400px) rotateX(0deg);
    transform: perspective(400px) rotateX(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: perspective(400px) rotateX(90deg);
    transform: perspective(400px) rotateX(90deg);
    opacity: 0;
  }
}

@keyframes flipOutX {
  0% {
    -webkit-transform: perspective(400px) rotateX(0deg);
    -ms-transform: perspective(400px) rotateX(0deg);
    transform: perspective(400px) rotateX(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: perspective(400px) rotateX(90deg);
    -ms-transform: perspective(400px) rotateX(90deg);
    transform: perspective(400px) rotateX(90deg);
    opacity: 0;
  }
}

.flipOutX {
  -webkit-animation-name: flipOutX;
  animation-name: flipOutX;
  -webkit-backface-visibility: visible !important;
  -ms-backface-visibility: visible !important;
  backface-visibility: visible !important;
}

@-webkit-keyframes flipOutY {
  0% {
    -webkit-transform: perspective(400px) rotateY(0deg);
    transform: perspective(400px) rotateY(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: perspective(400px) rotateY(90deg);
    transform: perspective(400px) rotateY(90deg);
    opacity: 0;
  }
}

@keyframes flipOutY {
  0% {
    -webkit-transform: perspective(400px) rotateY(0deg);
    -ms-transform: perspective(400px) rotateY(0deg);
    transform: perspective(400px) rotateY(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: perspective(400px) rotateY(90deg);
    -ms-transform: perspective(400px) rotateY(90deg);
    transform: perspective(400px) rotateY(90deg);
    opacity: 0;
  }
}

.flipOutY {
  -webkit-backface-visibility: visible !important;
  -ms-backface-visibility: visible !important;
  backface-visibility: visible !important;
  -webkit-animation-name: flipOutY;
  animation-name: flipOutY;
}

@-webkit-keyframes lightSpeedIn {
  0% {
    -webkit-transform: translateX(100%) skewX(-30deg);
    transform: translateX(100%) skewX(-30deg);
    opacity: 0;
  }

  60% {
    -webkit-transform: translateX(-20%) skewX(30deg);
    transform: translateX(-20%) skewX(30deg);
    opacity: 1;
  }

  80% {
    -webkit-transform: translateX(0%) skewX(-15deg);
    transform: translateX(0%) skewX(-15deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: translateX(0%) skewX(0deg);
    transform: translateX(0%) skewX(0deg);
    opacity: 1;
  }
}

@keyframes lightSpeedIn {
  0% {
    -webkit-transform: translateX(100%) skewX(-30deg);
    -ms-transform: translateX(100%) skewX(-30deg);
    transform: translateX(100%) skewX(-30deg);
    opacity: 0;
  }

  60% {
    -webkit-transform: translateX(-20%) skewX(30deg);
    -ms-transform: translateX(-20%) skewX(30deg);
    transform: translateX(-20%) skewX(30deg);
    opacity: 1;
  }

  80% {
    -webkit-transform: translateX(0%) skewX(-15deg);
    -ms-transform: translateX(0%) skewX(-15deg);
    transform: translateX(0%) skewX(-15deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: translateX(0%) skewX(0deg);
    -ms-transform: translateX(0%) skewX(0deg);
    transform: translateX(0%) skewX(0deg);
    opacity: 1;
  }
}

.lightSpeedIn {
  -webkit-animation-name: lightSpeedIn;
  animation-name: lightSpeedIn;
  -webkit-animation-timing-function: ease-out;
  animation-timing-function: ease-out;
}

@-webkit-keyframes lightSpeedOut {
  0% {
    -webkit-transform: translateX(0%) skewX(0deg);
    transform: translateX(0%) skewX(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: translateX(100%) skewX(-30deg);
    transform: translateX(100%) skewX(-30deg);
    opacity: 0;
  }
}

@keyframes lightSpeedOut {
  0% {
    -webkit-transform: translateX(0%) skewX(0deg);
    -ms-transform: translateX(0%) skewX(0deg);
    transform: translateX(0%) skewX(0deg);
    opacity: 1;
  }

  100% {
    -webkit-transform: translateX(100%) skewX(-30deg);
    -ms-transform: translateX(100%) skewX(-30deg);
    transform: translateX(100%) skewX(-30deg);
    opacity: 0;
  }
}

.lightSpeedOut {
  -webkit-animation-name: lightSpeedOut;
  animation-name: lightSpeedOut;
  -webkit-animation-timing-function: ease-in;
  animation-timing-function: ease-in;
}

@-webkit-keyframes rotateIn {
  0% {
    -webkit-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(-200deg);
    transform: rotate(-200deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

@keyframes rotateIn {
  0% {
    -webkit-transform-origin: center center;
    -ms-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(-200deg);
    -ms-transform: rotate(-200deg);
    transform: rotate(-200deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: center center;
    -ms-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

.rotateIn {
  -webkit-animation-name: rotateIn;
  animation-name: rotateIn;
}

@-webkit-keyframes rotateInDownLeft {
  0% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

@keyframes rotateInDownLeft {
  0% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(-90deg);
    -ms-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

.rotateInDownLeft {
  -webkit-animation-name: rotateInDownLeft;
  animation-name: rotateInDownLeft;
}

@-webkit-keyframes rotateInDownRight {
  0% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

@keyframes rotateInDownRight {
  0% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(90deg);
    -ms-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

.rotateInDownRight {
  -webkit-animation-name: rotateInDownRight;
  animation-name: rotateInDownRight;
}

@-webkit-keyframes rotateInUpLeft {
  0% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

@keyframes rotateInUpLeft {
  0% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(90deg);
    -ms-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

.rotateInUpLeft {
  -webkit-animation-name: rotateInUpLeft;
  animation-name: rotateInUpLeft;
}

@-webkit-keyframes rotateInUpRight {
  0% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

@keyframes rotateInUpRight {
  0% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(-90deg);
    -ms-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }

  100% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }
}

.rotateInUpRight {
  -webkit-animation-name: rotateInUpRight;
  animation-name: rotateInUpRight;
}

@-webkit-keyframes rotateOut {
  0% {
    -webkit-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(200deg);
    transform: rotate(200deg);
    opacity: 0;
  }
}

@keyframes rotateOut {
  0% {
    -webkit-transform-origin: center center;
    -ms-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: center center;
    -ms-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: rotate(200deg);
    -ms-transform: rotate(200deg);
    transform: rotate(200deg);
    opacity: 0;
  }
}

.rotateOut {
  -webkit-animation-name: rotateOut;
  animation-name: rotateOut;
}

@-webkit-keyframes rotateOutDownLeft {
  0% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }
}

@keyframes rotateOutDownLeft {
  0% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(90deg);
    -ms-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }
}

.rotateOutDownLeft {
  -webkit-animation-name: rotateOutDownLeft;
  animation-name: rotateOutDownLeft;
}

@-webkit-keyframes rotateOutDownRight {
  0% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }
}

@keyframes rotateOutDownRight {
  0% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(-90deg);
    -ms-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }
}

.rotateOutDownRight {
  -webkit-animation-name: rotateOutDownRight;
  animation-name: rotateOutDownRight;
}

@-webkit-keyframes rotateOutUpLeft {
  0% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }
}

@keyframes rotateOutUpLeft {
  0% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: left bottom;
    -ms-transform-origin: left bottom;
    transform-origin: left bottom;
    -webkit-transform: rotate(-90deg);
    -ms-transform: rotate(-90deg);
    transform: rotate(-90deg);
    opacity: 0;
  }
}

.rotateOutUpLeft {
  -webkit-animation-name: rotateOutUpLeft;
  animation-name: rotateOutUpLeft;
}

@-webkit-keyframes rotateOutUpRight {
  0% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }
}

@keyframes rotateOutUpRight {
  0% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    opacity: 1;
  }

  100% {
    -webkit-transform-origin: right bottom;
    -ms-transform-origin: right bottom;
    transform-origin: right bottom;
    -webkit-transform: rotate(90deg);
    -ms-transform: rotate(90deg);
    transform: rotate(90deg);
    opacity: 0;
  }
}

.rotateOutUpRight {
  -webkit-animation-name: rotateOutUpRight;
  animation-name: rotateOutUpRight;
}

@-webkit-keyframes slideInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  100% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }
}

@keyframes slideInDown {
  0% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }

  100% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }
}

.slideInDown {
  -webkit-animation-name: slideInDown;
  animation-name: slideInDown;
}

@-webkit-keyframes slideInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  100% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes slideInLeft {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }

  100% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.slideInLeft {
  -webkit-animation-name: slideInLeft;
  animation-name: slideInLeft;
}

@-webkit-keyframes slideInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  100% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }
}

@keyframes slideInRight {
  0% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }

  100% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }
}

.slideInRight {
  -webkit-animation-name: slideInRight;
  animation-name: slideInRight;
}

@-webkit-keyframes slideOutLeft {
  0% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

@keyframes slideOutLeft {
  0% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(-2000px);
    -ms-transform: translateX(-2000px);
    transform: translateX(-2000px);
  }
}

.slideOutLeft {
  -webkit-animation-name: slideOutLeft;
  animation-name: slideOutLeft;
}

@-webkit-keyframes slideOutRight {
  0% {
    -webkit-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

@keyframes slideOutRight {
  0% {
    -webkit-transform: translateX(0);
    -ms-transform: translateX(0);
    transform: translateX(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(2000px);
    -ms-transform: translateX(2000px);
    transform: translateX(2000px);
  }
}

.slideOutRight {
  -webkit-animation-name: slideOutRight;
  animation-name: slideOutRight;
}

@-webkit-keyframes slideOutUp {
  0% {
    -webkit-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

@keyframes slideOutUp {
  0% {
    -webkit-transform: translateY(0);
    -ms-transform: translateY(0);
    transform: translateY(0);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateY(-2000px);
    -ms-transform: translateY(-2000px);
    transform: translateY(-2000px);
  }
}

.slideOutUp {
  -webkit-animation-name: slideOutUp;
  animation-name: slideOutUp;
}

@-webkit-keyframes hinge {
  0% {
    -webkit-transform: rotate(0);
    transform: rotate(0);
    -webkit-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  20%, 60% {
    -webkit-transform: rotate(80deg);
    transform: rotate(80deg);
    -webkit-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  40% {
    -webkit-transform: rotate(60deg);
    transform: rotate(60deg);
    -webkit-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  80% {
    -webkit-transform: rotate(60deg) translateY(0);
    transform: rotate(60deg) translateY(0);
    opacity: 1;
    -webkit-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  100% {
    -webkit-transform: translateY(700px);
    transform: translateY(700px);
    opacity: 0;
  }
}

@keyframes hinge {
  0% {
    -webkit-transform: rotate(0);
    -ms-transform: rotate(0);
    transform: rotate(0);
    -webkit-transform-origin: top left;
    -ms-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  20%, 60% {
    -webkit-transform: rotate(80deg);
    -ms-transform: rotate(80deg);
    transform: rotate(80deg);
    -webkit-transform-origin: top left;
    -ms-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  40% {
    -webkit-transform: rotate(60deg);
    -ms-transform: rotate(60deg);
    transform: rotate(60deg);
    -webkit-transform-origin: top left;
    -ms-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  80% {
    -webkit-transform: rotate(60deg) translateY(0);
    -ms-transform: rotate(60deg) translateY(0);
    transform: rotate(60deg) translateY(0);
    opacity: 1;
    -webkit-transform-origin: top left;
    -ms-transform-origin: top left;
    transform-origin: top left;
    -webkit-animation-timing-function: ease-in-out;
    animation-timing-function: ease-in-out;
  }

  100% {
    -webkit-transform: translateY(700px);
    -ms-transform: translateY(700px);
    transform: translateY(700px);
    opacity: 0;
  }
}

.hinge {
  -webkit-animation-name: hinge;
  animation-name: hinge;
}

/* originally authored by Nick Pettit - https://github.com/nickpettit/glide */

@-webkit-keyframes rollIn {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-100%) rotate(-120deg);
    transform: translateX(-100%) rotate(-120deg);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0px) rotate(0deg);
    transform: translateX(0px) rotate(0deg);
  }
}

@keyframes rollIn {
  0% {
    opacity: 0;
    -webkit-transform: translateX(-100%) rotate(-120deg);
    -ms-transform: translateX(-100%) rotate(-120deg);
    transform: translateX(-100%) rotate(-120deg);
  }

  100% {
    opacity: 1;
    -webkit-transform: translateX(0px) rotate(0deg);
    -ms-transform: translateX(0px) rotate(0deg);
    transform: translateX(0px) rotate(0deg);
  }
}

.rollIn {
  -webkit-animation-name: rollIn;
  animation-name: rollIn;
}

/* originally authored by Nick Pettit - https://github.com/nickpettit/glide */

@-webkit-keyframes rollOut {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0px) rotate(0deg);
    transform: translateX(0px) rotate(0deg);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(100%) rotate(120deg);
    transform: translateX(100%) rotate(120deg);
  }
}

@keyframes rollOut {
  0% {
    opacity: 1;
    -webkit-transform: translateX(0px) rotate(0deg);
    -ms-transform: translateX(0px) rotate(0deg);
    transform: translateX(0px) rotate(0deg);
  }

  100% {
    opacity: 0;
    -webkit-transform: translateX(100%) rotate(120deg);
    -ms-transform: translateX(100%) rotate(120deg);
    transform: translateX(100%) rotate(120deg);
  }
}

.rollOut {
  -webkit-animation-name: rollOut;
  animation-name: rollOut;
}
</style>
<style>
    /*============================================ 
# Template Name: Paylio Admin Dashboard
# Version: 1.0
# Date: 26/04/2022
# Author: pixelaxis
# Author URI: https://themeforest.net/user/pixelaxis/portfolio
# Developed By: Pranto
# Description: Paylio - Money Transfer and Online Payments Dashboard HTML Template
============================================*/
/*============================================ 
======== Table of Css Content =========
# Typography
# Normalize 
# Global style
# Header Area
# Banner Area
# Section Area
# Footer Area
============================================*/
@import url("https://fonts.googleapis.com/css2?family=Jost:wght@200;300;400;500;600;700;800;900&display=swap");
:root {
  --body-font: "Jost", sans-serif;
  --body-color: #F7F9FD;
  /*--primary-color: #4743c9;*/
    --primary-color: rgb(43 107 127 / var(--tw-bg-opacity, 1));
  --secondary-color: #00FE83;
  --head-color: #0c266c;
  --section-primary-color: #f2f3f9;
  --section-color: #f5f6fc;
  --para-color: #0c266c;
  --border-color: #868ea5;
  --hover-alt-color: #291b6b;
}

.collapsing {
  transition: 0.3s;
}

html {
  scroll-behavior: smooth;
}

body {
  font-family: var(--body-font);
  background-color: var(--body-color);
  font-size: 18px;
  line-height: 30px;
  padding: 0;
  margin: 0;
  font-weight: 400;
  overflow-x: hidden;
}

section,
footer {
  overflow-x: hidden;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  padding: 0;
  margin: 0;
}

h1,
h1 > a,
h2,
h2 > a,
h3,
h3 > a,
h4,
h4 > a,
h5,
h5 > a,
h6,
h6 > a {
  font-family: var(--body-font);
  color: var(--para-color);
  font-weight: 400;
  text-transform: initial;
  transition: all 0.3s;
}

h1 > a:hover,
h2 > a:hover,
h3 > a:hover,
h4 > a:hover,
h5 > a:hover,
h6 > a:hover {
  color: var(--para-color);
}

a,
a:focus,
a:hover {
  text-decoration: none;
  outline: none;
  color: var(--para-color);
}

img {
  max-width: 100%;
  height: auto;
}

.max-un {
  max-width: unset;
}

.d-rtl {
  direction: rtl;
}

ul,
ol {
  padding: 0;
  margin: 0;
  list-style: none;
}

input:focus,
textarea:focus {
  outline: none;
  box-shadow: none;
  border: 1px solid var(--border-color);
}

button {
  border: none;
  cursor: pointer;
}

input,
textarea {
  padding: 10px 20px;
  color: var(--para-color);
  width: 100%;
  font-family: var(--body-font);
  background: var(--bs-white);
  border: 1px solid #eeecf7;
  border-radius: 10px;
}

::placeholder {
  color: rgba(12, 38, 110, 0.502);
  opacity: 1;
}

:-ms-input-placeholder {
  color: rgba(12, 38, 110, 0.502);
}

::-ms-input-placeholder {
  color: rgba(12, 38, 110, 0.502);
}

input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

input[type="number"] {
  -moz-appearance: textfield;
}

input[type="password"] {
  font-family: initial;
}

input[type="checkbox"] {
  width: initial;
  height: initial;
}

select {
  padding: 10px 20px;
  border: none;
  cursor: pointer;
  outline: none;
}

textarea {
  min-height: 150px;
  resize: none;
}

span {
  display: inline-block;
}

/*.table thead th,*/
/*.table td,*/
/*.table th {*/
/*  border: none;*/
/*}*/

.d-grid {
  display: grid !important;
}

.b-none {
  border: none !important;
}

.ovf-unset {
  overflow-x: unset !important;
}

iframe {
  border: 0;
  width: 100%;
}

.shadow-none {
  box-shadow: none;
}

h1,
h1 > a {
  font-size: 76px;
  line-height: 98.8px;
  margin-top: -20px;
}

h2,
h2 > a {
  font-size: 57px;
  line-height: 74.1px;
  margin-top: -16px;
}

h3,
h3 > a {
  font-size: 43px;
  line-height: 55.9px;
  margin-top: -10px;
}

h4,
h4 > a {
  font-size: 32px;
  line-height: 41.6px;
  margin-top: -8px;
}

h5,
h5 > a {
  font-size: 24px;
  line-height: 31.2px;
  margin-top: -6px;
}

h6,
h6 > a {
  font-size: 18px;
  line-height: 23.4px;
  margin-top: -4px;
}

h1.m-none,
h2.m-none,
h3.m-none,
h4.m-none,
h5.m-none {
  margin: 0;
}

table thead tr th {
  font-size: 18px;
  line-height: 30px;
}

a {
  display: inline-block;
  color: var(--para-color);
  font-weight: 400;
  font-size: 18px;
  line-height: 30px;
}

p,
span,
li,
label {
  margin: 0;
  font-family: var(--body-font);
  font-size: 18px;
  font-weight: 400;
  color: var(--para-color);
  line-height: 30px;
}

.section-text {
  margin-bottom: 34px;
}

.section-header {
  margin-bottom: 53px;
}

.dark-sec .sub-title {
  color: var(--secondary-color);
}

.dark-sec .title, .dark-sec p {
  color: var(--bs-white);
}

.sub-title {
  color: var(--primary-color);
  margin-bottom: 30px;
}

.title {
  font-weight: 700;
  margin-bottom: 22px;
}

.xxlr {
  font-size: 26px;
  line-height: 36px;
  margin-top: -7px;
}

.xlr {
  font-size: 24px;
  line-height: 36px;
  margin-top: -7px;
}

.mdr {
  font-size: 16px;
  line-height: 22px;
}

.z-1 {
  z-index: 1;
}

.mb-30 {
  margin-bottom: 30px;
}

.mt-30 {
  margin-top: 30px;
}

.mb-40 {
  margin-bottom: 40px;
}

.mt-40 {
  margin-top: 40px;
}

.mb-60 {
  margin-bottom: 60px;
}

.mt-60 {
  margin-top: 60px;
}

.mb-80 {
  margin-bottom: 80px;
}

.mt-80 {
  margin-top: 80px;
}

.pt-120 {
  padding-top: 120px;
}

@media (max-width: 991px) {
  .pt-120 {
    padding-top: 60px;
  }
  .mb-60 {
    margin-bottom: 40px;
  }
  .mt-60 {
    margin-top: 40px;
  }
  .mb-80 {
    margin-bottom: 60px;
  }
  .mt-80 {
    margin-top: 60px;
  }
  .header-section {
    box-shadow: 0px 3px 10px 0px rgba(0, 0, 0, 0.3);
    background-color: var(--bs-white);
  }
}

@media (max-width: 575px) {
  .pt-120 {
    padding-top: 50px;
  }
}

.pb-120 {
  padding-bottom: 120px;
}

@media (max-width: 991px) {
  .pb-120 {
    padding-bottom: 60px;
  }
}

@media (max-width: 575px) {
  .pb-120 {
    padding-bottom: 50px;
  }
}

*::-webkit-scrollbar-track {
  background: #00003e;
}

*::-webkit-scrollbar {
  width: 6px;
}

*::-webkit-scrollbar-button,
*::-webkit-scrollbar-thumb {
  background-color: #5732c6;
}

.scrollToTop {
  position: fixed;
  bottom: 0;
  right: 30px;
  width: 45px;
  height: 45px;
  background-color: var(--primary-color);
  border-radius: 5px;
  color: #fff;
  line-height: 45px;
  font-size: 20px;
  text-align: center;
  z-index: 9;
  cursor: pointer;
  transition: all 1s;
  transform: translateY(100%);
}

.scrollToTop i {
  color: var(--bs-white);
}

.scrollToTop.active {
  bottom: 30px;
  transform: translateY(0%);
}

.preloader {
  position: fixed;
  width: 100%;
  height: 100vh;
  z-index: 99999999;
  overflow: visible;
  background: url(/images/preloader.gif) no-repeat center center;
  background-size: 30%;
  background-color: #F8F8F7;
}

.icon-svg {
  position: relative;
}

.icon-svg img {
  opacity: 1;
  position: absolute;
}

.icon-svg svg {
  position: absolute;
  stroke-dashoffset: 1500;
  stroke-dasharray: 1500;
  transform: scale(1);
  transition: transform 0.3s, fill 0.5s;
  opacity: 0;
  visibility: hidden;
}

.icon-svg:hover svg {
  visibility: visible;
  opacity: 1;
  stroke-dashoffset: 0;
  fill: transparent;
  transition: transform 0.3s, fill 0.5s, stroke-dashoffset 6s;
}

.icon-svg:hover img {
  opacity: 0;
  visibility: hidden;
}

.accordion-button:focus {
  box-shadow: none;
}

.animated {
  animation-duration: 1s;
  animation-fill-mode: both;
}

@keyframes fadeInDown {
  from {
    opacity: 0;
    transform: translate3d(0, -100%, 0);
  }
  to {
    opacity: 1;
    transform: none;
  }
}

.fadeInDown {
  animation-name: fadeInDown;
}

/* cmn btn */
.cmn-btn {
  padding: 10px 30px;
  font-weight: 600;
  text-align: center;
  background: var(--primary-color);
  color: var(--bs-white);
  transition: 0.3s;
  border-radius: 10px;
  border: 1px solid transparent;
  display: inline-flex;
  justify-content: center;
  align-items: center;
}

.cmn-btn:hover {
  background: transparent;
  border: 1px solid var(--border-color);
  color: var(--para-color);
}

.cmn-btn img, .cmn-btn i {
  margin-left: 10px;
}

.cmn-btn.active {
  background-color: transparent;
  border: 1px solid var(--border-color);
  color: var(--para-color);
}

.cmn-btn.active:hover {
  background: var(--primary-color);
  color: var(--bs-white);
}

@keyframes spin {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}

@keyframes ripple2Ani {
  0% {
    transform: translate(0px, 0px);
  }
  33% {
    transform: translate(-5px, -5px);
  }
  66% {
    transform: translate(5px, 5px);
  }
  100% {
    transform: translate(0px, 0px);
  }
}

@keyframes stretch {
  0% {
    transform: scale(0.5);
  }
  50% {
    transform: scale(0.8);
  }
  100% {
    transform: scale(1);
  }
  -0% {
    transform: scale(1);
  }
  -50% {
    transform: scale(0.8);
  }
  -100% {
    transform: scale(0.5);
  }
}

@keyframes rippleAni {
  0% {
    transform: translate(0px, 0px);
  }
  33% {
    transform: translate(5px, -5px);
  }
  66% {
    transform: translate(-5px, 5px);
  }
  100% {
    transform: translate(0px, 0px);
  }
}

.header-section {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  margin-left: 140px;
  width: calc(100% - 140px);
  z-index: 999;
  background-color: var(--bs-white);
  border-bottom: 1px solid #6c6ea6;
  transition: all 0.8s;
}

.header-section.header-fixed {
  position: fixed;
  top: 0;
  left: 0;
  z-index: 999;
  box-shadow: 0px 3px 10px 0px rgba(0, 0, 0, 0.3);
  background-color: var(--bs-white);
  border-color: transparent;
}

.header-section .navbar-toggler {
  padding-right: 0;
  display: none;
  border: none;
}

.header-section .navbar-toggler:focus {
  box-shadow: none;
}

.header-section .navbar-toggler i {
  color: var(--head-alt-color);
}

.header-section .navbar-area {
  padding: 10px 40px;
}

.header-section .navbar-area .sidebar-icon {
  margin-right: 100px;
  cursor: pointer;
}

.header-section .navbar-area form .form-group {
  padding: 0 12px;
  background: #f9f9f9;
  border: 1px solid #d0d3e8;
  border-radius: 10px;
}

.header-section .navbar-area form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
}

.header-section .navbar-area .dashboard-nav {
  display: flex;
  align-items: center;
  gap: 30px;
  position: relative;
  margin-left: 100px;
}

.header-section .navbar-area .dashboard-nav .single-item {
  cursor: pointer;
}

.header-section .navbar-area .dashboard-nav .single-item .profile-area i {
  margin-left: 5px;
}

.header-section .navbar-area .dashboard-nav .single-item .main-area {
  position: absolute;
  top: 50px;
  width: 360px;
  right: 0;
  padding: 30px;
  background: var(--bs-white);
  box-shadow: 0px 20px 50px rgba(44, 63, 88, 0.15);
  border-radius: 20px;
  border-radius: 20px;
  transform: translateY(150px);
  opacity: 0;
  transition: 0.3s;
  visibility: hidden;
}

.header-section .navbar-area .dashboard-nav .single-item .main-area.active {
  opacity: 1;
  visibility: visible;
  transform: translateY(0px);
}

.header-section .navbar-area .dashboard-nav .single-item .main-area ul li {
  margin-top: 15px;
}

.header-section .navbar-area .dashboard-nav .single-item .main-area ul li i {
  margin-right: 10px;
}

.header-section .navbar-area .dashboard-nav .single-item .main-area ul li a {
  width: 100%;
}

.header-section .navbar-area .dashboard-nav .single-item .user-content .head-area {
  background: #F8F8FF;
  border-radius: 20px;
  padding: 15px;
}

.header-section .navbar-area .dashboard-nav .single-item .user-content .head-area .profile-img {
  margin-right: 20px;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area .notifications-btn {
  position: relative;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area .notifications-btn::before {
  content: '';
  position: absolute;
  background-color: #ED815B;
  width: 6px;
  height: 6px;
  border-radius: 50%;
  top: 6px;
  right: 0;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area .head-area span {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 16px;
  height: 16px;
  color: var(--bs-white);
  background: #902520;
  border-radius: 6px;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li {
  border-radius: 10px;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li:hover {
  background: #F8F8FF;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li a {
  width: 95%;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li .img-area {
  margin-right: 10px;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li .time-area {
  margin-top: 5px;
}

.header-section .navbar-area .dashboard-nav .single-item.notifications-area ul li i {
  color: #A5A5A5;
  margin-right: 0;
}

.header-section .navbar-area .dashboard-nav .single-item.language-area .language-content {
  max-height: 250px;
  overflow-y: scroll;
}

.header-section .navbar-area .dashboard-nav .single-item.language-area .language-content li {
  font-size: 14px;
  padding: 5px 10px;
  transition: 0.3s;
}

.header-section .navbar-area .dashboard-nav .single-item.language-area .language-content li:hover, .header-section .navbar-area .dashboard-nav .single-item.language-area .language-content li.active {
  background-color: #6C3AFF;
  color: var(--bs-white);
}

.header-section .sidebar-wrapper {
  position: absolute;
  top: 0;
  width: 150px;
  left: -220px;
  padding: 20px;
  background: var(--bs-white);
  box-shadow: 0px 20px 50px rgba(44, 63, 88, 0.15);
  transform: translateX(150px);
  transition: 0.3s;
  height: 100vh;
  overflow-y: scroll;
}

.header-section .sidebar-wrapper.active {
  opacity: 1;
  left: -140px;
  visibility: visible;
  transform: translateX(0px);
}

.header-section .sidebar-wrapper::-webkit-scrollbar {
  width: 0;
}

.header-section .sidebar-wrapper .close-btn {
  display: none;
  cursor: pointer;
}

.header-section .sidebar-wrapper .close-btn i {
  position: absolute;
  right: 10px;
  top: 10px;
  color: #4341cc;
  font-size: 24px;
}

.header-section .sidebar-wrapper .sidebar-logo {
  margin-bottom: 20px;
}

.header-section .sidebar-wrapper ul li {
  border-radius: 20px;
  padding: 15px 10px;
  transition: 0.3s;
}

.header-section .sidebar-wrapper ul li a {
  display: flex;
  align-items: center;
  justify-content: center;
}

.header-section .sidebar-wrapper ul li span {
  display: none;
}

.header-section .sidebar-wrapper ul li:hover, .header-section .sidebar-wrapper ul li.active {
  background: #F6F5FF;
}

.header-section .sidebar-wrapper ul li img {
  margin-right: 0;
  width: 35%;
}

.header-section .sidebar-wrapper .bottom-item {
  border-top: 1px solid #E4E2EE;
  margin-top: 10px;
  padding-top: 10px;
}

.header-section .sidebar-wrapper .invite-now {
  border: 1px solid #E4E2EE;
  padding: 20px;
  background: var(--bs-white);
  border: 1px solid #DFDFDF;
  border-radius: 20px;
  text-align: center;
  display: none;
}

.header-section .sidebar-wrapper .invite-now p {
  margin: 15px 0 25px;
}

.header-section .sidebar-wrapper .invite-now .cmn-btn {
  border-radius: 25px;
  width: 100%;
}

.header-section.body-collapse {
  margin-left: 270px;
  width: calc(100% - 270px);
}

.header-section.body-collapse .sidebar-wrapper {
  width: 270px;
  left: -420px;
}

.header-section.body-collapse .sidebar-wrapper ul li span {
  display: block;
}

.header-section.body-collapse .sidebar-wrapper ul li img {
  width: auto;
  margin-right: 10px;
}

.header-section.body-collapse .sidebar-wrapper ul li a {
  justify-content: start;
}

.header-section.body-collapse .sidebar-wrapper .invite-now {
  display: block;
}

.dashboard-section {
  padding-left: 30px;
  padding-right: 30px;
  padding-bottom: 40px;
  margin-left: 140px;
  width: calc(100% - 140px);
  transition: all 0.8s;
}

.dashboard-section.body-collapse {
  width: calc(100% - 270px);
  margin-left: 270px;
}

.dashboard-section .section-content {
  position: sticky;
  top: 0;
}

.dashboard-section .dropdown-area {
  position: relative;
}

.dashboard-section .dropdown-area button {
  background-color: transparent;
}

.dashboard-section .dropdown-area .dropdown-menu {
  transition: all 0.3s;
  transform: translate(-160px, 100px) !important;
  display: block;
  overflow: hidden;
  opacity: 0;
  min-width: 190px;
  inset: 0px auto auto 0px !important;
}

.dashboard-section .dropdown-area .dropdown-menu.show {
  transition: all 0.3s;
  opacity: 1;
  transform: translate(-160px, 40px) !important;
}

.dashboard-section .dropdown-area .dropdown-menu li a:hover {
  background-color: #6C3AFF;
  color: var(--bs-white);
}

.dashboard-section .acc-details {
  background: rgb(43 107 127 / var(--tw-bg-opacity, 1));
  border-radius: 10px;
}

.dashboard-section .acc-details .top-area {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 30px;
}

.dashboard-section .acc-details .top-area h5,
.dashboard-section .acc-details .top-area h2,
.dashboard-section .acc-details .top-area h4 {
  color: var(--bs-white);
}

.dashboard-section .acc-details .top-area h2 {
  margin: 25px 0 15px;
}

.dashboard-section .acc-details .top-area .receive {
  color: #d8dcff;
}

.dashboard-section .acc-details .top-area .receive span {
  color: #0c266c;
  font-size: inherit;
  font-weight: inherit;
}

.dashboard-section .acc-details .top-area .nice-select {
  border-radius: 10px;
  border: none;
  background-color: transparent;
  padding: 10px 25px;
  color: var(--bs-white);
  display: flex;
  align-items: center;
}

.dashboard-section .acc-details .top-area .nice-select::after {
  border-bottom: 2px solid var(--bs-white);
  border-right: 2px solid var(--bs-white);
  height: 8px;
  width: 8px;
  right: 14px;
  top: initial;
}

.dashboard-section .acc-details .top-area .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  color: var(--bs-white);
  font-weight: 600;
}

.dashboard-section .acc-details .top-area .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}

.dashboard-section .acc-details .top-area .nice-select .list {
  width: 100%;
}

.dashboard-section .acc-details .top-area .right-top {
  display: flex;
  justify-content: end;
  align-items: center;
}

.dashboard-section .acc-details .top-area .right-bottom h4 {
  margin: 25px 0 15px;
}

.dashboard-section .acc-details .top-area .right-bottom h5 {
  color: #0c266c;
}

.dashboard-section .acc-details .bottom-area {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background: rgb(43 107 127 / var(--tw-bg-opacity, 3));;
  padding: 15px;
  margin-top: 40px;
  border-radius: 10px;
}

.dashboard-section .acc-details .bottom-area .left-side {
  margin-bottom: -15px;
}

.dashboard-section .acc-details .bottom-area .cmn-btn {
  margin-bottom: 15px;
  margin-right: 15px;
  background-color: transparent;
  border: 1px solid var(--border-color);
  color: var(--bs-white);
}

.dashboard-section .acc-details .bottom-area .cmn-btn:hover {
  background-color: var(--primary-color);
}

.dashboard-section .transactions-area {
  background: var(--bs-white);
  border-radius: 10px;
}

.dashboard-section .transactions-area .section-text {
  padding: 30px;
  border-bottom: 1px solid #EFEFEF;
  margin-bottom: 25px;
}

.dashboard-section .transactions-area .section-text h5 {
  font-weight: 600;
}

.dashboard-section .transactions-area .top-area {
  padding: 0 30px;
}

.dashboard-section .transactions-area .top-area ul {
  border: none;
}

.dashboard-section .transactions-area .top-area ul li .nav-link {
  color: #696D8D;
  padding: 0;
  border-color: transparent;
  font-weight: 700;
  padding-right: 15px;
}

.dashboard-section .transactions-area .top-area ul li .nav-link.active {
  color: #5B2EDF;
}

.dashboard-section .transactions-area .top-area .view-all {
  color: #5B2EDF;
}

.dashboard-section .transactions-area .top-area .view-all img {
  margin-left: 5px;
}

.dashboard-section .transactions-area .table-responsive tr {
  text-align: center;
  border-top: 1px solid #EFEFEF;
}

.dashboard-section .transactions-area .table-responsive tr th {
  padding: 15px 30px;
}

.dashboard-section .transactions-area .table-responsive tr th p:first-child {
  font-weight: 700;
}

.dashboard-section .transactions-area .table-responsive tr td {
  vertical-align: middle;
}

.dashboard-section .transactions-area .table-responsive tr td p:first-child {
  font-weight: 700;
}

.dashboard-section .transactions-area .table-responsive thead {
  background: #F6F5FF;
}

.dashboard-section .transactions-area .table-responsive thead tr th {
  color: #696D8D;
  font-weight: 400;
}

.dashboard-section .transactions-area .table-responsive thead tr th:first-child {
  text-align: start;
  width: 35%;
}

.dashboard-section .transactions-area .table-responsive tbody {
  border: none;
}

.dashboard-section .transactions-area .table-responsive tbody tr th:first-child {
  text-align: start;
}

.dashboard-section .transactions-area .table-responsive tbody tr .cancelled {
  color: #E9687F;
}

.dashboard-section .transactions-area .table-responsive tbody tr .completed {
  color: #49C96D;
}

.dashboard-section .transactions-area .table-responsive tbody tr .pending {
  color: #F7A94A;
}

.dashboard-section .transactions-area .table-responsive tbody tr .inprogress {
  color: #DBAF14;
}

.dashboard-section .side-items .single-item {
  background: var(--bs-white);
  border-radius: 10px;
  padding: 30px;
  margin-bottom: 30px;
}

.dashboard-section .side-items .single-item:last-child {
  margin: 0;
}

.dashboard-section .side-items .single-item .section-text h6 {
  margin: 0;
  font-weight: 700;
}

.dashboard-section .side-items .single-item .single-card {
  margin-bottom: 20px;
}

.dashboard-section .side-items .single-item .single-card button {
  background-color: transparent;
  padding: 0;
}

.dashboard-section .side-items .single-item .add-card {
  background: var(--bs-white);
  border: 1px solid #EAE9F5;
  border-radius: 10px;
  height: 90px;
  display: flex;
  align-items: center;
}

.dashboard-section .side-items .single-item .add-card button {
  background-color: transparent;
  padding: 0;
}

.dashboard-section .side-items .single-item .view-all img {
  margin-left: 5px;
}

.dashboard-section .side-items .single-item .recipients-item li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 25px;
  padding-bottom: 25px;
  border-bottom: 1px solid #D4D7F4;
}

.dashboard-section .side-items .single-item .recipients-item li:last-child {
  margin: 0;
  padding: 0;
  border: none;
}

.dashboard-section .side-items .single-item .recipients-item li p .info {
  display: grid;
  margin-left: 10px;
}

.dashboard-section .side-items .single-item .recipients-item li p .info span:first-child {
  font-weight: 600;
}

.dashboard-section .side-items .single-item .recipients-item li p span {
  display: flex;
  align-items: center;
}

.dashboard-section .side-items .single-item .recipients-item li p.right span {
  justify-content: center;
}

.dashboard-section .side-items .single-item .recipients-item li p.right span:first-child {
  font-weight: 600;
  color: #49C96D;
}

.dashboard-section .side-items .single-item .recipients-item li p.right span.loss {
  color: red;
}

.dashboard-section.transactions .head-area {
  padding-bottom: 20px;
}

.dashboard-section.transactions .head-area h4 {
  font-weight: 700;
}

.dashboard-section.transactions .transactions-right form {
  margin-right: 15px;
}

.dashboard-section.transactions .transactions-right form .form-group {
  padding: 0 12px;
  background: #f9f9f9;
  border: 1px solid #d0d3e8;
  border-radius: 10px;
}

.dashboard-section.transactions .transactions-right form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
}

.dashboard-section.transactions .transactions-right a {
  font-weight: 700;
  color: #5B2EDF;
}

.dashboard-section.transactions .transactions-main {
  background: var(--bs-white);
  border-radius: 10px;
}

.dashboard-section.transactions .transactions-main .top-items {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border-bottom: 1px solid #EFEFEF;
  padding: 30px 30px 20px;
}

.dashboard-section.transactions .transactions-main .top-items h6 {
  font-weight: 700;
}

.dashboard-section.transactions .transactions-main .top-items li {
  margin-left: 15px;
}

.dashboard-section.transactions .transactions-main .top-items li a {
  display: flex;
  align-items: center;
}

.dashboard-section.transactions .transactions-main .top-items li a img {
  margin-right: 5px;
}

.dashboard-section.transactions .transactions-main .filters-item {
  display: flex;
  align-items: center;
  padding: 30px;
}

.dashboard-section.transactions .transactions-main .filters-item .single-item {
  margin-right: 15px;
}

.dashboard-section.transactions .transactions-main .filters-item .single-item button {
  font-weight: 700;
  color: #5B2EDF;
  background-color: transparent;
  border-left: 1px solid #E6E5FF;
  padding-left: 20px;
  margin-left: 10px;
}

.dashboard-section.transactions .transactions-main .filters-item .single-item .nice-select {
  border-radius: 10px;
}

.dashboard-section.transactions .transactions-main .filters-item .single-item .nice-select::after {
  height: 9px;
  width: 9px;
}

.dashboard-section.transactions .transactions-main .table-responsive tr {
  text-align: center;
  border-top: 1px solid #EFEFEF;
}

.dashboard-section.transactions .transactions-main .table-responsive tr th {
  padding: 15px 30px;
}

.dashboard-section.transactions .transactions-main .table-responsive tr th p:first-child {
  font-weight: 700;
}

.dashboard-section.transactions .transactions-main .table-responsive tr td {
  vertical-align: middle;
}

.dashboard-section.transactions .transactions-main .table-responsive tr td p:first-child {
  font-weight: 700;
}

.dashboard-section.transactions .transactions-main .table-responsive thead {
  background: #F6F5FF;
}

.dashboard-section.transactions .transactions-main .table-responsive thead tr th {
  color: #696D8D;
  font-weight: 400;
}

.dashboard-section.transactions .transactions-main .table-responsive thead tr th:first-child {
  text-align: start;
  width: 35%;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody {
  border: none;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody tr th:first-child {
  text-align: start;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody tr .cancelled {
  color: #E9687F;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody tr .completed {
  color: #49C96D;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody tr .pending {
  color: #F7A94A;
}

.dashboard-section.transactions .transactions-main .table-responsive tbody tr .inprogress {
  color: #DBAF14;
}

.dashboard-section.transactions.recipients .filters-item {
  background: #5732C6;
  padding: 20px 30px;
  gap: 20px;
}

.dashboard-section.transactions.recipients .filters-item .right-area {
  gap: 20px;
}

.dashboard-section.transactions.recipients .filters-item .search-area {
  width: 100%;
}

.dashboard-section.transactions.recipients .filters-item .single-item {
  padding: 8px 20px;
  background: #5F3DC4;
  border: 1px solid #6A4BC8;
  border-radius: 10px;
  margin-right: 0;
}

.dashboard-section.transactions.recipients .filters-item .single-item form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
  padding-top: 0;
  padding-bottom: 0;
  color: var(--bs-white);
}

.dashboard-section.transactions.recipients .filters-item .single-item form .form-group input::placeholder {
  color: #B2B9CB;
}

.dashboard-section.transactions.recipients .filters-item .single-item .nice-select {
  background-color: transparent;
  border: transparent;
  height: 30px;
  display: flex;
  align-items: center;
}

.dashboard-section.transactions.recipients .filters-item .single-item .nice-select .current {
  color: var(--bs-white);
}

.dashboard-section.transactions.recipients .filters-item .single-item button {
  margin: 0;
  padding: 0;
  border: none;
  color: var(--bs-white);
  font-weight: 400;
  display: flex;
  align-items: center;
}

.dashboard-section.transactions.recipients .filters-item .single-item button i {
  margin-right: 10px;
  font-size: 14px;
}

.dashboard-section.transactions.recipients .table-responsive tr:last-child {
  border-bottom: 1px solid #EFEFEF;
}

.dashboard-section.transactions.recipients .table-responsive th .info-area {
  display: flex;
  align-items: center;
}

.dashboard-section.transactions.recipients .table-responsive th .info-area .img-area {
  margin-right: 15px;
}

.dashboard-section.transactions.recipients .table-responsive th .info-area .img-area img {
  max-width: unset;
}

.dashboard-section.transactions.recipients .table-responsive .btn-item a {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  padding: 11px 45px;
}

.dashboard-section.pay .main-content {
  background: var(--bs-white);
  border-radius: 10px;
  padding: 30px;
}

.dashboard-section.pay .main-content .head-area {
  border-bottom: 1px solid #C3C2C8;
  margin-bottom: 20px;
  padding-bottom: 20px;
}

.dashboard-section.pay .main-content .head-area h4 {
  font-weight: 700;
}

.dashboard-section.pay .main-content .single-item {
  text-align: center;
  background: #F7F9FD;
  border-radius: 10px;
  padding: 20px;
  border: 1px solid transparent;
  margin-top: 20px;
  width: 100%;
  transition: 0.3s;
}

.dashboard-section.pay .main-content .single-item p {
  margin: 15px 0 10px;
  padding-bottom: 15px;
  border-bottom: 1px solid #CEDAF3;
}

.dashboard-section.pay .main-content .single-item:hover {
  border: 1px solid #6C3AFF;
}

.dashboard-section.pay.step .main-content .choose-recipient .step-area {
  margin-bottom: 20px;
}

.dashboard-section.pay.step .main-content .choose-recipient .step-area h5 {
  font-weight: 700;
  margin-top: 5px;
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list {
  margin-bottom: 40px;
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button {
  border-radius: 20px;
  padding: 25px 40px;
  margin-right: 30px;
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button .icon-area {
  width: 100%;
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button .icon-area i {
  color: #7D7F93;
  font-size: 35px;
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button.active, .dashboard-section.pay.step .main-content .choose-recipient .recipient-list button:hover {
  background: linear-gradient(117.39deg, #5732C6 13.65%, #9A79FD 105.93%);
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button.active i, .dashboard-section.pay.step .main-content .choose-recipient .recipient-list button:hover i {
  color: var(--bs-white);
}

.dashboard-section.pay.step .main-content .choose-recipient .recipient-list button.active span, .dashboard-section.pay.step .main-content .choose-recipient .recipient-list button:hover span {
  color: var(--bs-white);
}

.dashboard-section.pay.step .main-content .user-select .single-user {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border-top: 1px solid #EFEFEF;
  padding: 20px 0;
}

.dashboard-section.pay.step .main-content .user-select .single-user:last-child {
  border-bottom: 1px solid #EFEFEF;
}

.dashboard-section.pay.step .main-content .user-select .text-area {
  margin-left: 15px;
}

.dashboard-section.pay.step .main-content .user-select .text-area p {
  font-weight: 700;
}

.dashboard-section.pay.step .main-content .user-select .text-area .last-payment {
  border-top: 1px dashed #BABABA;
  display: block;
  padding-top: 10px;
  margin-top: 10px;
  font-size: 14px;
}

.dashboard-section.pay.step .main-content .user-select .right a {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  padding: 14px 60px;
  display: flex;
  align-items: center;
  position: relative;
  transition: 0.3s;
}

.dashboard-section.pay.step .main-content .user-select .right a:hover {
  background: #5732C6;
  color: var(--bs-white);
}

.dashboard-section.pay.step .main-content .user-select .right a:hover::before {
  position: absolute;
  content: "\0047";
  font-family: 'arafat font';
  left: 35px;
}

.dashboard-section.pay.step .main-content form {
  margin-top: 40px;
  margin-bottom: 20px;
}

.dashboard-section.pay.step .main-content form .form-group {
  padding: 0 12px;
  background: #f9f9f9;
  border: 1px solid #d0d3e8;
  border-radius: 10px;
}

.dashboard-section.pay.step .main-content form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
}

.dashboard-section.pay.step-2 .main-content .user-select .right {
  display: flex;
  align-items: center;
}

.dashboard-section.pay.step-2 .main-content .user-select .right a {
  padding: 12px 45px;
  margin-left: 15px;
  justify-content: center;
}

.dashboard-section.pay.step-2 .main-content .user-select .right a i {
  margin-right: 10px;
}

.dashboard-section.pay.step-2 .main-content .user-select .right a:hover::before {
  display: none;
}

.dashboard-section.pay.step-2 .main-content .send-banance {
  background: #F8F8FF;
  border-radius: 10px;
  padding: 30px;
  margin-top: 30px;
}

.dashboard-section.pay.step-2 .main-content .send-banance p b {
  margin-left: 10px;
}

.dashboard-section.pay.step-2 .main-content .send-banance .input-area {
  display: flex;
  align-items: center;
  padding: 15px 20px;
  border: 1px solid #ACB1C8;
  border-radius: 20px;
  margin: 10px 0;
}

.dashboard-section.pay.step-2 .main-content .send-banance .input-area input {
  padding: 0;
  padding-right: 25px;
  margin: 0;
  border: none;
  background-color: transparent;
  font-weight: bold;
}

.dashboard-section.pay.step-2 .main-content .send-banance .nice-select {
  border-radius: 10px;
  border: none;
  background-color: transparent;
  padding: 10px 25px;
  color: var(--bs-white);
  display: flex;
  align-items: center;
}

.dashboard-section.pay.step-2 .main-content .send-banance .nice-select::after {
  border-bottom: 2px solid #000000;
  border-right: 2px solid #000000;
  height: 8px;
  width: 8px;
  right: 14px;
  top: initial;
}

.dashboard-section.pay.step-2 .main-content .send-banance .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  font-weight: 600;
}

.dashboard-section.pay.step-2 .main-content .send-banance .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}

.dashboard-section.pay.step-2 .main-content .send-banance .nice-select .list {
  width: 100%;
}

.dashboard-section.pay.step-2 .main-content .exchange-content {
  display: flex;
  align-items: center;
  gap: 15px;
}

.dashboard-section.pay.step-2 .main-content .exchange-content .send-banance {
  width: 100%;
}

.dashboard-section.pay.step-2 .main-content .exchange-content .recipient {
  background: #F1ECFF;
  position: relative;
  display: grid;
  align-items: center;
}

.dashboard-section.pay.step-2 .main-content .exchange-content .recipient::before {
  position: absolute;
  content: '';
  width: 26px;
  height: 26px;
  left: -20px;
  z-index: 1;
  background-image: url(/images/icon/exchange-icon.png);
  background-repeat: no-repeat;
}

.dashboard-section.pay.step-2 .main-content .exchange-content .recipient::after {
  position: absolute;
  content: '';
  width: 50px;
  height: 50px;
  left: -30px;
  background-color: #5732C6;
  border: 6px solid var(--bs-white);
  border-radius: 25px;
}

.dashboard-section.pay.step-2 .main-content .exchange-content .recipient .nice-select .current::before {
  background-image: url(/images/icon/flag-bd.png);
}

.dashboard-section.pay.step-2 .main-content .pay-option {
  background: #F8F8FF;
  display: flex;
  margin-top: 20px;
  align-items: center;
  justify-content: space-between;
}

.dashboard-section.pay.step-2 .main-content .pay-option h6 {
  margin: 0;
  font-weight: 700;
}

.dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 10px 20px;
  width: 100%;
}

.dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single .nice-select {
  height: 50px;
  padding-right: 60px;
  display: flex;
  align-items: center;
}

.dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single .nice-select::after {
  height: 9px;
  width: 9px;
}

.dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single.border-area {
  border-left: 1px solid #E5DCDC;
}

.dashboard-section.pay.step-2 .main-content .pay-details ul {
  border-bottom: 1px solid #EFEFEF;
  margin-bottom: 30px;
  padding-bottom: 20px;
}

.dashboard-section.pay.step-2 .main-content .pay-details ul li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 20px;
}

.dashboard-section.pay.step-2 .main-content .pay-details ul li p {
  font-weight: 700;
}

.dashboard-section.pay.step-2 .main-content .pay-details .tatal-pay .single {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 20px;
}

.dashboard-section.pay.step-2 .main-content .pay-details .tatal-pay .single h5, .dashboard-section.pay.step-2 .main-content .pay-details .tatal-pay .single p {
  font-weight: 700;
}

.dashboard-section.pay.step-2 .main-content .total-fees {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 30px;
  border-bottom: 1px solid #EFEFEF;
}

.dashboard-section.pay.step-2 .main-content .total-fees h5 {
  font-weight: 600;
}

.dashboard-section.pay.step-2 .main-content .total-fees.pay {
  border: none;
}

.dashboard-section.pay.step-3 .payment-details {
  border: 1px solid #B6B4D4;
  border-radius: 10px;
  padding: 30px;
  padding-top: 20px;
}

.dashboard-section.pay.step-3 .payment-details .top-area {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding-bottom: 20px;
  border-bottom: 1px solid #B6B4D5;
}

.dashboard-section.pay.step-3 .payment-details .top-area h6 {
  font-weight: 700;
}

.dashboard-section.pay.step-3 .payment-details .top-area a {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  padding: 12px 45px;
  transition: 0.3s;
}

.dashboard-section.pay.step-3 .payment-details .top-area a:hover {
  background: #5732C6;
  color: var(--bs-white);
}

.dashboard-section.pay.step-3 .payment-details .details-list li {
  display: flex;
  align-items: center;
  margin-top: 20px;
}

.dashboard-section.pay.step-3 .payment-details .details-list li span {
  width: 50%;
}

.dashboard-section.pay.step-3 .main-content form {
  text-align: center;
  margin-top: 30px;
}

.dashboard-section.pay.step-3 .main-content form label {
  font-weight: 500;
}

.dashboard-section.pay.receive-2 .input-field {
  background: #F8F8FF;
  border-radius: 10px;
  padding: 30px;
  padding-top: 10px;
  margin-top: 30px;
  margin-left: 0;
  margin-right: 0;
}

.dashboard-section.pay.receive-2 .input-field .single-input {
  margin-top: 20px;
}

.dashboard-section.pay.receive-2 .input-field .single-input input {
  background: #F8F8FF;
  border: 1px solid #D0D3E8;
}

.dashboard-section.pay.receive-3 .attach-documents {
  border: 1px solid #B6B4D4;
  border-radius: 10px;
  padding: 30px;
  padding-top: 20px;
  margin-top: 20px;
}

.dashboard-section.pay.receive-3 .attach-documents h6 {
  border-bottom: 1px solid #B6B4D5;
  padding-bottom: 30px;
  margin-bottom: 20px;
  font-weight: 700;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload {
  border: 1px dashed #C4BEE4;
  border-radius: 20px;
  margin-top: 20px;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload input {
  margin: 0;
  opacity: 0;
  visibility: hidden;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file {
  cursor: pointer;
  position: relative;
  margin-bottom: 45px;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom {
  position: absolute;
  top: 0;
  height: 105px;
  display: flex;
  align-items: center;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom::before {
  position: absolute;
  left: 0;
  background-image: url(/images/icon/upload-icons.png);
  background-repeat: no-repeat;
  content: "";
  width: 70px;
  height: 70px;
  left: 20px;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
  position: relative;
  width: 205%;
  display: flex;
  z-index: 5;
  top: -5px;
  left: 25%;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
  content: "DRAG FILES HERE OR BROWSE";
  position: absolute;
  left: 0;
  top: -30px;
}

.dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
  content: "Supported file types: PDF, DOC, DOCX, JPEG,JPG,BMP,XLS and XLSX ( Upload up to 10 MB)";
  position: absolute;
  left: 0;
  bottom: -30px;
}

.dashboard-section.pay.receive-3 .request-submitted .top-area {
  border: 1px solid #C3C2C8;
  box-sizing: border-box;
  border-radius: 20px;
  padding: 30px;
}

.dashboard-section.pay.receive-3 .request-submitted .top-area h3 {
  margin: 25px 0 15px;
  font-weight: 700;
}

.dashboard-section.pay.receive-3 .request-submitted .top-area h5 {
  border-top: 1px solid #B5B7C8;
  font-weight: 700;
  padding-top: 20px;
  margin-top: 30px;
}

.dashboard-section.pay.receive-3 .request-submitted .share-link {
  margin-top: 30px;
}

.dashboard-section.pay.receive-3 .request-submitted .share-link ul {
  margin-top: 15px;
}

.dashboard-section.pay.receive-3 .request-submitted .share-link ul li a {
  margin: 0 15px;
}

.dashboard-section.pay.crypto .main-content .single-item {
  padding: 30px;
}

.dashboard-section.pay.crypto .main-content .single-item span {
  font-weight: 700;
  margin-top: 20px;
}

.dashboard-section .footer-area {
  display: flex;
  justify-content: center;
}

.dashboard-section .footer-area a {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  margin: 0 10px;
  padding: 12px 40px;
  transition: 0.3s;
}

.dashboard-section .footer-area a:hover {
  background: #5732C6;
  color: var(--bs-white);
}

.dashboard-section .footer-area a.active {
  background: #5732C6;
  color: var(--bs-white);
}

.dashboard-section .footer-area a.active:hover {
  background: #F7F9FD;
  color: var(--para-color);
  border: 1px solid #DDE8FF;
}

.dashboard-section.exchange {
  overflow-x: initial;
}

.dashboard-section.exchange .nav-tabs {
  border: none;
}

.dashboard-section.exchange .recipient-list button {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
}

.dashboard-section.exchange .tab-content .section-head h5 {
  margin-bottom: 10px;
  font-weight: 600;
}

.dashboard-section.exchange .tab-content form .single-input {
  margin-bottom: 30px;
}

.dashboard-section.exchange .tab-content form .single-input .select-area, .dashboard-section.exchange .tab-content form .single-input input {
  background: #F9F9F9;
  border: 1px solid #D0D3E8;
  border-radius: 10px;
}

.dashboard-section.exchange .tab-content form .single-input .select-area .nice-select, .dashboard-section.exchange .tab-content form .single-input input .nice-select {
  border: none;
  display: flex;
  align-items: center;
}

.dashboard-section.exchange .tab-content form .single-input .select-area input {
  border: none;
  border-left: 1px solid #D0D3E8;
  border-top-left-radius: 0;
  border-bottom-left-radius: 0;
}

.dashboard-section.exchange .tab-content form .single-input .nice-select {
  float: initial;
  background: #F9F9F9;
  border: 1px solid #D0D3E8;
  border-radius: 10px;
  line-height: 50px;
  height: 50px;
}

.dashboard-section.exchange .tab-content form .single-input .nice-select::after {
  width: 9px;
  height: 9px;
}

.dashboard-section.exchange .tab-content form .single-input .nice-select .list {
  width: 100%;
}

.dashboard-section.exchange .side-area {
  border: 1px solid #C8C5DE;
  border-radius: 20px;
  padding: 30px;
  position: sticky;
  top: 100px;
}

.dashboard-section.exchange .side-area .title-area {
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.dashboard-section.exchange .side-area .title-area h5 {
  font-weight: 700;
}

.dashboard-section.exchange .side-area .title-area .flag-area {
  display: flex;
}

.dashboard-section.exchange .side-area .title-area .flag-area img {
  margin-right: -10px;
  max-width: unset;
}

.dashboard-section.exchange .side-area .deposit-details {
  border-top: 1px solid #C8C5DE;
  margin-top: 20px;
}

.dashboard-section.exchange .side-area .deposit-details li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding-top: 15px;
}

.dashboard-section.exchange .details-list li span {
  text-align: start;
}

.dashboard-section.crypto .left-area {
  position: sticky;
  top: 100px;
}

.dashboard-section.crypto .left-area ul {
  position: sticky;
  top: 100px;
}

.dashboard-section.crypto .left-area ul li {
  position: relative;
  display: flex;
  align-items: center;
  margin-bottom: 45px;
}

.dashboard-section.crypto .left-area ul li a {
  margin-left: 45px;
  padding: 0;
  color: #777E90;
  border: none;
}

.dashboard-section.crypto .left-area ul li a::after {
  position: absolute;
  content: '';
  width: 30px;
  bottom: -25px;
  height: 0;
  left: 0;
  transform: rotate(90deg);
  border-bottom: 1px dashed #777E91;
}

.dashboard-section.crypto .left-area ul li a::before {
  position: absolute;
  content: '1';
  width: 30px;
  height: 30px;
  left: 0;
  text-align: center;
  color: #777E90;
  border: 2px solid #E6E8EC;
  border-radius: 36px;
}

.dashboard-section.crypto .left-area ul li a.two::before {
  content: '2';
}

.dashboard-section.crypto .left-area ul li a.three::before {
  content: '3';
}

.dashboard-section.crypto .left-area ul li a.last::before {
  content: '4';
}

.dashboard-section.crypto .left-area ul li a.last::after {
  display: none;
}

.dashboard-section.crypto .left-area ul li a.active button {
  color: #23262F;
  font-weight: 600;
}

.dashboard-section.crypto .left-area ul li a.active::before {
  position: absolute;
  content: '\f00c';
  font-family: 'font awesome 6 free';
  width: 30px;
  height: 30px;
  text-align: center;
  left: 0;
  background-color: #5B2EDF;
  border: none;
  border-radius: 36px;
  font-weight: 600;
  color: var(--bs-white);
}

.dashboard-section.crypto .table-area {
  padding: 40px;
  background: #FCFCFD;
  border-radius: 16px;
}

.dashboard-section.crypto .table-area form {
  margin-top: 20px;
}

.dashboard-section.crypto .table-area form .form-group {
  padding: 0 12px;
  background: #f9f9f9;
  border: 1px solid #d0d3e8;
  border-radius: 10px;
}

.dashboard-section.crypto .table-area form .form-group input {
  background-color: transparent;
  border: none;
  padding-left: 10px;
}

.dashboard-section.crypto .table-area form .form-group button {
  padding: 0;
  background-color: transparent;
}

.dashboard-section.crypto .table-area th, .dashboard-section.crypto .table-area td {
  padding: 16px;
}

.dashboard-section.crypto .table-area thead {
  border-bottom: 1px solid #E6E8EC;
}

.dashboard-section.crypto .table-area thead th {
  color: #777E90;
  font-size: 14px;
}

.dashboard-section.crypto .table-area tbody {
  border: none;
}

.dashboard-section.crypto .table-area tbody .highlight {
  color: #FF6838;
}

.dashboard-section.crypto .table-area tbody tr {
  border: none;
}

.dashboard-section.crypto .table-area tbody tr:hover {
  background: #F4F5F6;
}

.dashboard-section.crypto .table-area tbody tr:hover i {
  color: #FFD166;
}

.dashboard-section.crypto .table-area tbody tr i {
  color: #777E90;
  margin-right: 5px;
}

.dashboard-section.crypto .table-area tbody tr td .crypto-logo {
  display: flex;
  align-items: center;
}

.dashboard-section.crypto .table-area tbody tr td .crypto-logo img {
  margin-right: 10px;
}

.dashboard-section.crypto .table-area tbody tr td p {
  color: #23262F;
  font-weight: 600;
  font-size: 14px;
}

.dashboard-section.crypto .table-area tbody tr td:last-child .highlight {
  color: #FF6838;
}

.dashboard-section.crypto .table-area tbody tr td:last-child p {
  color: #58BD7D;
}

.dashboard-section.crypto .exchange-content .send-banance {
  background: #F8F8FF;
  border-radius: 10px;
  padding: 30px;
  margin-top: 20px;
}

.dashboard-section.crypto .exchange-content .send-banance p b {
  margin-left: 10px;
}

.dashboard-section.crypto .exchange-content .send-banance .input-area {
  display: flex;
  align-items: center;
  padding: 15px 20px;
  border: 1px solid #ACB1C8;
  border-radius: 20px;
  margin: 10px 0;
}

.dashboard-section.crypto .exchange-content .send-banance .input-area input {
  padding: 0;
  margin-top: 0;
  padding-right: 25px;
  border: none;
  background-color: transparent;
  font-weight: bold;
}

.dashboard-section.crypto .exchange-content .send-banance .nice-select {
  border-radius: 10px;
  border: none;
  background-color: transparent;
  padding: 10px 25px;
  color: var(--bs-white);
  display: flex;
  align-items: center;
}

.dashboard-section.crypto .exchange-content .send-banance .nice-select::after {
  border-bottom: 2px solid #000000;
  border-right: 2px solid #000000;
  height: 8px;
  width: 8px;
  right: 14px;
  top: initial;
}

.dashboard-section.crypto .exchange-content .send-banance .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  font-weight: 600;
}

.dashboard-section.crypto .exchange-content .send-banance .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}

.dashboard-section.crypto .exchange-content .send-banance .nice-select .list {
  width: 100%;
}

.dashboard-section.crypto .exchange-content .recipient {
  background: #F1ECFF;
  position: relative;
  display: grid;
  align-items: center;
}

.dashboard-section.crypto .exchange-content .recipient::before {
  position: absolute;
  content: '';
  width: 26px;
  height: 26px;
  top: -22px;
  left: calc(50% - -12px);
  z-index: 1;
  background-image: url(/images/icon/exchange-icon.png);
  background-repeat: no-repeat;
}

.dashboard-section.crypto .exchange-content .recipient::after {
  position: absolute;
  content: '';
  width: 50px;
  height: 50px;
  left: calc(50%);
  top: -35px;
  background-color: #5732C6;
  border: 6px solid var(--bs-white);
  border-radius: 25px;
}

.dashboard-section.crypto .exchange-content .recipient .nice-select .current::before {
  background-image: url(/images/icon/flag-btc.png);
}

.dashboard-section.crypto .exchange-content .pay-details ul {
  margin-bottom: 30px;
}

.dashboard-section.crypto .exchange-content .pay-details ul li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 20px;
}

.dashboard-section.crypto .exchange-content .pay-details ul li p {
  font-weight: 700;
}

.dashboard-section.crypto .exchange-content .pay-details .tatal-pay .single {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 20px;
}

.dashboard-section.crypto .exchange-content .pay-details .tatal-pay .single h5, .dashboard-section.crypto .exchange-content .pay-details .tatal-pay .single p {
  font-weight: 700;
}

.dashboard-section.crypto .spend-get {
  padding: 25px 40px;
  background: #F4F5F6;
  border-radius: 16px;
  margin-bottom: 30px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.dashboard-section.crypto .spend-get .single-spend-get {
  display: flex;
  align-items: center;
}

.dashboard-section.crypto .spend-get .single-spend-get .img-area {
  width: 40px;
  height: 40px;
  background: #9757D7;
  border-radius: 40px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-right: 15px;
}

.dashboard-section.crypto .spend-get .single-spend-get .text-area span {
  font-weight: 700;
}

.dashboard-section.crypto .spend-get .single-spend-get.get .img-area {
  background: #58BD7D;
}

.dashboard-section.crypto .spend-get .single-spend-get.method .img-area {
  background: #4BC9F0;
}

.dashboard-section.crypto .checkbox-single {
  position: relative;
  padding-left: 40px;
  margin-bottom: 20px;
  padding: 30px;
  cursor: pointer;
  user-select: none;
  border: 1px solid #F4F5F6;
  border-radius: 20px;
}

.dashboard-section.crypto .checkbox-single:hover, .dashboard-section.crypto .checkbox-single.active {
  border: 1px solid #5B2EDF;
}

.dashboard-section.crypto .checkbox-single:last-child {
  margin-bottom: 0;
}

.dashboard-section.crypto .checkbox-single .left-area {
  display: flex;
  align-items: center;
}

.dashboard-section.crypto .checkbox-single .checkbox-area {
  align-items: center;
}

.dashboard-section.crypto .checkbox-single .checkbox-area input {
  position: absolute;
  opacity: 0;
  cursor: pointer;
  height: 0;
  width: 0;
}

.dashboard-section.crypto .checkbox-single .checkbox-area .checkmark {
  position: absolute;
  left: 0;
  height: 40px;
  width: 40px;
  border-radius: 20px;
  background: #F4F5F6;
}

.dashboard-section.crypto .checkbox-single .checkbox-area .checkmark::after {
  content: "";
  position: absolute;
  display: none;
}

.dashboard-section.crypto .checkbox-single .checkmark {
  display: flex;
  align-items: center;
  justify-content: center;
}

.dashboard-section.crypto .checkbox-single .checkmark::after {
  width: 16px;
  height: 16px;
  background-image: url(/images/icon/check.png);
  background-repeat: no-repeat;
}

.dashboard-section.crypto .checkbox-single input:checked ~ .checkmark {
  background: #571ce0;
}

.dashboard-section.crypto .checkbox-single input:checked ~ .checkmark:after {
  display: block;
}

.dashboard-section.crypto .checkbox-single .item-title span {
  font-weight: 700;
  margin-right: 15px;
}

.dashboard-section.crypto .checkbox-single .item-title .img-area {
  margin-left: 70px;
  width: 62px;
  height: 62px;
  background: #F4F5F6;
  border-radius: 31px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.dashboard-section.crypto .fee-area {
  margin-top: 30px;
}

.dashboard-section.crypto .fee-area ul li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-top: 10px;
}

.dashboard-section.crypto .fee-area .fee {
  margin-top: 10px;
  border-top: 1px solid #E6E8EC;
}

.dashboard-section.deposit-money .table-area {
  border: 1px solid #CADBFC;
  border-radius: 10px;
}

.dashboard-section.deposit-money .card-area {
  position: relative;
  gap: 30px;
  width: 80%;
}

.dashboard-section.deposit-money .card-area input {
  position: absolute;
  opacity: 0;
  display: none;
  width: 0;
  height: 0;
}

.dashboard-section.deposit-money .card-area input[type=radio] + label {
  position: relative;
  width: 100%;
  transition: 0.3s all;
  position: relative;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
}

.dashboard-section.deposit-money .card-area input[type=radio] + label img {
  width: 100%;
}

.dashboard-section.deposit-money .card-area input[type=radio]:checked + label::before {
  position: absolute;
  content: '';
  width: 16px;
  height: 16px;
  background-image: url(/images/icon/check-2.png);
  background-repeat: no-repeat;
  z-index: 2;
}

.dashboard-section.deposit-money .card-area input[type=radio]:checked + label::after {
  position: absolute;
  content: '';
  width: 32px;
  height: 32px;
  border-radius: 50%;
  background-color: var(--bs-white);
  z-index: 1;
}

.dashboard-section.deposit-money .card-area input[type=radio]:checked + label .wrapper::after {
  position: absolute;
  content: '';
  width: 100%;
  height: 100%;
  background: #0A2843;
  border-radius: 10px;
  opacity: 0.7;
  top: 0;
  left: 0;
  z-index: 1;
}

.dashboard-section.deposit-money form {
  margin: 0 !important;
}

.dashboard-section.deposit-money .send-banance p b {
  margin-left: 10px;
}

.dashboard-section.deposit-money .send-banance .input-area {
  display: flex;
  align-items: center;
  padding: 15px 20px;
  border: 1px solid #ACB1C8;
  border-radius: 20px;
  margin: 10px 0;
}

.dashboard-section.deposit-money .send-banance .input-area input {
  padding: 0;
  padding-right: 25px;
  margin: 0;
  border: none;
  background-color: transparent;
  font-weight: bold;
}

.dashboard-section.deposit-money .send-banance .nice-select {
  border-radius: 10px;
  border: none;
  background-color: transparent;
  padding: 10px 25px;
  color: var(--bs-white);
  display: flex;
  align-items: center;
}

.dashboard-section.deposit-money .send-banance .nice-select::after {
  border-bottom: 2px solid #000000;
  border-right: 2px solid #000000;
  height: 8px;
  width: 8px;
  right: 14px;
  top: initial;
}

.dashboard-section.deposit-money .send-banance .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  font-weight: 600;
}

.dashboard-section.deposit-money .send-banance .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}

.dashboard-section.deposit-money .send-banance .nice-select .list {
  width: 100%;
}

.dashboard-section.deposit-money .details-list li {
  display: flex;
  align-items: center;
  margin-top: 20px;
}

.dashboard-section.deposit-money .details-list li span {
  text-align: start;
}

.dashboard-section.deposit-money .checkbox-area label {
  font-weight: 600;
  margin-left: 10px;
}

.dashboard-section.deposit-money .checkbox-area label a {
  color: #5732C6;
  font-weight: 600;
}

.dashboard-section.withdraw-money .head-item h6 {
  font-weight: 700;
  margin-bottom: 30px;
}

.dashboard-section.withdraw-money .table-area {
  padding: 30px;
}

.dashboard-section.account {
  position: relative;
  overflow-x: initial;
}

.dashboard-section.account::before {
  content: "";
  position: absolute;
  background: #5732C6;
  top: 0;
  left: 0;
  height: 270px;
  z-index: -1;
  width: 100%;
}

.dashboard-section.account .owner-details {
  background: var(--bs-white);
  box-shadow: 0px 4px 26px rgba(165, 163, 235, 0.25);
  border-radius: 10px;
  padding: 30px 20px;
  text-align: center;
  position: sticky;
  top: 100px;
}

.dashboard-section.account .owner-details h6 {
  font-weight: 700;
  margin: 25px 0 15px;
}

.dashboard-section.account .owner-details .active-status {
  color: #378754;
}

.dashboard-section.account .owner-details ul {
  border-top: 1px solid #E8E8E8;
  margin-top: 15px;
}

.dashboard-section.account .owner-details ul li {
  margin-top: 15px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.dashboard-section.account .owner-details ul li span {
  color: #7D7F93;
}

.dashboard-section.account .owner-details .owner-action {
  margin-top: 20px;
}

.dashboard-section.account .owner-details .owner-action a {
  padding: 10px 15px;
  margin-top: 15px;
  font-weight: 700;
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 20px;
}

.dashboard-section.account .owner-details .owner-action a img {
  margin-right: 10px;
}

.dashboard-section.account .owner-details .owner-action a.delete {
  color: #D8481B;
}

.dashboard-section.account .tab-main {
  background: var(--bs-white);
  box-shadow: 0px 4px 26px rgba(165, 163, 235, 0.25);
  border-radius: 10px;
  padding: 30px;
}

.dashboard-section.account .nav-tabs {
  justify-content: space-between;
  border: none;
  margin-bottom: -20px;
}

.dashboard-section.account .nav-tabs .nav-link {
  padding: 13px 55px;
  background: #F7F9FD;
  color: #13216E;
  font-weight: 700;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  margin-bottom: 20px;
  transition: 0.3s;
}

.dashboard-section.account .nav-tabs .nav-link.active {
  color: var(--bs-white);
  background: #5927E3;
  box-shadow: 0px 8px 24px rgba(89, 39, 227, 0.42);
}

.dashboard-section.account .upload-avatar {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background: #F7F7FF;
  border-radius: 20px;
  padding: 30px;
  margin-bottom: 30px;
}

.dashboard-section.account .upload-avatar .instraction {
  margin-left: 20px;
}

.dashboard-section.account .upload-avatar .instraction h6 {
  margin: 0;
  font-weight: 700;
}

.dashboard-section.account .file-upload input {
  margin: 0;
  opacity: 0;
  visibility: hidden;
}

.dashboard-section.account .file-upload .file {
  cursor: pointer;
  position: relative;
}

.dashboard-section.account .file-upload .file .file-custom {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  display: flex;
  align-items: center;
}

.dashboard-section.account .file-upload .file .file-custom::before {
  content: "Upload new avatar";
  position: absolute;
  right: 0;
  top: 0;
  padding: 15px 30px;
  background: var(--bs-white);
  border: 1px solid #F2F3FB;
  border-radius: 10px;
}

.dashboard-section.account form .single-input {
  margin-bottom: 20px;
}

.dashboard-section.account form .file .file-custom {
  border: none;
}

.dashboard-section.account form span, .dashboard-section.account form input {
  background: #F8F8FF;
  border: 1px solid #D5CDEB;
  border-radius: 10px;
  padding: 10px 20px;
  width: 100%;
  font-weight: 600;
}

.dashboard-section.account form span {
  display: flex;
  align-items: center;
}

.dashboard-section.account form span img {
  margin-right: 10px;
}

.dashboard-section.account form .pending {
  color: #5834C6;
  border: 1px solid #5834C6;
}

.dashboard-section.account form .confirm {
  color: #1C6510;
  border: 1px solid #1C6510;
}

.dashboard-section.account form .notconfirm {
  color: #D8481B;
  border: 1px solid #D8481B;
}

.dashboard-section.account form .file-upload .file .file-custom::before {
  content: "Not uploaded";
  left: 0;
  padding: 12px 30px;
  background: #F8F8FF;
  border: 1px solid #D5CDEB;
}

.dashboard-section.account .single-content h5, .dashboard-section.account .change-pass h5 {
  margin-bottom: 20px;
  font-weight: 700;
}

.dashboard-section.account .single-content a, .dashboard-section.account .change-pass a {
  padding: 12px 30px;
  margin-top: 20px;
  background: var(--bs-white);
  border: 1px solid #DCDCFF;
  border-radius: 10px;
}

.dashboard-section.account .single-content {
  background: #F7F7FF;
  border-radius: 20px;
  padding: 30px;
  margin-bottom: 30px;
}

.dashboard-section.account .single-content button {
  padding: 12px 25px;
  font-weight: 600;
  background: var(--bs-white);
  box-shadow: 0px 8px 18px rgba(61, 32, 139, 0.1);
  border-radius: 10px;
  transition: 0.3s;
}

.dashboard-section.account .single-content button:hover, .dashboard-section.account .single-content button.active {
  background: #5927E3;
  color: var(--bs-white);
}

.dashboard-section.account .single-content .single-setting {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border-bottom: 1px solid #C7CADC;
  margin-bottom: 20px;
  padding-bottom: 20px;
}

.dashboard-section.account .single-content .single-setting h6 {
  font-weight: 600;
  margin: 0;
}

.dashboard-section.account .single-content .single-setting:last-child {
  margin-bottom: 0;
  padding-bottom: 0;
  border: none;
}

.dashboard-section.account .single-content.your-devices .left {
  display: flex;
  align-items: center;
}

.dashboard-section.account .single-content.your-devices .left .icon-area {
  margin-right: 15px;
}

.dashboard-section.account .single-content .head-item {
  margin-bottom: 30px;
}

.dashboard-section.account .single-content .head-item h5 {
  margin: 0;
}

.dashboard-section.account .single-content .head-item a {
  padding: 0;
  margin: 0;
  background: transparent;
  border: none;
  border-radius: 10px;
  color: #4E0DFF;
}

.dashboard-section.account .card-area {
  border: 1px solid #CADBFC;
  border-radius: 10px;
  padding: 30px;
}

.dashboard-section.account .card-area h6 {
  font-weight: 600;
  margin-bottom: 20px;
}

.dashboard-section.account .card-area .card-content {
  gap: 30px;
  width: 80%;
}

.dashboard-section.account .card-area button {
  padding: 0;
  border-radius: 20px;
}

.dashboard-section.account .notification-single {
  background: #F7F9FD;
  box-shadow: 0px -1px 0px #DDE8FF, 0px 1px 0px #DDE8FF;
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 30px;
  margin-bottom: 20px;
}

.dashboard-section.account .notification-single h6 {
  font-weight: 600;
  margin: 0;
}

.dashboard-section.account .notification-single .switch {
  position: relative;
  display: inline-block;
  min-width: 53px;
  height: 25px;
  margin-left: 15px;
}

.dashboard-section.account .notification-single .switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.dashboard-section.account .notification-single .switch input:checked + .slider {
  background-color: #571ce0;
}

.dashboard-section.account .notification-single .switch input:focus + .slider {
  box-shadow: 0 0 1px #571ce0;
}

.dashboard-section.account .notification-single .switch .slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: var(--border-color);
  transition: 0.4s;
}

.dashboard-section.account .notification-single .switch .slider::before {
  position: absolute;
  content: "";
  height: 18px;
  width: 18px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  transition: 0.4s;
}

.dashboard-section.account .notification-single .switch .slider.round {
  border-radius: 24px;
}

.dashboard-section.account .notification-single .switch .slider.round::before {
  border-radius: 50%;
}

.dashboard-section.account .notification-single .switch input:checked + .slider:before {
  transform: translateX(26px);
}

.card-popup .modal-dialog {
  max-width: 520px;
}

.card-popup .modal-content .modal-header {
  position: absolute;
  right: 15px;
  top: 15px;
  padding: 0;
}

.card-popup .modal-content .modal-header button {
  padding: 8px;
  margin: 0;
  background: #643DD8;
  border-radius: 5px;
  z-index: 1;
  border: none;
  display: flex;
  align-items: center;
  justify-content: center;
}

.card-popup .modal-content .modal-header button i {
  color: var(--bs-white);
}

.card-popup .modal-content .main-content {
  padding: 30px 30px 0;
  position: relative;
  z-index: 0;
}

.card-popup .modal-content .main-content::before {
  position: absolute;
  content: '';
  width: 100%;
  height: 20%;
  background: #5732C6;
  top: 0;
  left: 0;
  z-index: -1;
}

.card-popup .modal-content .main-content .top-area .text-area h5 {
  font-weight: 600;
  margin-bottom: 5px;
}

.card-popup .modal-content .main-content .tab-area ul {
  justify-content: space-between;
  border: none;
}

.card-popup .modal-content .main-content .tab-area ul li {
  display: flex;
  align-items: center;
}

.card-popup .modal-content .main-content .tab-area ul li .btn-link {
  color: #5732C6;
  margin-right: 20px;
}

.card-popup .modal-content .main-content .tab-area ul li button {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  text-decoration: none;
  color: #E2305B;
  padding: 8px;
  font-weight: 500;
}

.card-popup .modal-content .main-content .tab-area ul li img {
  margin-right: 5px;
}

.card-popup .modal-content .main-content .bottom-area .history {
  font-weight: 600;
}

.card-popup .modal-content .main-content .bottom-area .history span {
  color: #5732C6;
}

.card-popup .modal-content .main-content .bottom-area li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  border-bottom: 1px solid #EFEFEF;
}

.card-popup .modal-content .main-content .bottom-area li:first-child {
  border-top: 1px solid #EFEFEF;
  margin-top: 10px;
}

.card-popup .modal-content .main-content .bottom-area li span {
  display: block;
  font-size: 16px;
}

.card-popup .modal-content .main-content .bottom-area li p {
  padding: 10px 25px;
}

.card-popup .modal-content .main-content .bottom-area li p span:first-child {
  font-weight: bold;
}

.card-popup .modal-content .main-content .tab-content .transfer-area p:first-child {
  border-bottom: 1px solid #B4B8D8;
  margin-bottom: 20px;
  padding-bottom: 25px;
  font-weight: 600;
}

.card-popup .modal-content .main-content .tab-content form .input-area {
  display: flex;
  align-items: center;
  padding: 15px 20px;
  border: 1px solid #ACB1C8;
  border-radius: 20px;
}

.card-popup .modal-content .main-content .tab-content form .input-area input {
  padding: 0;
  margin: 0;
  padding-right: 25px;
  border: none;
  font-weight: bold;
}

.card-popup .modal-content .main-content .tab-content .nice-select {
  border-radius: 10px;
  border: none;
  background-color: transparent;
  padding: 10px 25px;
  color: var(--bs-white);
  display: flex;
  align-items: center;
}

.card-popup .modal-content .main-content .tab-content .nice-select::after {
  border-bottom: 2px solid #000000;
  border-right: 2px solid #000000;
  height: 8px;
  width: 8px;
  right: 14px;
  top: initial;
}

.card-popup .modal-content .main-content .tab-content .nice-select .current {
  position: relative;
  display: flex;
  align-items: center;
  font-weight: 600;
}

.card-popup .modal-content .main-content .tab-content .nice-select .current::before {
  position: absolute;
  content: "";
  width: 30px;
  height: 30px;
  left: -40px;
  background-image: url(/images/icon/flag-usa.png);
  background-repeat: no-repeat;
}

.card-popup .modal-content .main-content .tab-content .nice-select .list {
  width: 100%;
}

.card-popup .modal-content .main-content .tab-content .bottom-area {
  margin: 30px 0;
}

.card-popup.recipients .modal-content .main-content::before {
  height: 15%;
}

.card-popup.recipients .modal-content .main-content .tab-area ul {
  gap: 20px;
}

.card-popup.recipients .modal-content .main-content .tab-area ul li {
  width: 47%;
}

.card-popup.recipients .modal-content .main-content .tab-area ul li button {
  width: 100%;
  font-size: 16px;
  text-align: start;
  color: var(--para-color);
}

.transactions-popup .modal-header {
  background: #F6F5FF;
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}

.transactions-popup .modal-dialog {
  max-width: 880px;
}

.transactions-popup .modal-dialog .modal-content {
  border-radius: 20px;
}

.transactions-popup .modal-dialog .modal-content .modal-header {
  padding: 30px;
}

.transactions-popup .modal-dialog .modal-content .modal-header h6 {
  font-weight: 700;
}

.transactions-popup .modal-dialog .modal-content .modal-header button {
  margin: 0;
  z-index: 1;
  border: none;
  background: none;
  background-color: var(--bs-white);
  border-radius: 50%;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.transactions-popup .modal-dialog .modal-content .modal-header button:focus {
  box-shadow: none;
}

.transactions-popup .modal-dialog .modal-content .modal-header button i {
  color: #797979;
  font-size: 24px;
}

.transactions-popup .modal-dialog .modal-content .icon-area {
  padding: 40px 0;
}

.transactions-popup .modal-dialog .modal-content .text-area h3, .transactions-popup .modal-dialog .modal-content .text-area h6 {
  font-weight: 700;
}

.transactions-popup .modal-dialog .modal-content .text-area p {
  margin: 20px 0;
}

.transactions-popup .modal-dialog .modal-content .text-area .com {
  color: #49C96D;
  font-weight: 700;
}

.transactions-popup .modal-dialog .modal-content .right-area {
  padding: 30px;
  border-left: 1px solid #E6E5FF;
}

.transactions-popup .modal-dialog .modal-content .right-area h6 {
  font-weight: 700;
  margin-bottom: 10px;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-details {
  padding: 10px 0;
  border-top: 1px solid #E6E6FF;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-details li {
  padding: 10px 0;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-details li:last-child {
  border-top: 1px solid #E6E6FF;
  border-bottom: 1px solid #E6E6FF;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-info li {
  margin-top: 15px;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-info li p {
  color: #000000;
}

.transactions-popup .modal-dialog .modal-content .right-area .payment-info li span {
  color: #696D8D;
}

.transactions-popup.mycard .main-content {
  padding: 40px;
}

.transactions-popup.mycard .modal-header {
  background: transparent;
  position: absolute;
  right: 0;
  padding: 5px !important;
}

.transactions-popup.mycard .right-area {
  padding-top: 0 !important;
  padding-bottom: 0 !important;
}

.transactions-popup.mycard .right-area .card-details {
  border: 1px solid #E8E9EB;
  padding: 5px 20px;
  border-radius: 20px;
}

.transactions-popup.mycard .right-area .card-details img {
  margin-right: 10px;
}

.transactions-popup.mycard .right-area .payment-details {
  border: none !important;
}

.transactions-popup.mycard .right-area .payment-details li {
  border: none !important;
}

.pagination li {
  margin: 0 5px;
}

.pagination .page-item, .pagination .page-link {
  width: 34px;
  height: 34px;
  background: #F8F8F8;
  border-radius: 10px;
  border: none;
  color: var(--para-color);
  display: flex;
  justify-content: center;
  align-items: center;
}

.pagination .page-item:first-child, .pagination .page-item:last-child, .pagination .page-link:first-child, .pagination .page-link:last-child {
  border-radius: 10px;
}

.pagination .page-item i, .pagination .page-link i {
  font-size: 14px;
}

.pagination .page-item:hover, .pagination .page-item.active, .pagination .page-link:hover, .pagination .page-link.active {
  background-color: #5B2EDF;
  color: var(--bs-white);
}

.transfer-popup .modal-header {
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}

.transfer-popup .modal-dialog {
  max-width: 480px;
}

.transfer-popup .modal-dialog .modal-content {
  border-radius: 20px;
  padding: 30px;
}

.transfer-popup .modal-dialog .modal-content .modal-header {
  padding: 0;
  border: none;
}

.transfer-popup .modal-dialog .modal-content .modal-header a {
  display: flex;
  align-items: center;
}

.transfer-popup .modal-dialog .modal-content .modal-header a i {
  margin-right: 5px;
}

.transfer-popup .modal-dialog .modal-content .modal-header h6 {
  font-weight: 700;
}

.transfer-popup .modal-dialog .modal-content .modal-header button {
  margin: 0;
  z-index: 1;
  border: none;
  background: none;
  background-color: var(--bs-white);
  border-radius: 50%;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.transfer-popup .modal-dialog .modal-content .modal-header button:focus {
  box-shadow: none;
}

.transfer-popup .modal-dialog .modal-content .modal-header button i {
  color: #797979;
  font-size: 24px;
}

.transfer-popup .modal-dialog .modal-content .main-content h4 {
  font-weight: 600;
  margin-bottom: 15px;
}

.transfer-popup .modal-dialog .modal-content .main-content form .userInput {
  display: flex;
  margin: 30px 0;
}

.transfer-popup .modal-dialog .modal-content .main-content form .userInput input {
  text-align: center;
  margin: 0 15px;
}

.transfer-popup .modal-dialog .modal-content .main-content form .userInput input:first-child {
  margin-left: 0;
}

.transfer-popup .modal-dialog .modal-content .main-content form .userInput input:last-child {
  margin-right: 0;
}

.transfer-popup .modal-dialog .modal-content .main-content form button {
  background: #5732C6;
  border: 1px solid #AAA9E3;
  display: flex;
  border-radius: 10px;
  width: 100%;
  justify-content: center;
  padding: 10px;
  color: var(--bs-white);
}

.transfer-popup .modal-dialog #success .modal-content {
  background: #5732C6;
  width: 180%;
}

.transfer-popup .modal-dialog #success .modal-header {
  justify-content: end;
}

.transfer-popup .modal-dialog #success h3 {
  margin: 25px 0 10px;
  font-weight: 600;
}

.transfer-popup .modal-dialog #success h3, .transfer-popup .modal-dialog #success p {
  color: var(--bs-white);
}

.purchased-popup .modal-header {
  padding: 0;
  border: none;
}

.purchased-popup .modal-header a {
  display: flex;
  align-items: center;
}

.purchased-popup .modal-header a i {
  margin-right: 5px;
}

.purchased-popup .modal-header button {
  margin: 0;
  position: absolute;
  right: 10px;
  top: 10px;
  z-index: 1;
  border: none;
  background: none;
  display: flex;
  align-items: center;
  justify-content: center;
}

.purchased-popup .modal-header button:focus {
  box-shadow: none;
}

.purchased-popup .modal-header button i {
  color: #EFF4FF;
  font-size: 24px;
}

.purchased-popup .modal-content {
  background: #5732C6;
  border-radius: 20px;
}

.purchased-popup .modal-dialog {
  max-width: 480px;
}

.purchased-popup .main-content h5 {
  font-weight: 700;
  color: var(--bs-white);
  width: 80%;
  margin: auto;
}

.purchased-popup .main-content h5 span {
  font-weight: inherit;
  font-size: inherit;
  color: #05FF00;
}

.purchased-popup .main-content ul {
  border: 1px solid #E4E4E4;
  border-radius: 20px;
  padding: 30px;
  margin: 0 30px;
  margin-top: 40px;
}

.purchased-popup .main-content ul li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 15px;
}

.purchased-popup .main-content ul li:last-child {
  margin-bottom: 0;
}

.purchased-popup .main-content ul li span {
  color: var(--bs-white);
}

.purchased-popup.congratulations-popup .main-content h4, .purchased-popup.congratulations-popup .main-content p, .purchased-popup.congratulations-popup .main-content a {
  color: var(--bs-white);
}

.purchased-popup.congratulations-popup .main-content p {
  margin: auto;
  width: 60%;
}

.purchased-popup.congratulations-popup .main-content a {
  padding: 8px 20px;
  background: #5F3DC4;
  border: 1px solid #6A4BC8;
  border-radius: 10px;
}

.add-card .modal-header {
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}

.add-card .modal-dialog {
  max-width: 400px;
}

.add-card .modal-dialog .modal-content {
  border-radius: 20px;
}

.add-card .modal-dialog .modal-content .modal-header {
  border-bottom: none;
  padding: 20px;
}

.add-card .modal-dialog .modal-content .modal-header h6 {
  font-weight: 700;
}

.add-card .modal-dialog .modal-content .modal-header button {
  margin: 0;
  z-index: 1;
  border: none;
  background: none;
  background-color: var(--bs-white);
  border-radius: 50%;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.add-card .modal-dialog .modal-content .modal-header button:focus {
  box-shadow: none;
}

.add-card .modal-dialog .modal-content .modal-header button i {
  color: #797979;
  font-size: 24px;
}

.add-card .modal-dialog .modal-content form {
  padding: 0 30px 30px 30px;
}

.add-card .modal-dialog .modal-content form .single-input {
  margin-bottom: 20px;
}

.add-card .modal-dialog .modal-content form .single-input .select-area, .add-card .modal-dialog .modal-content form .single-input input {
  background: #F9F9F9;
  border: 1px solid #D0D3E8;
  border-radius: 10px;
}

.add-card .modal-dialog .modal-content form .single-input .select-area input {
  border: none;
  border-left: 1px solid #D0D3E8;
  border-top-left-radius: 0;
  border-bottom-left-radius: 0;
}

.add-recipients .modal-header {
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}

.add-recipients .modal-dialog {
  max-width: 400px;
}

.add-recipients .modal-dialog .modal-content {
  border-radius: 20px;
}

.add-recipients .modal-dialog .modal-content .modal-header {
  border-bottom: none;
  padding: 20px;
}

.add-recipients .modal-dialog .modal-content .modal-header h6 {
  font-weight: 700;
}

.add-recipients .modal-dialog .modal-content .modal-header button {
  margin: 0;
  z-index: 1;
  border: none;
  background: none;
  background-color: var(--bs-white);
  border-radius: 50%;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.add-recipients .modal-dialog .modal-content .modal-header button:focus {
  box-shadow: none;
}

.add-recipients .modal-dialog .modal-content .modal-header button i {
  color: #797979;
  font-size: 24px;
}

.add-recipients .modal-dialog .modal-content .nav-tabs {
  justify-content: center;
  border: none;
}

.add-recipients .modal-dialog .modal-content .nav-tabs li button {
  background: #F7F9FD;
  border: 1px solid #DDE8FF;
  border-radius: 20px;
  display: flex;
  align-items: center;
  padding: 15px 25px;
  margin: 0 10px;
  color: #7D7F93;
  transition: 0.3s;
}

.add-recipients .modal-dialog .modal-content .nav-tabs li button .icon-area {
  background: #FFFFFF;
  border: 1px solid #E0DDFF;
  border-radius: 20px;
  margin-right: 10px;
  width: 40px;
  height: 40px;
}

.add-recipients .modal-dialog .modal-content .nav-tabs li button:hover, .add-recipients .modal-dialog .modal-content .nav-tabs li button.active {
  background: #5732C6;
  color: var(--bs-white);
}

.add-recipients .modal-dialog .modal-content .tab-content form {
  padding: 30px;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input {
  margin-bottom: 30px;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .select-area, .add-recipients .modal-dialog .modal-content .tab-content form .single-input input {
  background: #F9F9F9;
  border: 1px solid #D0D3E8;
  border-radius: 10px;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .select-area .nice-select, .add-recipients .modal-dialog .modal-content .tab-content form .single-input input .nice-select {
  border: none;
  display: flex;
  align-items: center;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .select-area input {
  border: none;
  border-left: 1px solid #D0D3E8;
  border-top-left-radius: 0;
  border-bottom-left-radius: 0;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .nice-select {
  float: initial;
  background: #F9F9F9;
  border: 1px solid #D0D3E8;
  border-radius: 10px;
  line-height: 50px;
  height: 50px;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .nice-select::after {
  width: 9px;
  height: 9px;
}

.add-recipients .modal-dialog .modal-content .tab-content form .single-input .nice-select .list {
  width: 100%;
}

@media (max-width: 1599px) {
  .dashboard-section.account .nav-tabs {
    justify-content: start;
  }
  .dashboard-section.account .nav-tabs .nav-link {
    margin-right: 20px;
  }
}

@media (max-width: 1399px) {
  .dashboard-section.transactions.recipients .filters-item .search-area {
    width: 80%;
  }
  .dashboard-section {
    margin-left: 110px;
    width: calc(100% - 100px);
  }
  .header-section.body-collapse {
    margin-left: 140px;
    width: calc(100% - 140px);
  }
  .dashboard-section.body-collapse {
    margin-left: 110px;
    width: calc(100% - 100px);
  }
  .header-section.body-collapse .sidebar-wrapper {
    width: 270px;
    left: -290px;
  }
  .header-section .sidebar-wrapper {
    width: 130px;
  }
  .header-section .sidebar-wrapper.active .close-btn {
    display: none;
  }
  .header-section .sidebar-wrapper .close-btn {
    display: block;
  }
}

@media (max-width: 699px) {
  .header-section.body-collapse,
  .header-section,
  .dashboard-section.body-collapse,
  .dashboard-section {
    width: calc(100%);
    margin-left: 0;
  }
  .header-section.body-collapse .sidebar-wrapper,
  .header-section .sidebar-wrapper,
  .dashboard-section.body-collapse .sidebar-wrapper,
  .dashboard-section .sidebar-wrapper {
    left: -420px;
  }
  .header-section .sidebar-wrapper {
    width: 270px;
  }
  .header-section .sidebar-wrapper ul li a {
    justify-content: start;
  }
  .header-section .sidebar-wrapper ul li img {
    margin-right: 10px;
    width: auto;
  }
  .header-section .sidebar-wrapper ul li span {
    display: block;
  }
  .header-section .sidebar-wrapper.active {
    left: 0;
  }
  .header-section .sidebar-wrapper.active .close-btn {
    display: block;
  }
  .header-section .sidebar-wrapper .invite-now {
    display: block;
  }
  .header-section .sidebar-wrapper .close-btn {
    display: block;
  }
  .header-section .sidebar-wrapper {
    opacity: 1;
    visibility: visible;
    left: -150px !important;
  }
  .header-section .sidebar-wrapper.active {
    opacity: 0;
    visibility: hidden;
  }
}

@media (max-width: 1199px) {
  h1, h1 > a {
    font-size: 57px;
    line-height: 74.1px;
    margin-top: -16px;
  }
  h2, h2 > a {
    font-size: 43px;
    line-height: 55.9px;
    margin-top: -10px;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .nav-link,
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-item {
    font-size: 16px;
  }
  .banner-section .overlay .banner-content {
    padding: 220px 0 230px;
  }
  .banner-section.inner-banner .overlay .banner-content {
    padding: 215px 0 100px;
  }
  .dashboard-section.account .nav-tabs {
    justify-content: start;
  }
  .dashboard-section.account .nav-tabs .nav-link {
    margin-right: 20px;
  }
  .dashboard-section.account .owner-details {
    margin-bottom: 30px;
  }
  .dashboard-section.pay.step .main-content .choose-recipient .recipient-list button {
    padding: 10px;
    margin-bottom: 20px;
    margin-right: 20px;
  }
  .dashboard-section.pay.step .main-content .choose-recipient .recipient-list button i {
    font-size: 20px !important;
  }
  .dashboard-section.exchange .side-area {
    margin-top: 30px;
  }
  .dashboard-section.pay.step.exchange .main-content .user-select .single-user {
    display: grid;
  }
  .dashboard-section.pay.step.exchange .main-content .user-select .single-user .right {
    margin-top: 20px;
  }
  .dashboard-section.pay.step.exchange .main-content .user-select .single-user .right a {
    padding: 5px 25px;
    margin-left: 0;
    margin-right: 15px;
  }
  .header-section .navbar-area {
    padding: 10px 20px;
  }
  .dashboard-section .acc-details .top-area {
    padding: 20px;
  }
  .dashboard-section .acc-details .bottom-area {
    margin-top: 15px;
  }
  .dashboard-section.transactions.recipients .filters-item .search-area {
    width: 45%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file {
    margin-bottom: 55px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
    width: 120%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -45px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    bottom: -54px;
  }
  .dashboard-section .transactions-area .table-responsive .table {
    width: 130%;
  }
}

@media (max-width: 991px) {
  h1, h1 > a {
    font-size: 57px;
    line-height: 68.4px;
    margin-top: -16px;
  }
  h2, h2 > a {
    font-size: 43px;
    line-height: 51.6px;
    margin-top: -10px;
  }
  h3, h3 > a {
    font-size: 32px;
    line-height: 38.4px;
    margin-top: -8px;
  }
  h4, h4 > a {
    font-size: 24px;
    line-height: 28px;
    margin-top: -6px;
  }
  h5, h5 > a {
    font-size: 18px;
    line-height: 22px;
    margin-top: -4px;
  }
  h6, h6 > a, table thead tr th, a, p, span, li {
    font-size: 16px;
    line-height: 22px;
  }
  .section-header {
    margin-bottom: 40px;
  }
  .title {
    margin-bottom: 20px;
  }
  .xxlr {
    font-size: 20px;
    line-height: 28px;
  }
  .xlr {
    font-size: 18px;
    line-height: 25.5px;
  }
  .header-section .navbar-toggler {
    display: inline-block;
  }
  .header-section .navbar .navbar-brand {
    margin-top: -5px;
    width: 35%;
  }
  .header-section .navbar .navbar-brand img {
    max-width: initial;
  }
  .header-section .navbar .navbar-collapse .navbar-nav {
    height: 200px;
    margin: 20px 0;
    overflow-y: auto;
    margin-bottom: 10px;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu .dropend .dropdown-menu {
    left: 60px;
  }
  .header-section .nav-item.main-navbar .main-menu .sub-navbar .sub-menu {
    right: 0;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu.show {
    display: inline-block;
    margin-left: 130px;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item .dropdown-menu {
    display: none;
  }
  .header-section .navbar .navbar-collapse .navbar-nav .nav-item {
    padding: 8px 0;
  }
  .header-section .nav-item.dropdown .dropdown-menu {
    position: initial;
  }
  .header-section .navbar .navbar-collapse .right-area .lang {
    display: none !important;
  }
  .header-section .navbar .navbar-collapse .right-area {
    margin-left: 0;
  }
  .dashboard-section {
    padding-top: 40px;
  }
  .dashboard-section .side-items {
    margin-top: 30px;
  }
  .dashboard-section.crypto .table {
    width: 160%;
  }
  .dashboard-section.crypto .left-area ul li a {
    line-height: 30px;
  }
  .dashboard-section.crypto .spend-get {
    padding: 30px;
    display: grid;
    gap: 20px;
  }
  .dashboard-section.pay.step-2 .main-content .pay-option {
    background: #F8F8FF;
    display: grid;
  }
  .dashboard-section.pay.step-2 .main-content .pay-option .nice-select {
    margin-left: 20px;
  }
  .dashboard-section.pay.step-2 .main-content .pay-option .border-area {
    border: none;
  }
  .dashboard-section.pay.step-2 .main-content .exchange-content {
    display: grid;
    gap: 0;
  }
  .dashboard-section.pay.step-2 .main-content .exchange-content .recipient::after {
    top: -40px;
    left: calc(50%);
  }
  .dashboard-section.pay.step-2 .main-content .exchange-content .recipient::before {
    top: -30px;
    left: calc(52%);
  }
  .dashboard-section .footer-area a {
    padding: 12px 35px;
  }
  .dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single {
    display: grid;
  }
  .dashboard-section.pay.step-2 .main-content .pay-option .pay-option-single .nice-select {
    margin-left: 0;
  }
  .add-recipients .modal-dialog .modal-content .nav-tabs li button .icon-area {
    display: flex;
    align-items: center;
    justify-content: center;
  }
  .dashboard-section.transactions.recipients .filters-item {
    display: grid !important;
  }
  .dashboard-section.transactions.recipients .filters-item .search-area {
    width: 100%;
  }
  .dashboard-section .transactions-area .table-responsive .table {
    width: 100%;
  }
  .dashboard-section.transactions.recipients .table {
    width: 130%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file {
    margin-bottom: 40px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
    width: 90%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -40px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    bottom: -35px;
  }
  .dashboard-section.transactions .transactions-main .filters-item .single-item button {
    padding-left: 10px;
    margin-left: 0;
  }
}

@media (max-width: 767px) {
  .header-section .navbar-area .dashboard-nav {
    margin-left: 30px;
    gap: 20px;
  }
  .header-section .navbar-area .sidebar-icon {
    margin-right: 40px;
  }
  .transactions-popup .modal-dialog .modal-content .right-area {
    padding: 15px;
  }
  .dashboard-section.account .upload-avatar {
    display: grid;
  }
  .dashboard-section.account .file-upload {
    margin-top: 20px;
  }
  .dashboard-section.account .file-upload .file .file-custom::before {
    left: 0;
  }
  .dashboard-section.account form .input-status .col-6 {
    width: 100% !important;
  }
  .dashboard-section.account form .input-status .col-6 span {
    margin-top: 15px;
  }
  .dashboard-section.account .tab-main {
    padding: 20px;
  }
  .dashboard-section.account .single-content {
    padding: 20px;
  }
  .dashboard-section.crypto .left-area {
    position: initial;
  }
  .dashboard-section.crypto .checkbox-single .checkbox-area .checkmark {
    left: 30px;
  }
  .dashboard-section.pay.step .main-content .user-select .single-user {
    display: grid;
  }
  .dashboard-section.pay.step .main-content .user-select .single-user .right {
    margin-top: 20px;
  }
  .dashboard-section.pay.step .main-content .user-select .single-user .right a {
    justify-content: center;
  }
  .dashboard-section.transactions.recipients .filters-item .right-area {
    display: grid !important;
  }
  .dashboard-section.transactions.recipients .filters-item .single-item .nice-select {
    padding-left: 0;
  }
  .dashboard-section.transactions.recipients .table {
    width: 185%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file {
    margin-bottom: 55px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
    width: 65%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -40px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    bottom: -55px;
  }
  .dashboard-section.transactions .transactions-main .filters-item {
    display: grid;
    gap: 20px;
  }
  .dashboard-section.transactions .transactions-main .filters-item .nice-select {
    width: 100%;
  }
  .dashboard-section.transactions .transactions-main .table {
    width: 145%;
  }
  .dashboard-section.transactions .head-area h4 {
    margin-bottom: 20px;
  }
}

@media (max-width: 575px) {
  h1, h1 > a {
    font-size: 40px;
    line-height: 46px;
    margin-top: -9px;
  }
  h2, h2 > a {
    font-size: 30px;
    line-height: 36px;
    margin-top: -7px;
  }
  h3, h3 > a {
    font-size: 24px;
    line-height: 28px;
    margin-top: -6px;
  }
  h4, h4 > a {
    font-size: 18px;
    line-height: 22px;
    margin-top: -4px;
  }
  a, p, span, li, .cmn-btn, thead tr th, tbody tr th, tbody tr td, input, label, textarea, h6, h6 > a {
    font-size: 15px;
    line-height: 19px;
  }
  .section-header {
    margin-bottom: 30px;
  }
  .title {
    margin-bottom: 15px;
  }
  .xxlr {
    font-size: 18px;
    line-height: 25.5px;
  }
  .xlr {
    font-size: 16px;
    line-height: 22.4px;
  }
  .header-section .navbar {
    padding: 20px 15px;
  }
  .header-section .navbar-area .dashboard-nav .single-item .main-area {
    width: 300px;
    padding: 20px;
    border-radius: 10px;
    border-radius: 10px;
  }
  .dashboard-section .transactions-area .table-responsive table {
    width: 110%;
  }
  .card-popup .modal-dialog {
    max-width: initial;
  }
  .transactions-popup .modal-dialog .modal-content .right-area {
    padding: 20px;
    border: none;
  }
  .transactions-popup.mycard .main-content {
    padding: 30px;
  }
  .preloader {
    background-size: 50%;
  }
  .transfer-popup .modal-dialog,
  .add-recipients .modal-dialog,
  .add-card .modal-dialog {
    margin: auto;
  }
  .dashboard-section.account .card-area .card-content {
    width: 100%;
  }
  .dashboard-section.account .your-devices .single-setting,
  .dashboard-section.account .single-content {
    display: grid !important;
  }
  .dashboard-section.account .your-devices .single-setting .right,
  .dashboard-section.account .single-content .right {
    margin-top: 15px;
  }
  .dashboard-section.account .change-pass form {
    margin-top: 30px;
  }
  .dashboard-section.crypto .table-area {
    padding: 0;
  }
  .dashboard-section.pay.step .main-content form {
    margin-top: 0;
  }
  .dashboard-section.crypto .exchange-content .recipient::before {
    left: calc(50% - 12px);
  }
  .dashboard-section.crypto .exchange-content .recipient::after {
    left: calc(45%);
  }
  .card-popup .modal-content .main-content .tab-content .bottom-area {
    display: grid !important;
    margin: 0;
    margin-top: 20px;
  }
  .card-popup .modal-content .main-content .tab-content .bottom-area a {
    margin-bottom: 20px;
  }
  .dashboard-section.deposit-money .table-area {
    padding: 30px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file {
    margin-bottom: 55px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
    width: 60%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -30px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    bottom: -50px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom::before {
    left: 10px;
  }
  .dashboard-section {
    padding-left: 15px;
    padding-right: 15px;
    padding-bottom: 20px;
  }
  .dashboard-section.account .file-upload .file {
    width: 100%;
    margin-bottom: 15px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -10px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    display: none;
  }
}

@media (max-width: 480px) {
  .header-section .navbar-area .dashboard-nav {
    margin-left: 10px;
    gap: 15px;
  }
  .header-section .navbar-area .sidebar-icon {
    margin-right: 20px;
  }
  .header-section .navbar-area .dashboard-nav .single-item .main-area {
    padding: 15px;
  }
  .dashboard-section .acc-details .top-area {
    display: grid;
    align-items: center;
    justify-content: space-between;
    padding: 30px;
  }
  .dashboard-section .acc-details .right-side {
    margin-top: 30px;
  }
  .dashboard-section .acc-details .top-area .right-top {
    justify-content: start;
    padding-left: 15px;
  }
  .dashboard-section .acc-details .bottom-area {
    margin-top: 20px;
  }
  .dashboard-section .transactions-area .table-responsive table {
    width: 140%;
  }
  .dashboard-section.account .additional-security .single-setting {
    display: grid !important;
  }
  .dashboard-section.account .additional-security .single-setting .right {
    margin-top: 15px;
  }
  .dashboard-section.account .single-content button {
    font-size: 15px;
  }
  .dashboard-section.account .notification-single {
    padding: 20px;
    margin-bottom: 15px;
  }
  .transactions-popup.mycard .modal-dialog .modal-content .right-area {
    padding: 0;
  }
  .transactions-popup.mycard .modal-dialog .modal-content .right-area .top-area {
    display: grid !important;
  }
  .transactions-popup.mycard .modal-dialog .modal-content .right-area .top-area a {
    margin-top: 10px;
  }
  .transactions-popup.mycard .main-content {
    padding: 20px;
  }
  .dashboard-section.pay .main-content {
    padding: 15px;
  }
  .dashboard-section.crypto .exchange-content .send-banance {
    padding: 15px;
    margin-top: 20px;
  }
  .dashboard-section.crypto .exchange-content .send-banance .input-area {
    padding: 5px 12px;
    margin: 10px 0;
  }
  .dashboard-section .main-content .footer-area a {
    margin: 0 10px;
    padding: 12px 12px;
  }
  .dashboard-section.crypto .exchange-content .recipient::before {
    left: calc(50% - 0px);
  }
  .dashboard-section.crypto .spend-get {
    padding: 20px;
    display: grid;
  }
  .dashboard-section.crypto .spend-get .get {
    margin-top: 15px;
  }
  .card-popup .modal-content .main-content .tab-area ul {
    margin-bottom: 20px;
  }
  .card-popup .modal-content .main-content .tab-area ul li {
    margin-bottom: 15px;
  }
  .card-popup .modal-content .main-content .bottom-area li p {
    padding: 10px 0;
  }
  .dashboard-section.pay.step-3 .payment-details .details-list li {
    display: grid;
    text-align: start;
  }
  .dashboard-section.pay.step-3 .payment-details .top-area {
    display: grid;
    justify-content: start;
  }
  .dashboard-section.pay.step-3 .payment-details .top-area .right {
    text-align: start;
  }
  .dashboard-section.pay.step-3 .payment-details .top-area a {
    background: #F7F9FD;
    border: 1px solid #DDE8FF;
    border-radius: 20px;
    padding: 5px 20px;
    transition: 0.3s;
    margin-top: 15px;
  }
  .dashboard-section.pay.step-2 .main-content .send-banance {
    border-radius: 10px;
    padding: 15px;
    margin-top: 20px;
  }
  .dashboard-section.pay.step-2 .main-content .exchange-content .recipient::before {
    top: -30px;
    left: calc(45%);
  }
  .dashboard-section.pay.step-2 .main-content .exchange-content .recipient::after {
    top: -40px;
    left: calc(42%);
  }
  .dashboard-section.pay.step-2 .main-content .send-banance .input-area {
    padding: 10px 20px;
  }
  .add-recipients .modal-dialog .modal-content .nav-tabs li button {
    padding: 10px 14px;
  }
  .dashboard-section.pay.receive-3 .request-submitted .top-area .icon-area img {
    max-width: 60%;
  }
  .dashboard-section.transactions.recipients .table {
    width: 225%;
  }
  .card-popup.recipients .modal-content .main-content .tab-area ul li {
    width: 100%;
    margin-bottom: 0;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2 {
    width: 60%;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -10px;
    left: 20px;
  }
  .pagination .page-item, .pagination .page-link {
    width: 30px;
    height: 30px;
  }
  .pagination li {
    margin: 0 3px;
  }
  .dashboard-section.transactions .transactions-main .top-items {
    display: grid;
  }
  .dashboard-section.transactions .transactions-main .top-items ul {
    margin-top: 15px;
  }
  .dashboard-section.transactions .transactions-main .top-items ul li {
    margin-left: 0;
    margin-right: 15px;
  }
  .header-section .navbar-area {
    padding: 10px 20px;
  }
  .dashboard-section.transactions .transactions-main .table {
    width: 155%;
  }
}

@media (max-width: 375px) {
  .about .col-6 {
    width: 100% !important;
  }
  .header-section .navbar-area form .form-group img {
    display: none;
  }
  .header-section .navbar-area form .form-group {
    padding: 0;
  }
  .dashboard-section .transactions-area .table-responsive table {
    width: 180%;
  }
  .dashboard-section .side-items .single-item {
    padding: 15px;
  }
  .dashboard-section .side-items .single-item .recipients-item .left {
    margin-right: 15px;
  }
  .dashboard-section.crypto .table {
    width: 175%;
  }
  .dashboard-section.crypto .checkbox-single .item-title .img-area {
    margin-left: 50px;
    width: initial;
    height: initial;
    min-width: 45px;
    min-height: 45px;
  }
  .add-recipients .modal-dialog .modal-content .nav-tabs li button {
    margin-bottom: 15px;
  }
  .dashboard-section.transactions.recipients .table {
    width: 300%;
  }
  .dashboard-section.pay.step-2 .main-content .user-select .right {
    display: grid !important;
  }
  .dashboard-section.pay.step-2 .main-content .user-select .right a {
    margin-left: 0;
    margin-bottom: 15px;
  }
  .dashboard-section.pay.step-2 .main-content .total-fees {
    padding: 20px;
  }
  .dashboard-section.crypto .checkbox-single {
    padding: 20px;
  }
  .dashboard-section.crypto .checkbox-single .checkbox-area .checkmark {
    left: 15px;
  }
  .dashboard-section.deposit-money .table-area {
    padding: 15px;
  }
  .dashboard-section.exchange .side-area .deposit-details li {
    display: grid;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::before {
    top: -20px;
    left: 40px;
  }
  .dashboard-section.pay.receive-3 .attach-documents .file-upload .file .file-custom2::after {
    display: none;
  }
  .preloader {
    background-size: 60%;
  }
  .dashboard-section.transactions .transactions-main .table {
    width: 220%;
  }
  .purchased-popup .main-content ul {
    padding: 15px;
    margin: 0 15px;
    margin-top: 30px;
  }
  .dashboard-section.account .nav-tabs .nav-link {
    padding: 13px 25px;
  }
  .dashboard-section.pay.step .main-content .choose-recipient .recipient-list {
    margin-bottom: 15px;
  }
}
/*# sourceMappingURL=style.css.map */

</style>
@endpush
