@extends($activeTemplate . 'layouts.frontend')
@section('content')
<section class="banner-section blog-details" >
    <div class="overlay" style="background-image: url('{{ frontendImage('blog', @$blog->data_values->image, '1245x840') }}');">
        <div class="banner-content">
            <div class="container wow fadeInUp">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-8 col-md-7">
                        <div class="main-content text-center"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="blog-details-section">
        <div class="overlay pb-120">
            <div class="container wow fadeInUp">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <div class="main-content">
                            <div class="head-area">
                                <div class="left-area d-flex align-items-center">
                                    <div class="date">
                                        <p>{{ $blog->created_at->diffForHumans() }}</p>
                                    </div>
                                </div>
                                <div class="right-area">
                                    <div class="social-link d-flex justify-content-md-end justify-content-start align-items-center">
                                        <a href="http://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"><i class="lab la-facebook-f"></i></a>
                                        <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}"><i class="lab la-linkedin-in"></i></a>
                                        <a href="https://www.instagram.com/?url={{ urlencode(url()->current()) }}"><i class="lab la-instagram"></i></a>
                                        <a href="https://twitter.com/intent/tweet?text=my share text&amp;url={{ urlencode(url()->current()) }}"><i class="lab la-twitter"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="single-content mb-60">
                                <h2 class="title">{{ __($blog->data_values->title) }}</h2>
                            </div>
                            <div class="single-content">
                                <p>@php echo $blog->data_values->description; @endphp</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog details end -->

    <!-- Blog Section start -->
    <section class="blog-section details">
        <div class="overlay pb-120">
            <div class="container wow fadeInUp" style="visibility: visible; animation-name: fadeInUp;">
                <div class="row blog-section-content pt-120 justify-content-center justify-content-center">
                    <div class="col-xl-12">
                        <div class="section-text d-flex align-items-center justify-content-between">
                            <h2>@lang('Recent Posts')</h2>
                            <a href="{{route('blog')}}" class="cmn-btn">Browse all articles</a>
                        </div>
                    </div>
                </div>
                <div class="row cus-mar">
                    @foreach ($recentBlogs as $blog)
                    <div class="col-lg-4 col-md-6">
                        <div class="single-post">
                            <div class="thumbnail">
                                <img src="{{ frontendImage('blog', 'thumb_' . @$blog->data_values->image, '415x280') }}" alt="image">
                            </div>
                            <div class="blog-text">
                                <p class="date">{{ $blog->created_at->diffForHumans() }}</p>
                                <a href="{{ route('blog.details', $blog->slug) }}"><h5>{{ __($blog->data_values->title) }}</h5></a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection

@push('style')
<style>
    .banner-section.blog-details .overlay {
      background-image: url("{{ frontendImage('blog', @$blog->data_values->image, '1245x840') }}");
/*}*/
</style>
@endpush


@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
